/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cache;

import java.util.Collections;
import java.util.List;
import org.atmosphere.cache.AbstractBroadcasterCache;
import org.atmosphere.cache.BroadcastMessage;
import org.atmosphere.cache.CacheMessage;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderBroadcasterCache
extends AbstractBroadcasterCache {
    private final Logger logger = LoggerFactory.getLogger(HeaderBroadcasterCache.class);

    @Override
    public CacheMessage addToCache(String broadcasterId, AtmosphereResource r, BroadcastMessage e) {
        List list;
        if (r != null && !this.bannedResources.isEmpty() && (list = (List)this.bannedResources.get(broadcasterId)) != null && list.contains(r.uuid())) {
            return null;
        }
        long now = System.nanoTime();
        CacheMessage cacheMessage = this.put(e, now);
        if (r != null) {
            r.getResponse().setHeader("X-Cache-Date", String.valueOf(now));
        }
        return cacheMessage;
    }

    @Override
    public List<Object> retrieveFromCache(String broadcasterId, AtmosphereResource r) {
        List list;
        if (r == null) {
            throw new IllegalArgumentException("AtmosphereResource can't be null");
        }
        if (!this.bannedResources.isEmpty() && (list = (List)this.bannedResources.get(broadcasterId)) != null && list.contains(r.uuid())) {
            return this.emptyList;
        }
        AtmosphereRequest request = r.getRequest();
        String cacheHeader = request.getHeader("X-Cache-Date");
        r.getResponse().setHeader("X-Cache-Date", String.valueOf(System.nanoTime()));
        if (cacheHeader == null || cacheHeader.isEmpty()) {
            return Collections.emptyList();
        }
        long cacheHeaderTime = 0L;
        if (!cacheHeader.isEmpty()) {
            cacheHeaderTime = Long.valueOf(cacheHeader);
        }
        return this.get(cacheHeaderTime);
    }
}

