/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.atmosphere.cache.AbstractBroadcasterCache;
import org.atmosphere.cache.BroadcastMessage;
import org.atmosphere.cache.CacheMessage;
import org.atmosphere.cpr.AtmosphereResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionBroadcasterCache
extends AbstractBroadcasterCache {
    private static final Logger logger = LoggerFactory.getLogger(SessionBroadcasterCache.class);
    private static final String ERROR_MESSAGE = "Session was null. The request has been recycled by the underlying container";

    @Override
    public CacheMessage addToCache(String broadcasterId, AtmosphereResource r, BroadcastMessage message) {
        List list;
        if (r != null && !this.bannedResources.isEmpty() && (list = (List)this.bannedResources.get(broadcasterId)) != null && list.contains(r.uuid())) {
            return null;
        }
        long now = System.nanoTime();
        CacheMessage cacheMessage = this.put(message, now);
        if (r == null) {
            return cacheMessage;
        }
        try {
            HttpSession session = r.session();
            if (session == null) {
                logger.error(ERROR_MESSAGE);
                return cacheMessage;
            }
            session.setAttribute(broadcasterId, String.valueOf(now));
        }
        catch (IllegalStateException ex) {
            logger.trace("", ex);
            logger.warn("The Session has been invalidated. Message will be loat.");
        }
        return cacheMessage;
    }

    @Override
    public List<Object> retrieveFromCache(String broadcasterId, AtmosphereResource r) {
        List list;
        if (r == null) {
            throw new IllegalArgumentException("AtmosphereResource can't be null");
        }
        if (!this.bannedResources.isEmpty() && (list = (List)this.bannedResources.get(broadcasterId)) != null && list.contains(r.uuid())) {
            return this.emptyList;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            HttpSession session = r.session();
            if (session == null) {
                logger.error(ERROR_MESSAGE);
                return result;
            }
            String cacheHeaderTimeStr = (String)session.getAttribute(broadcasterId);
            if (cacheHeaderTimeStr == null) {
                return result;
            }
            Long cacheHeaderTime = Long.valueOf(cacheHeaderTimeStr);
            if (cacheHeaderTime == null) {
                return result;
            }
            return this.get(cacheHeaderTime);
        }
        catch (IllegalStateException ex) {
            logger.trace("", ex);
            logger.warn("The Session has been invalidated. Unable to retrieve cached messages");
            return Collections.emptyList();
        }
    }
}

