/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.websocket.Endpoint;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerEndpointConfig;
import org.atmosphere.container.JSR356Endpoint;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSR356ServerApplicationConfig
implements ServerApplicationConfig {
    private static final Logger logger = LoggerFactory.getLogger(JSR356ServerApplicationConfig.class);
    private final AtmosphereConfigurator configurator = new AtmosphereConfigurator();

    public Set<ServerEndpointConfig> getEndpointConfigs(Set<Class<? extends Endpoint>> endpointClasses) {
        logger.debug("{} detected by the WebServer", (Object)JSR356ServerApplicationConfig.class.getName());
        return new HashSet<ServerEndpointConfig>(){
            {
                this.add(ServerEndpointConfig.Builder.create(JSR356Endpoint.class, (String)"/{path}").configurator((ServerEndpointConfig.Configurator)JSR356ServerApplicationConfig.this.configurator).build());
                this.add(ServerEndpointConfig.Builder.create(JSR356Endpoint.class, (String)"/{path}/{path2}").configurator((ServerEndpointConfig.Configurator)JSR356ServerApplicationConfig.this.configurator).build());
                this.add(ServerEndpointConfig.Builder.create(JSR356Endpoint.class, (String)"/{path}/{path2}/{path3}").configurator((ServerEndpointConfig.Configurator)JSR356ServerApplicationConfig.this.configurator).build());
                this.add(ServerEndpointConfig.Builder.create(JSR356Endpoint.class, (String)"/{path}/{path2}/{path3}/{path4}").configurator((ServerEndpointConfig.Configurator)JSR356ServerApplicationConfig.this.configurator).build());
            }
        };
    }

    public Set<Class<?>> getAnnotatedEndpointClasses(Set<Class<?>> scanned) {
        return Collections.emptySet();
    }

    public static final class AtmosphereConfigurator
    extends ServerEndpointConfig.Configurator {
        public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
            if (JSR356Endpoint.class.isAssignableFrom(endpointClass)) {
                AtmosphereConfig config = BroadcasterFactory.getDefault().lookup("/*", true).getBroadcasterConfig().getAtmosphereConfig();
                AtmosphereFramework f = config.framework();
                return (T)((Object)new JSR356Endpoint(f, WebSocketProcessorFactory.getDefault().getWebSocketProcessor(f)));
            }
            return (T)super.getEndpointInstance(endpointClass);
        }
    }
}

