/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.atmosphere.config.service.AsyncSupportListenerService;
import org.atmosphere.config.service.AsyncSupportService;
import org.atmosphere.config.service.AtmosphereHandlerService;
import org.atmosphere.config.service.AtmosphereInterceptorService;
import org.atmosphere.config.service.BroadcasterCacheInspectorService;
import org.atmosphere.config.service.BroadcasterCacheService;
import org.atmosphere.config.service.BroadcasterFactoryService;
import org.atmosphere.config.service.BroadcasterFilterService;
import org.atmosphere.config.service.BroadcasterListenerService;
import org.atmosphere.config.service.BroadcasterService;
import org.atmosphere.config.service.EndpoinMapperService;
import org.atmosphere.config.service.ManagedService;
import org.atmosphere.config.service.MeteorService;
import org.atmosphere.config.service.WebSocketHandlerService;
import org.atmosphere.config.service.WebSocketProcessorService;
import org.atmosphere.config.service.WebSocketProtocolService;
import org.atmosphere.cpr.AnnotationHandler;
import org.atmosphere.cpr.AnnotationProcessor;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.util.annotation.AnnotationDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAnnotationProcessor
implements AnnotationProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAnnotationProcessor.class);
    public static final String ANNOTATION_ATTRIBUTE = "org.atmosphere.cpr.ANNOTATION_MAP";
    private AnnotationProcessor delegate;

    @Override
    public AnnotationProcessor configure(AtmosphereFramework framework) {
        ServletContext sc = framework.getServletContext();
        Map annotations = (Map)sc.getAttribute(ANNOTATION_ATTRIBUTE);
        this.delegate = annotations == null ? new BytecodeBasedAnnotationProcessor() : new ServletContainerInitializerAnnotationProcessor(annotations, framework);
        this.delegate.configure(framework);
        return this;
    }

    @Override
    public AnnotationProcessor scan(File rootDir) throws IOException {
        this.delegate.scan(rootDir);
        return this;
    }

    @Override
    public AnnotationProcessor scan(String packageName) throws IOException {
        this.delegate.scan(packageName);
        return this;
    }

    @Override
    public void destroy() {
        if (this.delegate != null) {
            this.delegate.destroy();
        }
    }

    private static final class BytecodeBasedAnnotationProcessor
    implements AnnotationProcessor {
        protected AnnotationDetector detector;

        @Override
        public AnnotationProcessor configure(final AtmosphereFramework framework) {
            AnnotationDetector.TypeReporter reporter = new AnnotationDetector.TypeReporter(){

                @Override
                public Class<? extends Annotation>[] annotations() {
                    return new Class[]{AtmosphereHandlerService.class, BroadcasterCacheService.class, BroadcasterFilterService.class, BroadcasterFactoryService.class, BroadcasterService.class, MeteorService.class, WebSocketHandlerService.class, WebSocketProtocolService.class, AtmosphereInterceptorService.class, BroadcasterListenerService.class, AsyncSupportService.class, AsyncSupportListenerService.class, WebSocketProcessorService.class, BroadcasterCacheInspectorService.class, ManagedService.class, EndpoinMapperService.class};
                }

                @Override
                public void reportTypeAnnotation(Class<? extends Annotation> annotation, String className) {
                    logger.info("Found Annotation in {} being scanned: {}", (Object)className, annotation);
                    try {
                        Class<?> discoveredClass = BytecodeBasedAnnotationProcessor.this.loadClass(className);
                        AnnotationHandler.handleAnnotation(framework, annotation, discoveredClass);
                    }
                    catch (Exception e) {
                        logger.warn("Could not load discovered class", e);
                    }
                }
            };
            this.detector = new AnnotationDetector(reporter);
            return this;
        }

        @Override
        public AnnotationProcessor scan(File rootDir) throws IOException {
            this.detector.detect(rootDir);
            return this;
        }

        @Override
        public AnnotationProcessor scan(String packageName) throws IOException {
            logger.trace("Scanning @Service annotations in {}", (Object)packageName);
            this.detector.detect(packageName);
            return this;
        }

        @Override
        public void destroy() {
            this.detector.destroy();
        }

        protected Class<?> loadClass(String className) throws Exception {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            catch (Throwable t) {
                return this.getClass().getClassLoader().loadClass(className);
            }
        }
    }

    private static final class ServletContainerInitializerAnnotationProcessor
    implements AnnotationProcessor {
        private final Map<Class<? extends Annotation>, Set<Class<?>>> annotations;
        private final AtmosphereFramework framework;
        private boolean alreadyScanned = false;

        private ServletContainerInitializerAnnotationProcessor(Map<Class<? extends Annotation>, Set<Class<?>>> annotations, AtmosphereFramework framework) {
            this.annotations = annotations;
            this.framework = framework;
        }

        @Override
        public AnnotationProcessor configure(AtmosphereFramework framework) {
            return this;
        }

        @Override
        public AnnotationProcessor scan(File rootDir) throws IOException {
            if (this.alreadyScanned) {
                return this;
            }
            this.alreadyScanned = true;
            for (Map.Entry<Class<Annotation>, Set<Class<?>>> entry : this.annotations.entrySet()) {
                for (Class<?> clazz : entry.getValue()) {
                    AnnotationHandler.handleAnnotation(this.framework, entry.getKey(), clazz);
                }
            }
            return this;
        }

        @Override
        public AnnotationProcessor scan(String packageName) throws IOException {
            for (Map.Entry<Class<Annotation>, Set<Class<?>>> entry : this.annotations.entrySet()) {
                for (Class<?> clazz : entry.getValue()) {
                    if (!clazz.getPackage().getName().startsWith(packageName)) continue;
                    AnnotationHandler.handleAnnotation(this.framework, entry.getKey(), clazz);
                }
            }
            return this;
        }

        @Override
        public void destroy() {
        }
    }
}

