/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import java.io.IOException;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOInterceptorAdapter;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.interceptor.AllowInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaddingAtmosphereInterceptor
extends AtmosphereInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(PaddingAtmosphereInterceptor.class);
    private static final byte[] padding;
    private static final String paddingText;

    @Override
    public void configure(AtmosphereConfig config) {
    }

    private void writePadding(AtmosphereResponse response) {
        AtmosphereRequest request = response.request();
        if (request != null && request.getAttribute("paddingWritten") != null) {
            return;
        }
        if (response.resource().transport().equals((Object)AtmosphereResource.TRANSPORT.STREAMING)) {
            request.setAttribute(FrameworkConfig.TRANSPORT_IN_USE, "streaming");
            response.setContentType("text/plain");
        }
        response.write(padding, true);
        try {
            response.flushBuffer();
        }
        catch (IOException e) {
            logger.trace("", e);
        }
    }

    @Override
    public Action inspect(final AtmosphereResource r) {
        final AtmosphereResponse response = r.getResponse();
        if (r.transport().equals((Object)AtmosphereResource.TRANSPORT.STREAMING) || r.transport().equals((Object)AtmosphereResource.TRANSPORT.LONG_POLLING)) {
            r.addEventListener(new ForcePreSuspend(response));
            super.inspect(r);
            AsyncIOWriter writer = response.getAsyncIOWriter();
            if (AtmosphereInterceptorWriter.class.isAssignableFrom(writer.getClass())) {
                ((AtmosphereInterceptorWriter)AtmosphereInterceptorWriter.class.cast(writer)).interceptor(new AsyncIOInterceptorAdapter(){

                    private void padding() {
                        if (!r.isSuspended()) {
                            PaddingAtmosphereInterceptor.this.writePadding(response);
                            r.getRequest().setAttribute("paddingWritten", "true");
                        }
                    }

                    @Override
                    public void prePayload(AtmosphereResponse response2, byte[] data, int offset, int length) {
                        this.padding();
                    }

                    @Override
                    public void postPayload(AtmosphereResponse response2, byte[] data, int offset, int length) {
                    }
                });
            } else {
                logger.warn("Unable to apply {}. Your AsyncIOWriter must implement {}", (Object)this.getClass().getName(), (Object)AtmosphereInterceptorWriter.class.getName());
            }
        }
        return Action.CONTINUE;
    }

    public String toString() {
        return "Browser Padding Interceptor Support";
    }

    static {
        StringBuilder whitespace = new StringBuilder();
        for (int i = 0; i < 8192; ++i) {
            whitespace.append(" ");
        }
        whitespace.append("\n");
        paddingText = whitespace.toString();
        padding = paddingText.getBytes();
    }

    public final class ForcePreSuspend
    extends AtmosphereResourceEventListenerAdapter
    implements AllowInterceptor {
        private final AtmosphereResponse response;

        public ForcePreSuspend(AtmosphereResponse response) {
            this.response = response;
        }

        @Override
        public void onPreSuspend(AtmosphereResourceEvent event) {
            PaddingAtmosphereInterceptor.this.writePadding(this.response);
        }
    }
}

