/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOInterceptorAdapter;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.interceptor.AllowInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSEAtmosphereInterceptor
extends AtmosphereInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(SSEAtmosphereInterceptor.class);
    private static final byte[] padding;
    private static final String paddingText;
    private static final byte[] END;

    private boolean writePadding(AtmosphereResponse response) {
        if (response.request() != null && response.request().getAttribute("paddingWritten") != null) {
            return false;
        }
        response.setContentType("text/event-stream");
        response.setCharacterEncoding("utf-8");
        boolean isUsingStream = (Boolean)response.request().getAttribute("org.atmosphere.useStream");
        if (isUsingStream) {
            ServletOutputStream stream = null;
            try {
                stream = response.getResponse().getOutputStream();
            }
            catch (IOException e) {
                logger.trace("", e);
            }
            try {
                stream.write(padding);
                stream.flush();
            }
            catch (IOException ex) {
                logger.warn("SSE may not work", ex);
            }
        } else {
            PrintWriter w = null;
            try {
                w = response.getResponse().getWriter();
            }
            catch (IOException e) {
                logger.trace("", e);
            }
            w.println(paddingText);
            w.flush();
        }
        response.resource().getRequest().setAttribute("paddingWritten", "true");
        return true;
    }

    @Override
    public Action inspect(final AtmosphereResource r) {
        final AtmosphereResponse response = r.getResponse();
        if (r.transport().equals((Object)AtmosphereResource.TRANSPORT.SSE)) {
            super.inspect(r);
            r.addEventListener(new P(response));
            AsyncIOWriter writer = response.getAsyncIOWriter();
            if (AtmosphereInterceptorWriter.class.isAssignableFrom(writer.getClass())) {
                ((AtmosphereInterceptorWriter)AtmosphereInterceptorWriter.class.cast(writer)).interceptor(new AsyncIOInterceptorAdapter(){

                    private boolean padding() {
                        if (!r.isSuspended()) {
                            return SSEAtmosphereInterceptor.this.writePadding(response);
                        }
                        return false;
                    }

                    @Override
                    public void prePayload(AtmosphereResponse response2, byte[] data, int offset, int length) {
                        boolean noPadding = this.padding();
                        if (!noPadding) {
                            response2.write("data:", true);
                        }
                    }

                    @Override
                    public void postPayload(AtmosphereResponse response2, byte[] data, int offset, int length) {
                        String ua;
                        if (r.isSuspended()) {
                            response2.write(END, true);
                        }
                        if ((ua = r.getRequest().getHeader("User-Agent")) != null && ua.contains("MSIE")) {
                            try {
                                response2.flushBuffer();
                            }
                            catch (IOException e) {
                                logger.trace("", e);
                            }
                            r.resume();
                        }
                    }
                });
            } else {
                logger.warn("Unable to apply {}. Your AsyncIOWriter must implement {}", (Object)this.getClass().getName(), (Object)AtmosphereInterceptorWriter.class.getName());
            }
        }
        return Action.CONTINUE;
    }

    public String toString() {
        return "SSE Interceptor Support";
    }

    static {
        END = "\n\n".getBytes();
        StringBuffer whitespace = new StringBuffer();
        for (int i = 0; i < 2000; ++i) {
            whitespace.append(" ");
        }
        whitespace.append("\n");
        paddingText = whitespace.toString();
        padding = paddingText.getBytes();
    }

    private final class P
    extends AtmosphereResourceEventListenerAdapter
    implements AllowInterceptor {
        private final AtmosphereResponse response;

        private P(AtmosphereResponse response) {
            this.response = response;
        }

        @Override
        public void onPreSuspend(AtmosphereResourceEvent event) {
            SSEAtmosphereInterceptor.this.writePadding(this.response);
        }
    }
}

