/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.servlet.Servlet;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.nettosphere.Handler;
import org.atmosphere.nettosphere.util.SSLContextListener;
import org.atmosphere.websocket.WebSocketProtocol;
import org.atmosphere.websocket.protocol.SimpleHttpProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger logger = LoggerFactory.getLogger(Config.class);
    private final Builder b;

    public Config(Builder b) {
        this.b = b;
    }

    public String host() {
        return this.b.host;
    }

    public int port() {
        return this.b.port;
    }

    public Map<String, String> initParams() {
        return this.b.initParams;
    }

    public List<String> path() {
        return this.b.paths;
    }

    public String configFile() {
        return this.b.atmosphereDotXmlPath;
    }

    public Class<Broadcaster> broadcaster() {
        return this.b.broadcasterClass;
    }

    public Map<String, AtmosphereHandler> handlersMap() {
        return this.b.handlers;
    }

    public BroadcasterFactory broadcasterFactory() {
        return this.b.broadcasterFactory;
    }

    public Class<? extends BroadcasterCache> broadcasterCache() {
        return this.b.broadcasterCache;
    }

    public Class<? extends WebSocketProtocol> webSocketProtocol() {
        return this.b.webSocketProtocol;
    }

    public List<AtmosphereInterceptor> interceptors() {
        return this.b.interceptors;
    }

    public String scanLib() {
        return this.b.librariesPath;
    }

    public List<Class<?>> scanPackages() {
        return this.b.packages;
    }

    public String mappingPath() {
        return this.b.mappingPath;
    }

    public SSLContext sslContext() {
        return this.b.context;
    }

    public SSLContextListener sslContextListener() {
        return this.b.listener;
    }

    public static final class Builder {
        private List<String> paths = new ArrayList<String>();
        private String atmosphereDotXmlPath = "/META-INF/atmosphere.xml";
        private String host = "localhost";
        private int port = 8080;
        private final Map<String, String> initParams = new HashMap<String, String>();
        private final Map<String, AtmosphereHandler> handlers = new HashMap<String, AtmosphereHandler>();
        private Class<? extends WebSocketProtocol> webSocketProtocol = SimpleHttpProtocol.class;
        private Class<Broadcaster> broadcasterClass;
        private BroadcasterFactory broadcasterFactory;
        private Class<? extends BroadcasterCache> broadcasterCache;
        private final List<AtmosphereInterceptor> interceptors = new ArrayList<AtmosphereInterceptor>();
        private String librariesPath = "." + File.separator + "lib";
        private String mappingPath = "";
        private final List<Class<?>> packages = new ArrayList();
        private SSLContext context;
        private SSLContextListener listener = SSLContextListener.DEFAULT;

        public Builder sslContext(SSLContext context) {
            this.context = context;
            return this;
        }

        public Builder sslContextListener(SSLContextListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder mappingPath(String mappingPath) {
            this.mappingPath = mappingPath;
            return this;
        }

        public Builder scanLibrary(String librariesPath) {
            this.librariesPath = librariesPath;
            return this;
        }

        public Builder configFile(String atmosphereDotXmlPath) {
            this.atmosphereDotXmlPath = atmosphereDotXmlPath;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder initParam(String name, String value) {
            this.initParams.put(name, value);
            return this;
        }

        public Builder resource(String path) {
            this.paths.add(path);
            return this;
        }

        public Builder resource(String path, AtmosphereHandler c) {
            this.handlers.put(path, c);
            return this;
        }

        public Builder resource(String path, Servlet c) {
            this.handlers.put(path, new ReflectorServletProcessor(c));
            return this;
        }

        public Builder resource(Handler handler) {
            return this.resource("/*", handler);
        }

        public Builder resource(String path, final Handler handler) {
            this.handlers.put(path, new AbstractReflectorAtmosphereHandler(){

                @Override
                public void onRequest(AtmosphereResource resource) throws IOException {
                    handler.handle(resource);
                }

                @Override
                public void destroy() {
                }
            });
            return this;
        }

        public Builder resource(Class<?> c) {
            this.packages.add(c);
            return this;
        }

        public Builder resource(String path, Class<?> c) {
            block4: {
                try {
                    if (AtmosphereHandler.class.isAssignableFrom(c)) {
                        this.handlers.put(path, (AtmosphereHandler)AtmosphereHandler.class.cast(c.newInstance()));
                        break block4;
                    }
                    if (Servlet.class.isAssignableFrom(c)) {
                        this.handlers.put(path, new ReflectorServletProcessor((Servlet)Servlet.class.cast(c.newInstance())));
                        break block4;
                    }
                    throw new IllegalStateException("You class must implements AtmosphereHandler or be a Servlet");
                }
                catch (Exception ex) {
                    logger.error("Invalid resource {}", c);
                }
            }
            return this;
        }

        public Builder broadcaster(Class<Broadcaster> broadcasterClass) {
            this.broadcasterClass = broadcasterClass;
            return this;
        }

        public Builder broadcasterFactory(BroadcasterFactory broadcasterFactory) {
            this.broadcasterFactory = broadcasterFactory;
            return this;
        }

        public Builder broadcasterCache(Class<? extends BroadcasterCache> broadcasterCache) {
            this.broadcasterCache = broadcasterCache;
            return this;
        }

        public Builder webSocketProtocol(Class<? extends WebSocketProtocol> webSocketProtocol) {
            this.webSocketProtocol = webSocketProtocol;
            return this;
        }

        public Builder interceptor(AtmosphereInterceptor interceptor) {
            this.interceptors.add(interceptor);
            return this;
        }

        public Config build() {
            if (this.paths.isEmpty()) {
                this.paths.add("/");
            }
            return new Config(this);
        }
    }
}

