/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container.version;

import java.io.IOException;
import java.util.Arrays;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.websocket.WebSocket;

public final class GrizzlyWebSocket
extends WebSocket {
    private final com.sun.grizzly.websockets.WebSocket webSocket;

    public GrizzlyWebSocket(com.sun.grizzly.websockets.WebSocket webSocket, AtmosphereConfig config) {
        super(config);
        this.webSocket = webSocket;
    }

    @Override
    public boolean isOpen() {
        return this.webSocket.isConnected();
    }

    @Override
    public WebSocket write(String s) throws IOException {
        logger.trace("WebSocket.write() for {}", (Object)(this.resource() != null ? this.resource().uuid() : ""));
        this.webSocket.send(s);
        return this;
    }

    @Override
    public WebSocket write(byte[] data, int offset, int length) throws IOException {
        logger.trace("WebSocket.write() for {}", (Object)(this.resource() != null ? this.resource().uuid() : ""));
        this.webSocket.send(Arrays.copyOfRange(data, offset, length));
        return this;
    }

    @Override
    public void close() {
        logger.trace("WebSocket.close() for AtmosphereResource {}", (Object)(this.resource() != null ? this.resource().uuid() : "null"));
        this.webSocket.close();
    }

    @Override
    public WebSocket flush(AtmosphereResponse r) throws IOException {
        logger.trace("WebSocket.flush() not supported by Grizzly");
        return this;
    }
}

