/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.annotation.HandlesTypes;
import org.atmosphere.annotation.Processor;
import org.atmosphere.config.AtmosphereAnnotation;
import org.atmosphere.cpr.AnnotationHandler;
import org.atmosphere.cpr.AnnotationProcessor;
import org.atmosphere.cpr.AnnotationScanningServletContainerInitializer;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.util.annotation.AnnotationDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAnnotationProcessor
implements AnnotationProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAnnotationProcessor.class);
    public static final String ANNOTATION_ATTRIBUTE = "org.atmosphere.cpr.ANNOTATION_MAP";
    private AnnotationProcessor delegate;
    private final AnnotationHandler handler;
    private final AnnotationDetector.TypeReporter atmosphereReporter = new AnnotationDetector.TypeReporter(){

        @Override
        public Class<? extends Annotation>[] annotations() {
            return new Class[]{AtmosphereAnnotation.class};
        }

        @Override
        public void reportTypeAnnotation(Class<? extends Annotation> annotation, String className) {
            try {
                DefaultAnnotationProcessor.this.handler.handleProcessor(DefaultAnnotationProcessor.loadClass(this.getClass(), className));
            }
            catch (Exception e) {
                logger.warn("Error scanning @AtmosphereAnnotation", e);
            }
        }
    };

    public DefaultAnnotationProcessor() {
        this.handler = new AnnotationHandler();
    }

    @Override
    public AnnotationProcessor configure(AtmosphereFramework framework) {
        ServletContext sc = framework.getServletContext();
        Map annotations = (Map)sc.getAttribute(ANNOTATION_ATTRIBUTE);
        sc.removeAttribute(ANNOTATION_ATTRIBUTE);
        boolean scanForAtmosphereAnnotation = false;
        if (annotations == null || annotations.isEmpty()) {
            this.delegate = new BytecodeBasedAnnotationProcessor(this.handler);
            scanForAtmosphereAnnotation = true;
        } else {
            this.delegate = new ServletContainerInitializerAnnotationProcessor(this.handler, annotations, framework);
        }
        logger.info("AnnotationProcessor {} being used", this.delegate.getClass());
        if (scanForAtmosphereAnnotation) {
            this.scanForAnnotation(framework);
        }
        this.delegate.configure(framework);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanForAnnotation(AtmosphereFramework f) {
        List<String> packages = f.customAnnotationPackages();
        AnnotationDetector detector = new AnnotationDetector(this.atmosphereReporter);
        try {
            String path;
            if (packages.size() > 0) {
                for (String p : packages) {
                    logger.trace("Package {} scanned for @AtmosphereAnnotation", (Object)p);
                    detector.detect(p);
                }
            }
            if ((path = f.getHandlersPath()) != null) {
                detector.detect(new File(path));
            }
        }
        catch (IOException e) {
            logger.warn("Unable to scan annotation", e);
        }
        finally {
            detector.destroy();
        }
    }

    @Override
    public AnnotationProcessor scan(File rootDir) throws IOException {
        this.delegate.scan(rootDir);
        return this;
    }

    @Override
    public AnnotationProcessor scan(String packageName) throws IOException {
        this.delegate.scan(packageName);
        return this;
    }

    @Override
    public AnnotationProcessor scanAll() throws IOException {
        this.delegate.scanAll();
        return this;
    }

    @Override
    public void destroy() {
        if (this.delegate != null) {
            this.delegate.destroy();
            this.handler.destroy();
            this.delegate = null;
        }
    }

    private static Class<?> loadClass(Class thisClass, String className) throws Exception {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (Throwable t) {
            return thisClass.getClassLoader().loadClass(className);
        }
    }

    private static final class BytecodeBasedAnnotationProcessor
    implements AnnotationProcessor {
        protected AnnotationDetector detector;
        protected final AnnotationHandler handler;

        public BytecodeBasedAnnotationProcessor(AnnotationHandler handler) {
            this.handler = handler;
        }

        @Override
        public AnnotationProcessor configure(final AtmosphereFramework framework) {
            AnnotationDetector.TypeReporter reporter = new AnnotationDetector.TypeReporter(){

                @Override
                public Class<? extends Annotation>[] annotations() {
                    return BytecodeBasedAnnotationProcessor.this.handler.handledClass();
                }

                @Override
                public void reportTypeAnnotation(Class<? extends Annotation> annotation, String className) {
                    logger.info("Found Annotation in {} being scanned: {}", (Object)className, annotation);
                    try {
                        Class discoveredClass = DefaultAnnotationProcessor.loadClass(this.getClass(), className);
                        BytecodeBasedAnnotationProcessor.this.handler.handleAnnotation(framework, annotation, discoveredClass);
                    }
                    catch (Exception e) {
                        logger.warn("Could not load discovered class", e);
                    }
                }
            };
            this.detector = new AnnotationDetector(reporter);
            return this;
        }

        @Override
        public AnnotationProcessor scan(File rootDir) throws IOException {
            this.detector.detect(rootDir);
            return this;
        }

        @Override
        public AnnotationProcessor scan(String packageName) throws IOException {
            logger.trace("Scanning @Service annotations in {}", (Object)packageName);
            this.detector.detect(packageName);
            return this;
        }

        @Override
        public AnnotationProcessor scanAll() throws IOException {
            this.detector.detect();
            return this;
        }

        @Override
        public void destroy() {
            this.detector.destroy();
        }
    }

    private static final class ServletContainerInitializerAnnotationProcessor
    implements AnnotationProcessor {
        private final Map<Class<? extends Annotation>, Set<Class<?>>> annotations;
        private final AtmosphereFramework framework;
        private final AnnotationHandler handler;
        private boolean alreadyScanned = false;

        private ServletContainerInitializerAnnotationProcessor(AnnotationHandler handler, Map<Class<? extends Annotation>, Set<Class<?>>> annotations, AtmosphereFramework framework) {
            this.annotations = annotations;
            this.framework = framework;
            this.handler = handler;
        }

        @Override
        public AnnotationProcessor configure(AtmosphereFramework framework) {
            return this;
        }

        @Override
        public AnnotationProcessor scan(File rootDir) throws IOException {
            if (this.alreadyScanned) {
                return this;
            }
            this.alreadyScanned = true;
            Set<Class<?>> atmosphereAnnotatedClasses = this.annotations.get(AtmosphereAnnotation.class);
            boolean handleAtmosphereAnnotation = this.handleAtmosphereAnnotation(atmosphereAnnotatedClasses);
            for (Map.Entry<Class<Annotation>, Set<Class<?>>> entry : this.annotations.entrySet()) {
                for (Class<?> clazz : entry.getValue()) {
                    this.handler.handleAnnotation(this.framework, entry.getKey(), clazz);
                }
            }
            if (handleAtmosphereAnnotation) {
                this.scanForCustomAnnotation(atmosphereAnnotatedClasses);
            }
            return this;
        }

        private boolean handleAtmosphereAnnotation(Set<Class<?>> atmosphereAnnotatedClasses) {
            boolean scanForCustomizedAnnotation = false;
            if (atmosphereAnnotatedClasses != null) {
                for (Class<?> clazz : atmosphereAnnotatedClasses) {
                    this.handler.handleProcessor(clazz);
                    if (atmosphereAnnotatedClasses.size() <= AnnotationScanningServletContainerInitializer.class.getAnnotation(HandlesTypes.class).value().length) continue;
                    scanForCustomizedAnnotation = true;
                }
                this.annotations.remove(AtmosphereAnnotation.class);
            } else {
                logger.error("No @AtmosphereService annotation found. Annotation won't work.");
            }
            return scanForCustomizedAnnotation;
        }

        private void scanForCustomAnnotation(Set<Class<?>> atmosphereAnnotatedClasses) throws IOException {
            BytecodeBasedAnnotationProcessor b = new BytecodeBasedAnnotationProcessor(this.handler);
            b.configure(this.framework);
            for (Class<?> clazz : atmosphereAnnotatedClasses) {
                if (!clazz.getPackage().getName().startsWith(Processor.class.getName())) continue;
                b.scan(clazz.getPackage().getName());
            }
            b.destroy();
        }

        @Override
        public AnnotationProcessor scan(String packageName) throws IOException {
            Set<Class<?>> atmosphereAnnotatedClasses = this.annotations.get(AtmosphereAnnotation.class);
            boolean handleAtmosphereAnnotation = this.handleAtmosphereAnnotation(atmosphereAnnotatedClasses);
            for (Map.Entry<Class<Annotation>, Set<Class<?>>> entry : this.annotations.entrySet()) {
                for (Class<?> clazz : entry.getValue()) {
                    if (!packageName.equals("all") && !clazz.getPackage().getName().startsWith(packageName)) continue;
                    this.handler.handleAnnotation(this.framework, entry.getKey(), clazz);
                }
            }
            if (handleAtmosphereAnnotation) {
                this.scanForCustomAnnotation(atmosphereAnnotatedClasses);
            }
            return this;
        }

        @Override
        public AnnotationProcessor scanAll() throws IOException {
            return this.scan("all");
        }

        @Override
        public void destroy() {
            this.annotations.clear();
        }
    }
}

