/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.nettosphere.AtmosphereChannelPipelineFactory;
import org.atmosphere.nettosphere.BridgeRuntime;
import org.atmosphere.nettosphere.Config;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Nettosphere {
    private static final Logger logger = LoggerFactory.getLogger(Nettosphere.class);
    private static final ChannelGroup ALL_CHANNELS = new DefaultChannelGroup("atmosphere");
    private final ChannelPipelineFactory pipelineFactory;
    private final ServerBootstrap bootstrap;
    private final SocketAddress localSocket;
    private final BridgeRuntime handler;
    private final AtomicBoolean started = new AtomicBoolean();

    private Nettosphere(Config config) {
        this.handler = new BridgeRuntime(config);
        this.pipelineFactory = new AtmosphereChannelPipelineFactory(this.handler);
        this.localSocket = new InetSocketAddress(config.host(), config.port());
        this.bootstrap = this.buildBootstrap();
    }

    public void start() {
        Channel serverChannel = this.bootstrap.bind(this.localSocket);
        ALL_CHANNELS.add(serverChannel);
        this.started.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.handler.destroy();
            ChannelGroupFuture future = ALL_CHANNELS.close();
            future.awaitUninterruptibly();
            this.bootstrap.getFactory().releaseExternalResources();
            ALL_CHANNELS.clear();
        }
        finally {
            this.started.set(false);
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    private ServerBootstrap buildBootstrap() {
        ServerBootstrap bootstrap = new ServerBootstrap(new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), Executors.newCachedThreadPool()));
        bootstrap.setPipelineFactory(this.pipelineFactory);
        return bootstrap;
    }

    public static void main(String[] args) throws Exception {
        Config.Builder b = new Config.Builder();
        b.resource(args[0]).port(8080).host("127.0.0.1");
        Nettosphere s = new Nettosphere(b.build());
        s.start();
        String a = "";
        logger.info("NettoSphere Server started");
        logger.info("Type quit to stop the server");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while (!a.equals("quit")) {
            a = br.readLine();
        }
        System.exit(-1);
    }

    public static final class Builder {
        private Config config = new Config.Builder().build();

        public Builder config(Config config) {
            this.config = config;
            return this;
        }

        public Nettosphere build() {
            return new Nettosphere(this.config);
        }
    }
}

