/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran.action;

import ch.qos.logback.classic.util.JNDIUtil;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.util.OptionHelper;
import javax.naming.Context;
import javax.naming.NamingException;
import org.xml.sax.Attributes;

public class InsertFromJNDIAction
extends Action {
    public static String ENV_ENTRY_NAME_ATTR = "env-entry-name";
    public static String AS_ATTR = "as";

    public void begin(InterpretationContext ec, String name, Attributes attributes) {
        String lineColStr;
        int errorCount = 0;
        String envEntryName = attributes.getValue(ENV_ENTRY_NAME_ATTR);
        String asName = attributes.getValue(AS_ATTR);
        if (OptionHelper.isEmpty(envEntryName)) {
            lineColStr = this.getLineColStr(ec);
            this.addError("[" + ENV_ENTRY_NAME_ATTR + "] missing, around " + lineColStr);
            ++errorCount;
        }
        if (OptionHelper.isEmpty(asName)) {
            lineColStr = this.getLineColStr(ec);
            this.addError("[" + AS_ATTR + "] missing, around " + lineColStr);
            ++errorCount;
        }
        if (errorCount != 0) {
            return;
        }
        try {
            Context ctx = JNDIUtil.getInitialContext();
            String envEntryValue = JNDIUtil.lookup(ctx, envEntryName);
            if (OptionHelper.isEmpty(envEntryValue)) {
                this.addError("[" + envEntryName + "] has null or empty value");
            } else {
                this.addInfo("Setting context variable [" + asName + "] to [" + envEntryValue + "]");
                this.context.putProperty(asName, envEntryValue);
            }
        }
        catch (NamingException e) {
            this.addError("Failed to lookup JNDI env-entry [" + envEntryName + "]");
        }
    }

    public void end(InterpretationContext ec, String name) {
    }
}

