/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.DefaultWebSocket;
import com.sun.grizzly.websockets.WebSocketApplication;
import org.atmosphere.container.GlassFishWebSocketSupport;
import org.atmosphere.container.version.GrizzlyWebSocket;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlassFishWebSocketHandler
extends WebSocketApplication {
    private static final Logger logger = LoggerFactory.getLogger(GlassFishWebSocketSupport.class);
    private final AtmosphereConfig config;
    private final String contextPath;
    private final WebSocketProcessor webSocketProcessor;
    private WebSocket webSocket;

    public GlassFishWebSocketHandler(AtmosphereConfig config) {
        this.config = config;
        this.contextPath = config.getServletContext().getContextPath();
        this.webSocketProcessor = WebSocketProcessorFactory.getDefault().getWebSocketProcessor(config.framework());
    }

    public void onConnect(com.sun.grizzly.websockets.WebSocket w) {
        super.onConnect(w);
        this.webSocket = new GrizzlyWebSocket(w, this.config);
        if (!DefaultWebSocket.class.isAssignableFrom(w.getClass())) {
            throw new IllegalStateException();
        }
        DefaultWebSocket dws = (DefaultWebSocket)DefaultWebSocket.class.cast(w);
        try {
            AtmosphereRequest r = AtmosphereRequest.wrap(dws.getRequest());
            AtmosphereResponse response = AtmosphereResponse.newInstance(this.config, r, this.webSocket);
            this.config.framework().configureRequestResponse(r, response);
            try {
                if (r.getPathInfo().startsWith(r.getContextPath())) {
                    r.servletPath(r.getPathInfo().substring(r.getContextPath().length()));
                    r.pathInfo(null);
                }
            }
            catch (Exception e) {
                logger.trace("", e);
            }
            this.webSocketProcessor.open(this.webSocket, r, response);
        }
        catch (Exception e) {
            logger.warn("failed to connect to web socket", e);
        }
    }

    public boolean isApplicationRequest(Request request) {
        return request.requestURI().startsWith(this.contextPath);
    }

    public void onClose(com.sun.grizzly.websockets.WebSocket w, DataFrame df) {
        super.onClose(w, df);
        logger.trace("onClose {} ", w);
        if (this.webSocketProcessor != null) {
            this.webSocketProcessor.close(this.webSocket, 1000);
        }
    }

    public void onMessage(com.sun.grizzly.websockets.WebSocket w, String text) {
        logger.trace("onMessage {} ", w);
        if (this.webSocketProcessor != null) {
            this.webSocketProcessor.invokeWebSocketProtocol(this.webSocket, text);
        }
    }

    public void onMessage(com.sun.grizzly.websockets.WebSocket w, byte[] bytes) {
        logger.trace("onMessage (bytes) {} ", w);
        if (this.webSocketProcessor != null) {
            this.webSocketProcessor.invokeWebSocketProtocol(this.webSocket, bytes, 0, bytes.length);
        }
    }

    public void onPing(com.sun.grizzly.websockets.WebSocket w, byte[] bytes) {
        logger.trace("onPing (bytes) {} ", w);
    }

    public void onPong(com.sun.grizzly.websockets.WebSocket w, byte[] bytes) {
        logger.trace("onPong (bytes) {} ", w);
    }

    public void onFragment(com.sun.grizzly.websockets.WebSocket w, byte[] bytes, boolean last) {
        logger.trace("onFragment (bytes) {} ", w);
    }

    public void onFragment(com.sun.grizzly.websockets.WebSocket w, String text, boolean last) {
        logger.trace("onFragment (string) {} ", w);
    }
}

