/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.BroadcasterListener;
import org.atmosphere.util.uri.UriTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaBroadcaster {
    public static final String MAPPING_REGEX = "[/a-zA-Z0-9-&.*=;\\?]+";
    private static final Logger logger = LoggerFactory.getLogger(MetaBroadcaster.class);
    private static final MetaBroadcaster metaBroadcaster = new MetaBroadcaster();
    private static final ConcurrentLinkedQueue<BroadcasterListener> broadcasterListeners = new ConcurrentLinkedQueue();

    protected MetaBroadcasterFuture broadcast(String path, Object message, int time, TimeUnit unit, boolean delay) {
        if (BroadcasterFactory.getDefault() != null) {
            Collection<Broadcaster> c = BroadcasterFactory.getDefault().lookupAll();
            HashMap<String, String> m = new HashMap<String, String>();
            ArrayList<Broadcaster> l = new ArrayList<Broadcaster>();
            logger.trace("Map {}", (Object)path);
            UriTemplate t = new UriTemplate(path);
            for (Broadcaster b : c) {
                logger.trace("Trying to map {} to {}", t, (Object)b.getID());
                if (t.match((CharSequence)b.getID(), m)) {
                    l.add(b);
                }
                m.clear();
            }
            MetaBroadcasterFuture f = new MetaBroadcasterFuture(l);
            CompleteListener cl = new CompleteListener(f);
            for (Broadcaster b : l) {
                if (time <= 0) {
                    f.outerFuture(b.addBroadcasterListener(cl).broadcast(message));
                    continue;
                }
                if (!delay) {
                    f.outerFuture(b.scheduleFixedBroadcast(message, time, unit));
                    continue;
                }
                f.outerFuture(b.delayBroadcast(message, time, unit));
            }
            return f;
        }
        return new MetaBroadcasterFuture(Collections.emptyList());
    }

    protected MetaBroadcasterFuture map(String path, Object message, int time, TimeUnit unit, boolean delay) {
        if (path == null || path.isEmpty()) {
            throw new NullPointerException();
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (path.contains("*")) {
            path = path.replace("*", MAPPING_REGEX);
        }
        if (path.equals("/")) {
            path = path + MAPPING_REGEX;
        }
        return this.broadcast(path, message, time, unit, delay);
    }

    public Future<List<Broadcaster>> broadcastTo(String broadcasterID, Object message) {
        return this.map(broadcasterID, message, -1, null, false);
    }

    public Future<List<Broadcaster>> scheduleTo(String broadcasterID, Object message, int time, TimeUnit unit) {
        return this.map(broadcasterID, message, time, unit, false);
    }

    public Future<List<Broadcaster>> delayTo(String broadcasterID, Object message, int time, TimeUnit unit) {
        return this.map(broadcasterID, message, time, unit, true);
    }

    public static final MetaBroadcaster getDefault() {
        return metaBroadcaster;
    }

    public MetaBroadcaster addBroadcasterListener(BroadcasterListener b) {
        broadcasterListeners.add(b);
        return this;
    }

    public MetaBroadcaster removeBroadcasterListener(BroadcasterListener b) {
        broadcasterListeners.remove(b);
        return this;
    }

    private static final class MetaBroadcasterFuture
    implements Future<List<Broadcaster>> {
        private final CountDownLatch latch;
        private final List<Broadcaster> l;
        private boolean isCancelled = false;
        private final List<Future<?>> outerFuture = new ArrayList();

        private MetaBroadcasterFuture(List<Broadcaster> l) {
            this.latch = new CountDownLatch(l.size());
            this.l = l;
        }

        MetaBroadcasterFuture outerFuture(Future<?> f) {
            this.outerFuture.add(f);
            return this;
        }

        @Override
        public boolean cancel(boolean b) {
            for (Future<?> f : this.outerFuture) {
                f.cancel(b);
            }
            while (this.latch.getCount() > 0L) {
                this.latch.countDown();
            }
            this.isCancelled = true;
            return this.isCancelled;
        }

        @Override
        public boolean isCancelled() {
            return this.isCancelled;
        }

        @Override
        public boolean isDone() {
            return this.latch.getCount() == 0L;
        }

        @Override
        public List<Broadcaster> get() throws InterruptedException, ExecutionException {
            this.latch.await();
            return this.l;
        }

        @Override
        public List<Broadcaster> get(long t, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            this.latch.await(t, timeUnit);
            return this.l;
        }

        public void countDown() {
            this.latch.countDown();
        }
    }

    private static final class CompleteListener
    implements BroadcasterListener {
        private final MetaBroadcasterFuture f;

        private CompleteListener(MetaBroadcasterFuture f) {
            this.f = f;
        }

        @Override
        public void onPostCreate(Broadcaster b) {
        }

        @Override
        public void onComplete(Broadcaster b) {
            b.removeBroadcasterListener(this);
            this.f.countDown();
            if (this.f.isDone()) {
                for (BroadcasterListener l : broadcasterListeners) {
                    l.onComplete(b);
                }
            }
        }

        @Override
        public void onPreDestroy(Broadcaster b) {
        }
    }
}

