/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;

public final class SessionTimeoutRestorer
implements Serializable,
HttpSessionActivationListener {
    private static final long serialVersionUID = -126253550299206646L;
    private final int timeout;
    private final AtomicInteger requestCount = new AtomicInteger(0);

    public SessionTimeoutRestorer(int timeout) {
        this.timeout = timeout;
    }

    public void setup(HttpSession session) {
        int oldCount = this.requestCount.getAndIncrement();
        if (oldCount == 0) {
            this.refreshTimeout(session);
        }
    }

    public void restore(HttpSession session) {
        int count = this.requestCount.decrementAndGet();
        if (count == 0) {
            this.refreshTimeout(session);
        }
    }

    private synchronized void refreshTimeout(HttpSession session) {
        if (this.requestCount.get() > 0) {
            session.setMaxInactiveInterval(-1);
        } else {
            session.setMaxInactiveInterval(this.timeout);
        }
    }

    @Override
    public void sessionWillPassivate(HttpSessionEvent hse) {
        this.requestCount.set(0);
        this.refreshTimeout(hse.getSession());
    }

    @Override
    public void sessionDidActivate(HttpSessionEvent hse) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SessionTimeoutRestorer[timeout=");
        sb.append(this.timeout);
        sb.append(", requestCount=");
        sb.append(this.requestCount.get());
        sb.append(']');
        return sb.toString();
    }
}

