/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.atmosphere.container.NettyCometSupport;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereMappingException;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.nettosphere.ChannelAsyncIOWriter;
import org.atmosphere.nettosphere.Config;
import org.atmosphere.nettosphere.Context;
import org.atmosphere.nettosphere.HttpStaticFileServerHandler;
import org.atmosphere.nettosphere.NettyWebSocket;
import org.atmosphere.nettosphere.util.Version;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import org.jboss.netty.util.CharsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyAtmosphereHandler
extends HttpStaticFileServerHandler {
    private static final Logger logger = LoggerFactory.getLogger(NettyAtmosphereHandler.class);
    private final AtmosphereFramework framework;
    private final Config config;
    private WebSocketServerHandshaker handshaker;
    private final ScheduledExecutorService suspendTimer;

    public NettyAtmosphereHandler(Config config) {
        super(config.path());
        this.config = config;
        this.framework = new AtmosphereFramework();
        if (config.broadcaster() != null) {
            this.framework.setDefaultBroadcasterClassName(config.broadcaster().getName());
        }
        this.framework.setAtmosphereDotXmlPath(config.configFile());
        this.framework.setAsyncSupport(new NettyCometSupport(this.framework.getAtmosphereConfig()));
        try {
            if (config.broadcasterFactory() != null) {
                this.framework.setBroadcasterFactory(config.broadcasterFactory());
            }
        }
        catch (Throwable t) {
            logger.trace("", t);
        }
        if (config.broadcasterCache() != null) {
            try {
                this.framework.setBroadcasterCacheClassName(config.broadcasterCache().getName());
            }
            catch (Throwable t) {
                logger.trace("", t);
            }
        }
        Map<String, AtmosphereHandler> handlersMap = config.handlersMap();
        for (Map.Entry<String, AtmosphereHandler> e : handlersMap.entrySet()) {
            this.framework.addAtmosphereHandler(e.getKey(), e.getValue());
        }
        if (config.webSocketProtocol() != null) {
            this.framework.setWebSocketProtocolClassName(config.webSocketProtocol().getName());
        }
        for (AtmosphereInterceptor i : config.interceptors()) {
            this.framework.interceptor(i);
        }
        try {
            this.framework.init(new NettyServletConfig(config.initParams(), new Context.Builder().basePath(config.path()).build()));
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        this.suspendTimer = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors());
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent messageEvent) throws URISyntaxException, IOException {
        Object msg = messageEvent.getMessage();
        if (msg instanceof HttpRequest) {
            HttpRequest r = (HttpRequest)HttpRequest.class.cast(msg);
            List<String> c = r.getHeaders("Connection");
            String u = r.getHeader("Upgrade");
            boolean webSocket = false;
            if (u != null && u.equalsIgnoreCase("websocket")) {
                webSocket = true;
            }
            for (String connection : c) {
                if (connection == null || !connection.toLowerCase().equalsIgnoreCase("upgrade")) continue;
                webSocket = true;
            }
            logger.debug("Handling request {}", r);
            if (webSocket) {
                this.handleWebSocketHandshake(ctx, messageEvent);
            } else {
                this.handleHttp(ctx, messageEvent);
            }
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, messageEvent);
        }
    }

    private void handleWebSocketHandshake(ChannelHandlerContext ctx, MessageEvent messageEvent) throws IOException, URISyntaxException {
        HttpRequest request = (HttpRequest)messageEvent.getMessage();
        if (request.getMethod() != HttpMethod.GET) {
            this.sendHttpResponse(ctx, request, new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
            return;
        }
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketLocation(request), null, false);
        this.handshaker = wsFactory.newHandshaker(request);
        if (this.handshaker == null) {
            wsFactory.sendUnsupportedWebSocketVersionResponse(ctx.getChannel());
        } else {
            this.handshaker.handshake(ctx.getChannel(), request);
        }
        WebSocketProcessor processor = WebSocketProcessorFactory.getDefault().getWebSocketProcessor(this.framework);
        AtmosphereRequest r = this.createAtmosphereRequest(ctx, request);
        NettyWebSocket webSocket = new NettyWebSocket(ctx.getChannel(), this.framework.getAtmosphereConfig());
        ctx.setAttachment(new Attachment(processor, webSocket));
        processor.open(webSocket, r, AtmosphereResponse.newInstance(this.framework.getAtmosphereConfig(), r, webSocket));
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, MessageEvent messageEvent) throws URISyntaxException, IOException {
        WebSocketFrame frame = (WebSocketFrame)messageEvent.getMessage();
        if (frame instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.getChannel(), (CloseWebSocketFrame)frame);
            return;
        }
        if (frame instanceof PingWebSocketFrame) {
            ctx.getChannel().write(new PongWebSocketFrame(frame.getBinaryData()));
            return;
        }
        if (!(frame instanceof TextWebSocketFrame)) {
            throw new UnsupportedOperationException(String.format("%s frame types not supported", frame.getClass().getName()));
        }
        Attachment a = (Attachment)ctx.getAttachment();
        WebSocketProcessor processor = a.p;
        processor.invokeWebSocketProtocol(a.w, ((TextWebSocketFrame)frame).getText());
    }

    private AtmosphereRequest createAtmosphereRequest(ChannelHandlerContext ctx, HttpRequest request) throws URISyntaxException, UnsupportedEncodingException, MalformedURLException {
        String u;
        String base = this.getBaseUri(request);
        URI requestUri = new URI(base.substring(0, base.length() - 1) + request.getUri());
        String ct = request.getHeaders("Content-Type").size() > 0 ? request.getHeaders("Content-Type").get(0) : "text/plain";
        String method = request.getMethod().getName();
        String queryString = requestUri.getQuery();
        HashMap<String, String[]> qs = new HashMap<String, String[]>();
        if (queryString != null) {
            this.parseQueryString(qs, queryString);
        }
        if (ct.equalsIgnoreCase("application/x-www-form-urlencoded")) {
            this.parseQueryString(qs, new String(request.getContent().array(), "UTF-8"));
        }
        int last = (u = requestUri.toURL().toString()).indexOf("?") == -1 ? u.length() : u.indexOf("?");
        String url = u.substring(0, last);
        int l = requestUri.getAuthority().length() + requestUri.getScheme().length() + 3;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        AtmosphereRequest.Builder requestBuilder = new AtmosphereRequest.Builder();
        AtmosphereRequest r = requestBuilder.requestURI(url.substring(l)).requestURL(url).pathInfo(url.substring(l)).headers(this.getHeaders(request)).method(method).contentType(ct).destroyable(false).attributes(attributes).queryStrings(qs).remotePort(((InetSocketAddress)ctx.getChannel().getRemoteAddress()).getPort()).remoteAddr(((InetSocketAddress)ctx.getChannel().getRemoteAddress()).getAddress().getHostAddress()).remoteHost(((InetSocketAddress)ctx.getChannel().getRemoteAddress()).getHostName()).localPort(((InetSocketAddress)ctx.getChannel().getLocalAddress()).getPort()).localAddr(((InetSocketAddress)ctx.getChannel().getLocalAddress()).getAddress().getHostAddress()).localName(((InetSocketAddress)ctx.getChannel().getLocalAddress()).getHostName()).inputStream(new ChannelBufferInputStream(request.getContent())).build();
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHttp(ChannelHandlerContext ctx, MessageEvent messageEvent) throws URISyntaxException, IOException {
        block26: {
            final ChannelAsyncIOWriter w = new ChannelAsyncIOWriter(ctx.getChannel());
            boolean resumeOnBroadcast = false;
            boolean keptOpen = false;
            HttpRequest request = (HttpRequest)messageEvent.getMessage();
            String method = request.getMethod().getName();
            try {
                request.addHeader(STATIC_MAPPING, "true");
                super.messageReceived(ctx, messageEvent);
                if (request.getHeader(SERVICED) != null) {
                    return;
                }
            }
            catch (Exception e) {
                logger.debug("", e);
            }
            finally {
                request.addHeader(STATIC_MAPPING, "false");
            }
            boolean skipClose = false;
            try {
                AtmosphereRequest r = this.createAtmosphereRequest(ctx, request);
                AtmosphereResponse response = new AtmosphereResponse.Builder().writeHeader(true).asyncIOWriter(w).header("Connection", "Keep-Alive").header("Transfer-Encoding", "chunked").header("Server", "Nettosphere-" + Version.getRawVersion()).request(r).build();
                r.setAttribute(NettyCometSupport.CHANNEL, w);
                this.framework.doCometSupport(r, response);
                final AsynchronousProcessor.AsynchronousProcessorHook hook = (AsynchronousProcessor.AsynchronousProcessorHook)r.getAttribute(FrameworkConfig.ASYNCHRONOUS_HOOK);
                String transport = (String)r.getAttribute(FrameworkConfig.TRANSPORT_IN_USE);
                if (transport == null) {
                    transport = r.getHeader("X-Atmosphere-Transport");
                }
                if (transport != null && transport.equalsIgnoreCase("streaming")) {
                    keptOpen = true;
                } else if (transport != null && transport.equalsIgnoreCase("long-polling")) {
                    resumeOnBroadcast = true;
                }
                final Action action = (Action)r.getAttribute(NettyCometSupport.SUSPEND);
                if (action != null && action.type() == Action.TYPE.SUSPEND && action.timeout() != -1L) {
                    final AtomicReference f = new AtomicReference();
                    f.set(this.suspendTimer.scheduleAtFixedRate(new Runnable(){

                        @Override
                        public void run() {
                            if (!w.isClosed() && System.currentTimeMillis() - w.lastTick() > action.timeout()) {
                                hook.timedOut();
                                ((Future)f.get()).cancel(true);
                            }
                        }
                    }, action.timeout(), action.timeout(), TimeUnit.MILLISECONDS));
                } else if (action != null && action.type() == Action.TYPE.RESUME) {
                    resumeOnBroadcast = false;
                }
                w.resumeOnBroadcast(resumeOnBroadcast);
            }
            catch (AtmosphereMappingException ex) {
                if (!method.equalsIgnoreCase("GET")) break block26;
                logger.trace("Unable to map the request {}, trying static file", messageEvent.getMessage());
                try {
                    skipClose = true;
                    super.messageReceived(ctx, messageEvent);
                }
                catch (Exception e) {
                    logger.error("Unable to process request", e);
                    throw new IOException(e);
                }
            }
            catch (Throwable e) {
                logger.error("Unable to process request", e);
                throw new IOException(e);
            }
            finally {
                if (w != null && !resumeOnBroadcast && !keptOpen) {
                    if (!w.byteWritten()) {
                        w.writeError(null, 200, "OK");
                    }
                    if (!skipClose) {
                        w.close(null);
                    }
                }
            }
        }
    }

    @Override
    protected void sendError(ChannelHandlerContext ctx, HttpResponseStatus status, MessageEvent e) {
        if (e != null) {
            HttpRequest request = (HttpRequest)e.getMessage();
            if (request.getHeader(STATIC_MAPPING) == null || request.getHeader(STATIC_MAPPING).equalsIgnoreCase("false")) {
                super.sendError(ctx, status, e);
            }
        } else {
            super.sendError(ctx, status, e);
        }
    }

    public void destroy() {
        if (this.framework != null) {
            this.framework.destroy();
        }
        this.suspendTimer.shutdown();
    }

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelClosed(ctx, e);
        Attachment o = (Attachment)ctx.getAttachment();
        if (o == null) {
            return;
        }
        WebSocket w = o.w;
        AsynchronousProcessor.AsynchronousProcessorHook hook = (AsynchronousProcessor.AsynchronousProcessorHook)AsynchronousProcessor.AsynchronousProcessorHook.class.cast(w.resource().getRequest().getAttribute(FrameworkConfig.ASYNCHRONOUS_HOOK));
        if (hook != null) {
            hook.closed();
        }
        o.p.close(w, 1000);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        logger.debug("Exception", e.getCause());
        super.exceptionCaught(ctx, e);
    }

    private Map<String, String> getHeaders(HttpRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String name : request.getHeaderNames()) {
            headers.put(name, request.getHeaders(name).get(0));
        }
        return headers;
    }

    private String getBaseUri(HttpRequest request) {
        return "http://" + request.getHeader("Host") + "/";
    }

    private void parseQueryString(Map<String, String[]> qs, String queryString) {
        if (queryString != null) {
            String[] s;
            for (String a : s = queryString.split("&")) {
                String[] q = a.split("=");
                String[] z = new String[]{q.length > 1 ? q[1] : ""};
                qs.put(q[0], z);
            }
        }
    }

    private void sendHttpResponse(ChannelHandlerContext ctx, HttpRequest req, HttpResponse res) {
        if (res.getStatus().getCode() != 200) {
            res.setContent(ChannelBuffers.copiedBuffer((CharSequence)res.getStatus().toString(), CharsetUtil.UTF_8));
            HttpHeaders.setContentLength(res, res.getContent().readableBytes());
        }
        ChannelFuture f = ctx.getChannel().write(res);
        if (!HttpHeaders.isKeepAlive(req) || res.getStatus().getCode() != 200) {
            f.addListener(ChannelFutureListener.CLOSE);
        }
    }

    private String getWebSocketLocation(HttpRequest req) {
        return "ws://" + req.getHeader("Host") + req.getUri();
    }

    private static final class NettyServletConfig
    implements ServletConfig {
        private final Map<String, String> initParams;
        private final ServletContext ctx;

        public NettyServletConfig(Map<String, String> initParams, ServletContext ctx) {
            this.initParams = initParams;
            this.ctx = ctx;
        }

        @Override
        public String getServletName() {
            return "Netty";
        }

        @Override
        public ServletContext getServletContext() {
            return this.ctx;
        }

        @Override
        public String getInitParameter(String name) {
            return this.initParams.get(name);
        }

        @Override
        public Enumeration getInitParameterNames() {
            return Collections.enumeration(this.initParams.keySet());
        }
    }

    private static final class Attachment {
        public final WebSocketProcessor p;
        public final WebSocket w;

        private Attachment(WebSocketProcessor p, WebSocket w) {
            this.p = p;
            this.w = w;
        }
    }
}

