/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.atmosphere.config.ApplicationConfiguration;
import org.atmosphere.config.AtmosphereHandlerConfig;
import org.atmosphere.config.AtmosphereHandlerProperty;
import org.atmosphere.config.FrameworkConfiguration;
import org.atmosphere.cpr.AtmosphereConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AtmosphereConfigReader {
    private static final AtmosphereConfigReader instance = new AtmosphereConfigReader();
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereConfigReader.class);

    private AtmosphereConfigReader() {
    }

    public AtmosphereConfig parse(AtmosphereConfig config, String filename) throws FileNotFoundException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            return this.parse(config, factory.newDocumentBuilder().parse(filename));
        }
        catch (SAXException e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public AtmosphereConfig parse(AtmosphereConfig config, InputStream stream) throws FileNotFoundException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            return this.parse(config, factory.newDocumentBuilder().parse(stream));
        }
        catch (SAXException e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    private AtmosphereConfig parse(AtmosphereConfig config, Document document) {
        Element element = document.getDocumentElement();
        NodeList atmosphereHandlers = element.getElementsByTagName("atmosphere-handler");
        for (int i = 0; i < atmosphereHandlers.getLength(); ++i) {
            AtmosphereHandlerConfig atmoHandler = new AtmosphereHandlerConfig();
            Node root = atmosphereHandlers.item(i);
            for (int j = 0; j < root.getAttributes().getLength(); ++j) {
                String[] values;
                Node attribute = root.getAttributes().item(j);
                if (attribute.getNodeName().equals("support-session")) {
                    atmoHandler.setSupportSession(attribute.getNodeValue());
                    continue;
                }
                if (attribute.getNodeName().equals("context-root")) {
                    atmoHandler.setContextRoot(attribute.getNodeValue());
                    continue;
                }
                if (attribute.getNodeName().equals("class-name")) {
                    atmoHandler.setClassName(attribute.getNodeValue());
                    continue;
                }
                if (attribute.getNodeName().equals("broadcaster")) {
                    atmoHandler.setBroadcaster(attribute.getNodeValue());
                    continue;
                }
                if (attribute.getNodeName().equals("broadcasterCache")) {
                    atmoHandler.setBroadcasterCache(attribute.getNodeValue());
                    continue;
                }
                if (attribute.getNodeName().equals("broadcastFilterClasses")) {
                    for (String value : values = attribute.getNodeValue().split(",")) {
                        atmoHandler.getBroadcastFilterClasses().add(value);
                    }
                    continue;
                }
                if (attribute.getNodeName().equals("comet-support")) {
                    atmoHandler.setCometSupport(attribute.getNodeValue());
                    continue;
                }
                if (!attribute.getNodeName().equals("interceptorClasses")) continue;
                for (String value : values = attribute.getNodeValue().split(",")) {
                    atmoHandler.getAtmosphereInterceptorClasses().add(value);
                }
            }
            NodeList list = root.getChildNodes();
            for (int j = 0; j < list.getLength(); ++j) {
                Node n2;
                int k;
                String value;
                String param;
                Node n = list.item(j);
                if (n.getNodeName().equals("property")) {
                    param = n.getAttributes().getNamedItem("name").getNodeValue();
                    value = n.getAttributes().getNamedItem("value").getNodeValue();
                    atmoHandler.getProperties().add(new AtmosphereHandlerProperty(param, value));
                    continue;
                }
                if (n.getNodeName().equals("applicationConfig")) {
                    param = null;
                    value = null;
                    for (k = 0; k < n.getChildNodes().getLength(); ++k) {
                        n2 = n.getChildNodes().item(k);
                        if (n2.getNodeName().equals("param-name")) {
                            param = n2.getNodeValue();
                            continue;
                        }
                        if (!n2.getNodeName().equals("param-value") || n2 == null) continue;
                        value = n2.getNodeValue();
                    }
                    if (param == null) continue;
                    atmoHandler.getApplicationConfig().add(new ApplicationConfiguration(param, value));
                    continue;
                }
                if (!n.getNodeName().equals("frameworkConfig")) continue;
                param = null;
                value = null;
                for (k = 0; k < n.getChildNodes().getLength(); ++k) {
                    n2 = n.getChildNodes().item(k);
                    if (n2.getNodeName().equals("param-name")) {
                        param = n2.getNodeValue();
                        continue;
                    }
                    if (!n2.getNodeName().equals("param-value") || n2 == null) continue;
                    value = n2.getNodeValue();
                }
                if (param == null) continue;
                atmoHandler.getFrameworkConfig().add(new FrameworkConfiguration(param, value));
            }
            config.getAtmosphereHandlerConfig().add(atmoHandler);
        }
        return config;
    }

    public static AtmosphereConfigReader getInstance() {
        return instance;
    }
}

