/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket.protocol;

import java.util.List;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoProtocol
implements WebSocketProtocol {
    private static final Logger logger = LoggerFactory.getLogger(EchoProtocol.class);

    @Override
    public List<AtmosphereRequest> onMessage(WebSocket webSocket, String data) {
        logger.trace("broadcast String");
        webSocket.resource().getBroadcaster().broadcast(data);
        return null;
    }

    @Override
    public List<AtmosphereRequest> onMessage(WebSocket webSocket, byte[] data, int offset, int length) {
        logger.trace("broadcast byte");
        byte[] b = new byte[length];
        System.arraycopy(data, offset, b, 0, length);
        webSocket.resource().getBroadcaster().broadcast(b);
        return null;
    }

    @Override
    public void configure(AtmosphereConfig config) {
    }

    @Override
    public void onOpen(WebSocket webSocket) {
    }

    @Override
    public void onClose(WebSocket webSocket) {
    }

    @Override
    public void onError(WebSocket webSocket, WebSocketProcessor.WebSocketException t) {
        logger.error(t.getMessage() + " Status {} Message {}", t.response().getStatus(), (Object)t.response().getStatusMessage());
    }
}

