/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import javax.net.ssl.SSLEngine;
import org.atmosphere.nettosphere.BridgeRuntime;
import org.atmosphere.nettosphere.Config;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;

class AtmosphereChannelPipelineFactory
implements ChannelPipelineFactory {
    private final transient BridgeRuntime bridgeRuntime;
    private final transient Config config;

    public AtmosphereChannelPipelineFactory(BridgeRuntime bridgeRuntime) {
        this.bridgeRuntime = bridgeRuntime;
        this.config = bridgeRuntime.config();
    }

    @Override
    public ChannelPipeline getPipeline() {
        ChannelPipeline pipeline = Channels.pipeline();
        if (this.config.sslContext() != null) {
            SSLEngine e = this.config.sslContext().createSSLEngine();
            this.config.sslContextListener().onPostCreate(e);
            pipeline.addLast("ssl", new SslHandler(e));
        }
        pipeline.addLast("decoder", new HttpRequestDecoder());
        pipeline.addLast("aggregator", new HttpChunkAggregator(65536));
        pipeline.addLast("encoder", new HttpResponseEncoder());
        pipeline.addLast("chunkedWriter", new ChunkedWriteHandler());
        pipeline.addLast("nettyAtmosphereHandler", this.bridgeRuntime);
        return pipeline;
    }
}

