/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.atmosphere.util.Version;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelFutureProgressListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.DefaultFileRegion;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpStaticFileServerHandler
extends SimpleChannelUpstreamHandler {
    public static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String HTTP_DATE_GMT_TIMEZONE = "GMT";
    public static final int HTTP_CACHE_SECONDS = 60;
    private static final Logger logger = LoggerFactory.getLogger(HttpStaticFileServerHandler.class);
    public static final String STATIC_MAPPING = SimpleChannelUpstreamHandler.class.getName() + ".staticMapping";
    public static final String SERVICED = SimpleChannelUpstreamHandler.class.getName() + ".serviced";
    private final List<String> paths;

    public HttpStaticFileServerHandler(List<String> paths) {
        this.paths = paths;
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ChannelFuture writeFuture;
        long fileLastModifiedSeconds;
        SimpleDateFormat dateFormatter;
        Date ifModifiedSinceDate;
        long ifModifiedSinceDateSeconds;
        HttpRequest request = (HttpRequest)e.getMessage();
        RandomAccessFile raf = null;
        boolean found = true;
        File file = null;
        for (String p : this.paths) {
            String path = p + this.sanitizeUri(request.getUri());
            if (path.endsWith("/") || path.endsWith(File.separator)) {
                path = path + "index.html";
            }
            if (path == null) {
                found = false;
                continue;
            }
            file = new File(path);
            if (file.isHidden() || !file.exists()) {
                found = false;
                continue;
            }
            if (!file.isFile()) {
                found = false;
                continue;
            }
            try {
                raf = new RandomAccessFile(file, "r");
                found = true;
                break;
            }
            catch (FileNotFoundException fnfe) {
                found = false;
            }
        }
        if (!found) {
            this.sendError(ctx, HttpResponseStatus.NOT_FOUND, e);
            return;
        }
        String ifModifiedSince = request.getHeader("If-Modified-Since");
        if (file != null && ifModifiedSince != null && ifModifiedSince.length() != 0 && (ifModifiedSinceDateSeconds = (ifModifiedSinceDate = (dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US)).parse(ifModifiedSince)).getTime() / 1000L) == (fileLastModifiedSeconds = file.lastModified() / 1000L)) {
            HttpStaticFileServerHandler.sendNotModified(ctx);
            return;
        }
        long fileLength = raf.length();
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        HttpHeaders.setContentLength(response, fileLength);
        Channel ch = e.getChannel();
        ch.write(response);
        if (ch.getPipeline().get(SslHandler.class) != null) {
            writeFuture = ch.write(new ChunkedFile(raf, 0L, fileLength, 8192));
        } else {
            final DefaultFileRegion region = new DefaultFileRegion(raf.getChannel(), 0L, fileLength);
            writeFuture = ch.write(region);
            writeFuture.addListener(new ChannelFutureProgressListener(){

                @Override
                public void operationComplete(ChannelFuture future) {
                    region.releaseExternalResources();
                }

                @Override
                public void operationProgressed(ChannelFuture future, long amount, long current, long total) {
                }
            });
        }
        if (!HttpHeaders.isKeepAlive(request)) {
            writeFuture.addListener(ChannelFutureListener.CLOSE);
        }
        request.addHeader(SERVICED, "true");
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Channel ch = e.getChannel();
        if (ch.getAttachment() != null && Error.class.isAssignableFrom(ch.getAttachment().getClass())) {
            return;
        }
        Throwable cause = e.getCause();
        if (cause instanceof TooLongFrameException) {
            this.sendError(ctx, HttpResponseStatus.BAD_REQUEST, null);
            return;
        }
        ch.setAttachment(new Error());
        if (ch.isOpen()) {
            this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, null);
        }
    }

    protected String sanitizeUri(String uri) {
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            try {
                uri = URLDecoder.decode(uri, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e1) {
                throw new Error();
            }
        }
        uri = uri.replace('/', File.separatorChar);
        if (uri.contains(File.separator + ".") || uri.contains("." + File.separator) || uri.startsWith(".") || uri.endsWith(".")) {
            return null;
        }
        return uri;
    }

    private static void sendNotModified(ChannelHandlerContext ctx) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_MODIFIED);
        HttpStaticFileServerHandler.setDateHeader(response);
        ctx.getChannel().write(response).addListener(ChannelFutureListener.CLOSE);
    }

    private static void setDateHeader(HttpResponse response) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
        GregorianCalendar time = new GregorianCalendar();
        response.setHeader("Date", dateFormatter.format(time.getTime()));
    }

    protected void sendError(ChannelHandlerContext ctx, HttpResponseStatus status, MessageEvent e) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        response.setHeader("Content-Type", "text/plain; charset=UTF-8");
        response.setHeader("Content-Length", "0");
        response.setHeader("Server", "Atmosphere-" + Version.getRawVersion());
        ctx.getChannel().write(response).addListener(ChannelFutureListener.CLOSE);
    }
}

