/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRegistration;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final Logger logger = LoggerFactory.getLogger(IOUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder readEntirely(AtmosphereResource r) {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            block18: {
                try {
                    ServletInputStream inputStream = r.getRequest().getInputStream();
                    if (inputStream != null) {
                        bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    }
                }
                catch (IllegalStateException ex) {
                    logger.trace("", ex);
                    BufferedReader reader = r.getRequest().getReader();
                    if (reader == null) break block18;
                    bufferedReader = new BufferedReader(reader);
                }
            }
            if (bufferedReader != null) {
                char[] charBuffer = new char[8192];
                int bytesRead = -1;
                while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                    stringBuilder.append(charBuffer, 0, bytesRead);
                }
            } else {
                stringBuilder.append("");
            }
        }
        catch (IOException ex) {
            logger.warn("", ex);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException ex) {
                    logger.warn("", ex);
                }
            }
        }
        return stringBuilder;
    }

    public static String guestServletPath(AtmosphereFramework framework, Class<? extends Servlet> clazz, Class<?> callee) {
        String servletPath = "";
        try {
            Map<String, ? extends ServletRegistration> m = framework.getServletContext().getServletRegistrations();
            for (Map.Entry<String, ? extends ServletRegistration> e : m.entrySet()) {
                if (!clazz.isAssignableFrom(IOUtils.loadClass(callee, e.getValue().getClassName()))) continue;
                servletPath = "/" + e.getValue().getMappings().iterator().next().replace("/", "").replace("*", "");
                break;
            }
        }
        catch (Exception ex) {
            logger.trace("", ex);
        }
        return servletPath;
    }

    public static Class<?> loadClass(Class thisClass, String className) throws Exception {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (Throwable t) {
            return thisClass.getClassLoader().loadClass(className);
        }
    }
}

