/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import org.apache.catalina.comet.CometEvent;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.jboss.servlet.http.HttpEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingIOCometSupport
extends AsynchronousProcessor {
    private static final Logger logger = LoggerFactory.getLogger(BlockingIOCometSupport.class);
    protected static final String LATCH = BlockingIOCometSupport.class.getName() + ".latch";

    public BlockingIOCometSupport(AtmosphereConfig config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        Action action = null;
        try {
            action = this.suspended(req, res);
            if (action.type() == Action.TYPE.SUSPEND) {
                this.suspend(action, req, res);
            } else if (action.type() == Action.TYPE.RESUME) {
                CountDownLatch latch = (CountDownLatch)req.getAttribute(LATCH);
                if (latch == null || req.getAttribute(AtmosphereResourceImpl.PRE_SUSPEND) == null) {
                    logger.debug("response wasn't suspended: {}", (Object)res);
                    Action action2 = action;
                    return action2;
                }
                latch.countDown();
                Action nextAction = this.resumed(req, res);
                if (nextAction.type() == Action.TYPE.SUSPEND) {
                    this.suspend(action, req, res);
                }
            }
        }
        finally {
            Object event = req.getAttribute("CometEvent");
            if (event != null) {
                try {
                    Class.forName(org.apache.catalina.CometEvent.class.getName());
                    if (org.apache.catalina.CometEvent.class.isAssignableFrom(event.getClass())) {
                        ((org.apache.catalina.CometEvent)org.apache.catalina.CometEvent.class.cast(event)).close();
                    }
                }
                catch (Throwable e) {
                    logger.trace("", e);
                }
                try {
                    Class.forName(CometEvent.class.getName());
                    if (CometEvent.class.isAssignableFrom(event.getClass())) {
                        ((CometEvent)CometEvent.class.cast(event)).close();
                    }
                }
                catch (Throwable e) {
                    logger.trace("", e);
                }
            }
            try {
                event = req.getAttribute("HttpEvent");
                if (event != null) {
                    Class.forName(HttpEvent.class.getName());
                    ((HttpEvent)HttpEvent.class.cast(event)).close();
                }
            }
            catch (Throwable e) {
                logger.trace("", e);
            }
        }
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspend(Action action, AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        final CountDownLatch latch = new CountDownLatch(1);
        req.setAttribute(LATCH, latch);
        boolean ok = true;
        try {
            AtmosphereResource resource = req.resource();
            resource.addEventListener(new AtmosphereResourceEventListenerAdapter.OnResume(){

                @Override
                public void onResume(AtmosphereResourceEvent event) {
                    latch.countDown();
                }
            });
            if (action.timeout() != -1L) {
                ok = latch.await(action.timeout(), TimeUnit.MILLISECONDS);
            } else {
                latch.await();
            }
        }
        catch (InterruptedException ex) {
            logger.trace("", (Throwable)ex);
        }
        finally {
            if (!ok) {
                this.timedout(req, res);
            } else if (req.resource() != null) {
                ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(req.resource())).cancel();
            }
        }
    }

    @Override
    public Action cancelled(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        Action a = super.cancelled(req, res);
        if (req.getAttribute(LATCH) != null) {
            CountDownLatch latch = (CountDownLatch)req.getAttribute(LATCH);
            latch.countDown();
        }
        return a;
    }

    @Override
    public void action(AtmosphereResourceImpl r) {
        try {
            super.action(r);
            if (r.action().type() == Action.TYPE.RESUME) {
                AtmosphereRequest req = r.getRequest(false);
                CountDownLatch latch = null;
                if (req.getAttribute(LATCH) != null) {
                    latch = (CountDownLatch)req.getAttribute(LATCH);
                }
                if (latch != null) {
                    latch.countDown();
                } else if (req.getAttribute(AtmosphereResourceImpl.PRE_SUSPEND) == null) {
                    logger.trace("Unable to resume the suspended connection");
                }
            }
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
    }
}

