/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.atmosphere.nettosphere.util.MimeType;
import org.atmosphere.util.Version;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelFutureProgressListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.DefaultFileRegion;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.FileRegion;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpStaticFileServerHandler
extends SimpleChannelUpstreamHandler {
    public static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String HTTP_DATE_GMT_TIMEZONE = "GMT";
    public static final int HTTP_CACHE_SECONDS = 60;
    private static final Logger logger = LoggerFactory.getLogger(HttpStaticFileServerHandler.class);
    public static final String STATIC_MAPPING = SimpleChannelUpstreamHandler.class.getName() + ".staticMapping";
    public static final String SERVICED = SimpleChannelUpstreamHandler.class.getName() + ".serviced";
    private final List<String> paths;
    private String defaultContentType = "text/html";

    public HttpStaticFileServerHandler(List<String> paths) {
        this.paths = paths;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ChannelFuture writeFuture;
        long fileLastModifiedSeconds;
        SimpleDateFormat dateFormatter;
        Date ifModifiedSinceDate;
        long ifModifiedSinceDateSeconds;
        HttpRequest request = (HttpRequest)e.getMessage();
        RandomAccessFile raf = null;
        boolean found = true;
        File file = null;
        for (String p : this.paths) {
            String path = p + this.sanitizeUri(request.getUri());
            if (path.endsWith("/") || path.endsWith(File.separator)) {
                path = path + "index.html";
            }
            if (path == null) {
                found = false;
                continue;
            }
            file = new File(path);
            if (file.isHidden() || !file.exists()) {
                found = false;
                continue;
            }
            if (!file.isFile()) {
                found = false;
                continue;
            }
            try {
                raf = new RandomAccessFile(file, "r");
                found = true;
                break;
            }
            catch (FileNotFoundException fnfe) {
                found = false;
            }
        }
        if (!found) {
            this.sendError(ctx, HttpResponseStatus.NOT_FOUND, e);
            return;
        }
        String ifModifiedSince = request.getHeader("If-Modified-Since");
        if (file != null && ifModifiedSince != null && ifModifiedSince.length() != 0 && (ifModifiedSinceDateSeconds = (ifModifiedSinceDate = (dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US)).parse(ifModifiedSince)).getTime() / 1000L) == (fileLastModifiedSeconds = file.lastModified() / 1000L)) {
            HttpStaticFileServerHandler.sendNotModified(ctx);
            return;
        }
        long fileLength = raf.length();
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        this.contentType(request, (HttpResponse)response, file);
        HttpHeaders.setContentLength((HttpMessage)response, (long)fileLength);
        HttpStaticFileServerHandler.setDateAndCacheHeaders((HttpResponse)response, file);
        Channel ch = e.getChannel();
        ch.write((Object)response);
        if (ch.getPipeline().get(SslHandler.class) != null) {
            writeFuture = ch.write((Object)new ChunkedFile(raf, 0L, fileLength, 8192));
        } else {
            DefaultFileRegion region = new DefaultFileRegion(raf.getChannel(), 0L, fileLength);
            writeFuture = ch.write((Object)region);
            writeFuture.addListener((ChannelFutureListener)new ChannelFutureProgressListener((FileRegion)region){
                final /* synthetic */ FileRegion val$region;
                {
                    this.val$region = fileRegion;
                }

                public void operationComplete(ChannelFuture future) {
                    this.val$region.releaseExternalResources();
                }

                public void operationProgressed(ChannelFuture future, long amount, long current, long total) {
                }
            });
        }
        if (!HttpHeaders.isKeepAlive((HttpMessage)request)) {
            writeFuture.addListener(ChannelFutureListener.CLOSE);
        }
        request.addHeader(SERVICED, (Object)"true");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Channel ch = e.getChannel();
        if (ch.getAttachment() != null && Error.class.isAssignableFrom(ch.getAttachment().getClass())) {
            return;
        }
        Throwable cause = e.getCause();
        if (cause instanceof TooLongFrameException) {
            this.sendError(ctx, HttpResponseStatus.BAD_REQUEST, null);
            return;
        }
        ch.setAttachment((Object)new Error());
        if (ch.isOpen()) {
            this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, null);
        }
    }

    protected String sanitizeUri(String uri) {
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            try {
                uri = URLDecoder.decode(uri, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e1) {
                throw new Error();
            }
        }
        uri = uri.replace('/', File.separatorChar);
        if (uri.contains(File.separator + ".") || uri.contains("." + File.separator) || uri.startsWith(".") || uri.endsWith(".")) {
            return null;
        }
        int pos = uri.indexOf("?");
        if (pos != -1) {
            uri = uri.substring(0, pos);
        }
        return uri;
    }

    private static void sendNotModified(ChannelHandlerContext ctx) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_MODIFIED);
        HttpStaticFileServerHandler.setDateHeader((HttpResponse)response);
        ctx.getChannel().write((Object)response).addListener(ChannelFutureListener.CLOSE);
    }

    private static void setDateHeader(HttpResponse response) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
        GregorianCalendar time = new GregorianCalendar();
        response.setHeader("Date", (Object)dateFormatter.format(time.getTime()));
    }

    protected void sendError(ChannelHandlerContext ctx, HttpResponseStatus status, MessageEvent e) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        response.setHeader("Content-Type", (Object)"text/plain; charset=UTF-8");
        response.setHeader("Content-Length", (Object)"0");
        response.setHeader("Server", (Object)("Atmosphere-" + Version.getRawVersion()));
        ctx.getChannel().write((Object)response).addListener(ChannelFutureListener.CLOSE);
    }

    protected void contentType(HttpRequest request, HttpResponse response, File resource) {
        String substr;
        String uri = request.getUri();
        int dot = uri.lastIndexOf(".");
        if (dot < 0) {
            substr = resource.toString();
            dot = substr.lastIndexOf(".");
        } else {
            substr = uri;
        }
        if (dot > 0) {
            String ext = substr.substring(dot + 1);
            String contentType = MimeType.get(ext, this.defaultContentType);
            response.addHeader("Content-Type", (Object)contentType);
        } else {
            response.addHeader("Content-Type", (Object)this.defaultContentType);
        }
    }

    private static void setDateAndCacheHeaders(HttpResponse response, File fileToCache) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
        GregorianCalendar time = new GregorianCalendar();
        response.setHeader("Date", (Object)dateFormatter.format(time.getTime()));
        ((Calendar)time).add(13, 60);
        response.setHeader("Expires", (Object)dateFormatter.format(time.getTime()));
        response.setHeader("Cache-Control", (Object)"private, max-age=60");
        response.setHeader("Last-Modified", (Object)dateFormatter.format(new Date(fileToCache.lastModified())));
    }
}

