/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container.version;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Semaphore;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import javax.websocket.Session;
import org.atmosphere.cache.BroadcastMessage;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSR356WebSocket
extends WebSocket {
    private final Logger logger = LoggerFactory.getLogger(JSR356WebSocket.class);
    private final Session session;
    private final Semaphore semaphore = new Semaphore(1, true);

    public JSR356WebSocket(Session session, AtmosphereConfig config) {
        super(config);
        this.session = session;
        String s = config.getInitParameter("org.atmosphere.websocket.maxIdleTime");
        if (s != null) {
            session.getAsyncRemote().setSendTimeout((long)Integer.valueOf(s).intValue());
        }
    }

    @Override
    public boolean isOpen() {
        return this.session.isOpen();
    }

    @Override
    public WebSocket write(String s) throws IOException {
        try {
            try {
                this.semaphore.acquireUninterruptibly();
                this.session.getAsyncRemote().sendText(s, (SendHandler)new WriteResult(this.resource(), s, this.semaphore));
            }
            catch (IllegalStateException e) {
                this.semaphore.release();
                throw e;
            }
        }
        catch (NullPointerException e) {
            this.patchGlassFish(e);
        }
        return this;
    }

    @Override
    public WebSocket write(byte[] data, int offset, int length) throws IOException {
        try {
            this.semaphore.acquireUninterruptibly();
            ByteBuffer b = ByteBuffer.wrap(data, offset, length);
            this.session.getAsyncRemote().sendBinary(ByteBuffer.wrap(data, offset, length), (SendHandler)new WriteResult(this.resource(), b.array(), this.semaphore));
        }
        catch (NullPointerException e) {
            this.patchGlassFish(e);
            this.semaphore.release();
        }
        catch (IllegalStateException e) {
            this.semaphore.release();
            throw e;
        }
        return this;
    }

    void patchGlassFish(NullPointerException e) {
        this.logger.trace("", e);
        WebSocketProcessorFactory.getDefault().getWebSocketProcessor(this.config().framework()).close(this, 1002);
    }

    @Override
    public void close() {
        this.logger.trace("WebSocket.close() for AtmosphereResource {}", (Object)(this.resource() != null ? this.resource().uuid() : "null"));
        try {
            this.session.close();
        }
        catch (Exception e) {
            this.logger.trace("", e);
        }
    }

    private final class WriteResult
    implements SendHandler {
        private final AtmosphereResource r;
        private final Object message;
        private final Semaphore semaphore;

        private WriteResult(AtmosphereResource r, Object message, Semaphore semaphore) {
            this.r = r;
            this.message = message;
            this.semaphore = semaphore;
        }

        public void onResult(SendResult result) {
            this.semaphore.release();
            if (!result.isOK() || result.getException() != null) {
                JSR356WebSocket.this.logger.trace("WebSocket {} failed to write {}", this.r, this.message);
                Broadcaster b = this.r.getBroadcaster();
                b.getBroadcasterConfig().getBroadcasterCache().addToCache(b.getID(), this.r, new BroadcastMessage(this.message));
            }
        }
    }
}

