/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.annotation.HandlesTypes;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.container.JSR356AsyncSupport;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.DefaultAsyncSupportResolver;
import org.atmosphere.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HandlesTypes(value={})
public class AtmosphereInitializer
implements ServletContainerInitializer {
    private final Logger logger = LoggerFactory.getLogger(AtmosphereInitializer.class);
    private AtmosphereFramework framework;

    @Override
    public void onStartup(Set<Class<?>> classes, final ServletContext c) throws ServletException {
        this.logger.trace("Initializing AtmosphereFramework");
        this.framework = (AtmosphereFramework)c.getAttribute(AtmosphereFramework.class.getName());
        if (this.framework == null) {
            this.framework = new AtmosphereFramework(false, true);
            DefaultAsyncSupportResolver resolver = new DefaultAsyncSupportResolver(this.framework.getAtmosphereConfig());
            List<Class<? extends AsyncSupport>> l = resolver.detectWebSocketPresent(false, true);
            if (l.size() == 0 && resolver.testClassExists("javax.websocket.Endpoint")) {
                this.framework.setAsyncSupport(new JSR356AsyncSupport(new AtmosphereConfig(this.framework){

                    @Override
                    public ServletContext getServletContext() {
                        return c;
                    }

                    @Override
                    public String getInitParameter(String name) {
                        return c.getInitParameter(name);
                    }

                    @Override
                    public Enumeration<String> getInitParameterNames() {
                        return c.getInitParameterNames();
                    }
                }));
            }
            try {
                c.addListener(new ServletRequestListener(){

                    @Override
                    public void requestDestroyed(ServletRequestEvent sre) {
                    }

                    @Override
                    public void requestInitialized(ServletRequestEvent sre) {
                        HttpServletRequest r = (HttpServletRequest)HttpServletRequest.class.cast(sre.getServletRequest());
                        if (AtmosphereInitializer.this.framework.getAtmosphereConfig().isSupportSession() && Utils.webSocketEnabled(r)) {
                            r.getSession(true);
                        }
                    }
                });
            }
            catch (Throwable t) {
                this.logger.trace("Unable to install WebSocket Session Creator", t);
            }
            c.setAttribute(AtmosphereFramework.class.getName(), this.framework);
        }
    }
}

