/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.cpr.AtmosphereResource;

public final class Utils {
    public static final boolean webSocketEnabled(HttpServletRequest request) {
        boolean allowWebSocketWithoutHeaders;
        boolean bl = allowWebSocketWithoutHeaders = request.getHeader("X-Atmosphere-WebSocket-Proxy") != null;
        if (allowWebSocketWithoutHeaders) {
            return true;
        }
        boolean webSocketEnabled = false;
        Enumeration<String> connection = request.getHeaders("Connection");
        if (connection == null || !connection.hasMoreElements()) {
            connection = request.getHeaders("connection");
        }
        if (connection != null && connection.hasMoreElements()) {
            String[] e;
            for (String upgrade : e = connection.nextElement().toString().split(",")) {
                if (!upgrade.trim().equalsIgnoreCase("Upgrade")) continue;
                webSocketEnabled = true;
                break;
            }
        }
        return webSocketEnabled;
    }

    public static final boolean resumableTransport(AtmosphereResource.TRANSPORT t) {
        switch (t) {
            case JSONP: 
            case LONG_POLLING: {
                return true;
            }
        }
        return false;
    }

    public static final boolean pollableTransport(AtmosphereResource.TRANSPORT t) {
        switch (t) {
            case POLLING: 
            case UNDEFINED: 
            case AJAX: {
                return true;
            }
        }
        return false;
    }
}

