/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.websocket.WebSocket;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyWebSocket
extends WebSocket {
    private static final Logger logger = LoggerFactory.getLogger(NettyWebSocket.class);
    private final Channel channel;
    private final AtomicBoolean firstWrite = new AtomicBoolean(false);
    private int bufferBinarySize = Integer.MAX_VALUE;
    private int bufferStringSize = Integer.MAX_VALUE;
    private boolean binaryWrite = false;

    public NettyWebSocket(Channel channel, AtmosphereConfig config) {
        super(config);
        this.channel = channel;
        String s = config.getInitParameter("org.atmosphere.websocket.maxBinaryMessageSize");
        if (s != null) {
            this.bufferBinarySize = Integer.valueOf(s);
        }
        if ((s = config.getInitParameter("org.atmosphere.websocket.maxTextMessageSize")) != null) {
            this.bufferStringSize = Integer.valueOf(s);
        }
    }

    @Override
    public WebSocket write(String data) throws IOException {
        this.firstWrite.set(true);
        if (!this.channel.isOpen()) {
            throw new IOException("Connection remotely closed");
        }
        logger.trace("WebSocket.write()");
        if (this.binaryWrite) {
            this.channel.write((Object)new BinaryWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])data.getBytes("UTF-8"))));
        } else {
            this.channel.write((Object)new TextWebSocketFrame(data));
        }
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    public WebSocket write(byte[] data) throws IOException {
        this._write(data, 0, data.length);
        return this;
    }

    @Override
    public WebSocket write(byte[] data, int offset, int length) throws IOException {
        this._write(data, offset, length);
        return this;
    }

    void _write(byte[] data, int offset, int length) throws IOException {
        this.firstWrite.set(true);
        if (!this.channel.isOpen()) {
            throw new IOException("Connection remotely closed");
        }
        if (this.binaryWrite) {
            this.channel.write((Object)new BinaryWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])data, (int)offset, (int)length)));
        } else {
            this.channel.write((Object)new TextWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])data, (int)offset, (int)length)));
        }
        this.lastWrite = System.currentTimeMillis();
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() {
        AtmosphereResourceImpl impl = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(this.resource());
        if (impl != null && impl.isInScope()) {
            this.channel.write((Object)new CloseWebSocketFrame()).addListener(ChannelFutureListener.CLOSE);
        }
    }
}

