/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.config.managed;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.atmosphere.config.managed.Decoder;
import org.atmosphere.config.managed.Encoder;
import org.atmosphere.config.managed.Invoker;
import org.atmosphere.config.managed.ManagedServiceInterceptor;
import org.atmosphere.config.service.Delete;
import org.atmosphere.config.service.Disconnect;
import org.atmosphere.config.service.Get;
import org.atmosphere.config.service.Message;
import org.atmosphere.config.service.Post;
import org.atmosphere.config.service.Put;
import org.atmosphere.config.service.Ready;
import org.atmosphere.config.service.Resume;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.handler.AnnotatedProxy;
import org.atmosphere.util.IOUtils;
import org.atmosphere.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedAtmosphereHandler
extends AbstractReflectorAtmosphereHandler
implements AnnotatedProxy {
    private Logger logger = LoggerFactory.getLogger(ManagedAtmosphereHandler.class);
    private static final List<Decoder<?, ?>> EMPTY = Collections.emptyList();
    private Object proxiedInstance;
    private List<MethodInfo> onRuntimeMethod;
    private Method onDisconnectMethod;
    private Method onTimeoutMethod;
    private Method onGetMethod;
    private Method onPostMethod;
    private Method onPutMethod;
    private Method onDeleteMethod;
    private Method onReadyMethod;
    private Method onResumeMethod;
    private AtmosphereConfig config;
    final Map<Method, List<Encoder<?, ?>>> encoders = new HashMap();
    final Map<Method, List<Decoder<?, ?>>> decoders = new HashMap();

    public ManagedAtmosphereHandler configure(AtmosphereConfig config, Object c) {
        this.proxiedInstance = c;
        this.onRuntimeMethod = this.populateMessage(c, Message.class);
        this.onDisconnectMethod = this.populate(c, Disconnect.class);
        this.onTimeoutMethod = this.populate(c, Resume.class);
        this.onGetMethod = this.populate(c, Get.class);
        this.onPostMethod = this.populate(c, Post.class);
        this.onPutMethod = this.populate(c, Put.class);
        this.onDeleteMethod = this.populate(c, Delete.class);
        this.onReadyMethod = this.populate(c, Ready.class);
        this.onResumeMethod = this.populate(c, Resume.class);
        this.config = config;
        this.scanForReaderOrInputStream();
        this.populateEncoders();
        this.populateDecoders();
        return this;
    }

    @Override
    public void onRequest(final AtmosphereResource resource) throws IOException {
        AtmosphereRequest request = resource.getRequest();
        String method = request.getMethod();
        boolean polling = Utils.pollableTransport(resource.transport());
        if (this.onReadyMethod != null && !polling) {
            resource.addEventListener(new AtmosphereResourceEventListenerAdapter.OnSuspend(){

                @Override
                public void onSuspend(AtmosphereResourceEvent event) {
                    ManagedAtmosphereHandler.this.processReady(event.getResource());
                    resource.removeEventListener(this);
                }
            });
        }
        if (this.onResumeMethod != null && !polling) {
            resource.addEventListener(new AtmosphereResourceEventListenerAdapter.OnResume(){

                @Override
                public void onResume(AtmosphereResourceEvent event) {
                    ManagedAtmosphereHandler.this.invoke(ManagedAtmosphereHandler.this.onResumeMethod, event.getResource());
                    resource.removeEventListener(this);
                }
            });
        }
        resource.addEventListener(new AtmosphereResourceEventListenerAdapter.OnClose(){

            @Override
            public void onClose(AtmosphereResourceEvent event) {
                ManagedAtmosphereHandler.this.invoke(ManagedAtmosphereHandler.this.onDisconnectMethod, event);
            }
        });
        if (method.equalsIgnoreCase("get")) {
            this.invoke(this.onGetMethod, resource);
        } else if (method.equalsIgnoreCase("post")) {
            Object o;
            String body = null;
            if (this.onPostMethod != null) {
                body = IOUtils.readEntirely(resource).toString();
                resource.getRequest().body(body);
                this.invoke(this.onPostMethod, resource);
            }
            if ((o = this.message(resource, (Object)body)) != null) {
                resource.getBroadcaster().broadcast(new Managed(o));
            }
        } else if (method.equalsIgnoreCase("delete")) {
            this.invoke(this.onDeleteMethod, resource);
        } else if (method.equalsIgnoreCase("put")) {
            this.invoke(this.onPutMethod, resource);
        }
    }

    @Override
    public void onStateChange(AtmosphereResourceEvent event) throws IOException {
        Object o;
        AtmosphereResourceImpl r = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(event.getResource());
        Boolean resumeOnBroadcast = r.resumeOnBroadcast();
        if (!resumeOnBroadcast.booleanValue() && (o = r.getRequest(false).getAttribute("org.atmosphere.resumeOnBroadcast")) != null && Boolean.class.isAssignableFrom(o.getClass())) {
            resumeOnBroadcast = (Boolean)Boolean.class.cast(o);
        }
        if (resumeOnBroadcast.booleanValue()) {
            r.resumeOnBroadcast(false);
            r.getRequest(false).setAttribute("org.atmosphere.resumeOnBroadcast", false);
        }
        if (event.isCancelled() || event.isClosedByClient()) {
            this.invoke(this.onDisconnectMethod, event);
        } else if (event.isResumedOnTimeout() || event.isResuming()) {
            this.invoke(this.onTimeoutMethod, event);
        } else {
            Object msg = event.getMessage();
            if (msg != null) {
                if (Managed.class.isAssignableFrom(msg.getClass())) {
                    Object newMsg = ((Managed)Managed.class.cast((Object)msg)).o;
                    event.setMessage(newMsg);
                    for (MethodInfo m : this.onRuntimeMethod) {
                        Object o2 = Invoker.encode(this.encoders.get(m.method), newMsg);
                        if (o2 == null) continue;
                        event.setMessage(o2);
                        break;
                    }
                } else if (this.onRuntimeMethod.size() > 1) {
                    this.logger.trace("BroadcasterFactory has been used, this may produce recursion if encoder/decoder match the broadcasted message");
                    Object o3 = this.message(r, msg);
                    if (o3 != null) {
                        event.setMessage(o3);
                    }
                }
            }
            super.onStateChange(event);
        }
        if (resumeOnBroadcast.booleanValue() && r.isSuspended()) {
            r.resume();
        }
    }

    private Method populate(Object c, Class<? extends Annotation> annotation) {
        for (Method m : c.getClass().getMethods()) {
            if (!m.isAnnotationPresent(annotation)) continue;
            return m;
        }
        return null;
    }

    private List<MethodInfo> populateMessage(Object c, Class<? extends Annotation> annotation) {
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        for (Method m : c.getClass().getMethods()) {
            if (!m.isAnnotationPresent(annotation)) continue;
            methods.add(new MethodInfo(m));
        }
        return methods;
    }

    private void scanForReaderOrInputStream() {
        for (MethodInfo m : this.onRuntimeMethod) {
            Class<?>[] classes;
            for (Class<?> c : classes = m.method.getParameterTypes()) {
                if (InputStream.class.isAssignableFrom(c)) {
                    m.useStream = true;
                    continue;
                }
                if (!Reader.class.isAssignableFrom(c)) continue;
                m.useReader = true;
            }
        }
    }

    private void populateEncoders() {
        for (MethodInfo m : this.onRuntimeMethod) {
            CopyOnWriteArrayList<Encoder> l = new CopyOnWriteArrayList<Encoder>();
            for (Class<? extends Encoder> s : m.method.getAnnotation(Message.class).encoders()) {
                try {
                    l.add(this.config.framework().newClassInstance(Encoder.class, s));
                }
                catch (Exception e) {
                    this.logger.error("Unable to load encoder {}", s);
                }
            }
            this.encoders.put(m.method, l);
        }
        if (this.onReadyMethod != null) {
            CopyOnWriteArrayList<Encoder> l = new CopyOnWriteArrayList<Encoder>();
            for (Class<? extends Encoder> s : this.onReadyMethod.getAnnotation(Ready.class).encoders()) {
                try {
                    l.add(this.config.framework().newClassInstance(Encoder.class, s));
                }
                catch (Exception e) {
                    this.logger.error("Unable to load encoder {}", s);
                }
            }
            this.encoders.put(this.onReadyMethod, l);
        }
    }

    private void populateDecoders() {
        for (MethodInfo m : this.onRuntimeMethod) {
            CopyOnWriteArrayList<Decoder> l = new CopyOnWriteArrayList<Decoder>();
            for (Class<? extends Decoder> s : m.method.getAnnotation(Message.class).decoders()) {
                try {
                    l.add(this.config.framework().newClassInstance(Decoder.class, s));
                }
                catch (Exception e) {
                    this.logger.error("Unable to load encoder {}", s);
                }
            }
            this.decoders.put(m.method, l);
        }
    }

    private Object invoke(Method m, Object o) {
        if (m != null) {
            try {
                Object[] objectArray;
                if (o == null) {
                    objectArray = new Object[]{};
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = o;
                }
                return m.invoke(this.proxiedInstance, objectArray);
            }
            catch (IllegalAccessException e) {
                this.logger.debug("", e);
            }
            catch (InvocationTargetException e) {
                this.logger.debug("", e);
            }
        }
        this.logger.trace("No Method Mapped for {}", o);
        return null;
    }

    private Object message(AtmosphereResource resource, Object o) {
        try {
            for (MethodInfo m : this.onRuntimeMethod) {
                if (m.useReader) {
                    o = resource.getRequest().getReader();
                } else if (m.useStream) {
                    o = resource.getRequest().getInputStream();
                } else if (o == null && ((String)String.class.cast(o = IOUtils.readEntirely(resource).toString())).isEmpty()) {
                    this.logger.warn("{} received an empty body", (Object)ManagedServiceInterceptor.class.getSimpleName());
                    return null;
                }
                Object decoded = Invoker.decode(this.decoders.get(m.method), o);
                if (decoded == null) {
                    decoded = o;
                }
                Object objectToEncode = null;
                if (m.method.getParameterTypes().length > 2) {
                    this.logger.warn("Injection of more than 2 parameters not supported {}", m);
                }
                if ((objectToEncode = m.method.getParameterTypes().length == 2 ? Invoker.invokeMethod(m.method, this.proxiedInstance, resource, decoded) : Invoker.invokeMethod(m.method, this.proxiedInstance, decoded)) == null) continue;
                return Invoker.encode(this.encoders.get(m.method), objectToEncode);
            }
        }
        catch (Throwable t) {
            this.logger.error("", t);
        }
        return null;
    }

    private Object message(Method m, Object o) {
        if (m != null) {
            return Invoker.all(this.encoders.get(m), EMPTY, o, this.proxiedInstance, m);
        }
        return null;
    }

    @Override
    public Object target() {
        return this.proxiedInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processReady(AtmosphereResource r) {
        Object o = this.message(this.onReadyMethod, (Object)r);
        switch (this.onReadyMethod.getAnnotation(Ready.class).value()) {
            case RESOURCE: {
                if (o == null) return;
                try {
                    AtmosphereResource atmosphereResource = r;
                    synchronized (atmosphereResource) {
                        if (String.class.isAssignableFrom(o.getClass())) {
                            r.write(o.toString()).getResponse().flushBuffer();
                        } else {
                            if (!byte[].class.isAssignableFrom(o.getClass())) return;
                            r.write((byte[])o).getResponse().flushBuffer();
                        }
                        return;
                    }
                }
                catch (Exception ex) {
                    this.logger.warn("", ex);
                }
                return;
            }
            case BROADCASTER: {
                r.getBroadcaster().broadcast(o);
                return;
            }
            case ALL: {
                for (Broadcaster b : r.getAtmosphereConfig().getBroadcasterFactory().lookupAll()) {
                    b.broadcast(o);
                }
                return;
            }
        }
    }

    public String toString() {
        return "ManagedAtmosphereHandler proxy for " + this.proxiedInstance.getClass().getName();
    }

    public static final class Managed
    implements Serializable {
        final Object o;

        public Managed(Object o) {
            this.o = o;
        }

        public String toString() {
            return this.o.toString();
        }
    }

    public static final class MethodInfo {
        final Method method;
        boolean useStream;
        boolean useReader;

        public MethodInfo(Method method) {
            this.method = method;
        }
    }
}

