/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.interceptor.InvokationOrder;
import org.atmosphere.util.ExecutorsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleResourceInterceptor
extends AtmosphereInterceptorAdapter {
    private final Logger logger = LoggerFactory.getLogger(IdleResourceInterceptor.class);
    private long maxInactiveTime = -1L;
    private AtmosphereConfig config;

    @Override
    public void configure(AtmosphereConfig config) {
        this.config = config;
        String maxInactive = config.getInitParameter("org.atmosphere.cpr.CometSupport.maxInactiveActivity");
        if (maxInactive != null) {
            this.maxInactiveTime = Long.parseLong(maxInactive);
        }
        if (this.maxInactiveTime > 0L) {
            ExecutorsFactory.getScheduler(config).scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    IdleResourceInterceptor.this.idleResources();
                }
            }, 0L, 2L, TimeUnit.SECONDS);
        }
    }

    protected void idleResources() {
        for (Broadcaster b : this.config.getBroadcasterFactory().lookupAll()) {
            for (AtmosphereResource r : b.getAtmosphereResources()) {
                AtmosphereRequest req = ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).getRequest(false);
                try {
                    if (req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity") == null) {
                        return;
                    }
                    long l = (Long)req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity");
                    if (l <= 0L || System.currentTimeMillis() - l <= this.maxInactiveTime) continue;
                    req.setAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity", -1L);
                    this.logger.debug("IdleResourceInterceptor disconnecting {}", r);
                    if (!((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).isSuspended() || !((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).isInScope()) {
                        return;
                    }
                    Future f = (Future)req.getAttribute("heartbeat.future");
                    if (f != null) {
                        f.cancel(false);
                    }
                    req.removeAttribute("heartbeat.future");
                    Object o = req.getAttribute(FrameworkConfig.ASYNCHRONOUS_HOOK);
                    req.setAttribute(FrameworkConfig.ASYNCHRONOUS_HOOK, null);
                    if (o == null || !AsynchronousProcessor.AsynchronousProcessorHook.class.isAssignableFrom(o.getClass())) continue;
                    AsynchronousProcessor.AsynchronousProcessorHook h = (AsynchronousProcessor.AsynchronousProcessorHook)o;
                    h.closed();
                }
                catch (Throwable e) {
                    this.logger.warn("IdleResourceInterceptor", e);
                }
            }
        }
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        if (this.maxInactiveTime > 0L) {
            ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).getRequest(false).setAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity", System.currentTimeMillis());
        }
        return Action.CONTINUE;
    }

    @Override
    public InvokationOrder.PRIORITY priority() {
        return InvokationOrder.BEFORE_DEFAULT;
    }
}

