/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.atmosphere.container.NettyCometSupport;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereMappingException;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.nettosphere.ChannelWriter;
import org.atmosphere.nettosphere.ChunkedWriter;
import org.atmosphere.nettosphere.Config;
import org.atmosphere.nettosphere.Context;
import org.atmosphere.nettosphere.HttpStaticFileServerHandler;
import org.atmosphere.nettosphere.NettyWebSocket;
import org.atmosphere.nettosphere.StreamWriter;
import org.atmosphere.nettosphere.util.ChannelBufferPool;
import org.atmosphere.util.FakeHttpSession;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.CookieDecoder;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import org.jboss.netty.util.CharsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BridgeRuntime
extends HttpStaticFileServerHandler {
    private static final String KEEP_ALIVE = BridgeRuntime.class.getName() + "_keep-alive";
    private static final Logger logger = LoggerFactory.getLogger(BridgeRuntime.class);
    private final AtmosphereFramework framework;
    private final Config config;
    private final ScheduledExecutorService suspendTimer;
    private final ConcurrentHashMap<String, HttpSession> sessions = new ConcurrentHashMap();
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final WebSocketProcessor webSocketProcessor;
    private final ChannelGroup httpChannels = new DefaultChannelGroup("http");
    private final ChannelGroup websocketChannels = new DefaultChannelGroup("ws");
    private final ChannelBufferPool channelBufferPool;
    private final AsynchronousProcessor asynchronousProcessor;

    public BridgeRuntime(Config config) {
        super(config.path());
        this.config = config;
        this.framework = new AtmosphereFramework();
        if (config.broadcaster() != null) {
            this.framework.setDefaultBroadcasterClassName(config.broadcaster().getName());
        }
        this.framework.setAtmosphereDotXmlPath(config.configFile());
        this.framework.setAsyncSupport(new NettyCometSupport(this.framework.getAtmosphereConfig()){

            @Override
            public Action suspended(AtmosphereRequest request, AtmosphereResponse response) throws IOException, ServletException {
                Action a = super.suspended(request, response);
                if (BridgeRuntime.this.framework.getAtmosphereConfig().isSupportSession()) {
                    AtmosphereResource r = request.resource();
                    HttpSession s = request.getSession(true);
                    if (s != null) {
                        BridgeRuntime.this.sessions.put(r.uuid(), request.getSession(true));
                    }
                }
                return a;
            }

            public String toString() {
                return "NettoSphereAsyncSupport";
            }
        });
        try {
            if (config.broadcasterFactory() != null) {
                this.framework.setBroadcasterFactory(config.broadcasterFactory());
            }
        }
        catch (Throwable t) {
            logger.trace("", t);
        }
        if (config.broadcasterCache() != null) {
            try {
                this.framework.setBroadcasterCacheClassName(config.broadcasterCache().getName());
            }
            catch (Throwable t) {
                logger.trace("", t);
            }
        }
        Map<String, AtmosphereHandler> handlersMap = config.handlersMap();
        for (Map.Entry<String, AtmosphereHandler> entry : handlersMap.entrySet()) {
            this.framework.addAtmosphereHandler(entry.getKey(), entry.getValue());
        }
        if (config.webSocketProtocol() != null) {
            this.framework.setWebSocketProtocolClassName(config.webSocketProtocol().getName());
        }
        for (AtmosphereInterceptor atmosphereInterceptor : config.interceptors()) {
            this.framework.interceptor(atmosphereInterceptor);
        }
        if (!config.scanPackages().isEmpty()) {
            for (Class clazz : config.scanPackages()) {
                this.framework.addAnnotationPackage(clazz);
            }
        }
        final Context context = new Context.Builder().contextPath(config.mappingPath()).basePath(config.path()).build();
        ServletContext servletContext = (ServletContext)Proxy.newProxyInstance(BridgeRuntime.class.getClassLoader(), new Class[]{ServletContext.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    Method stub = Context.class.getMethod(method.getName(), method.getParameterTypes());
                    if (stub != null) {
                        return stub.invoke((Object)context, args);
                    }
                    logger.trace("Method {} not supported", (Object)method.getName());
                    return null;
                }
                catch (NoSuchMethodException ex) {
                    logger.trace("Method {} not supported", (Object)method.getName());
                    return null;
                }
            }
        });
        try {
            this.framework.externalizeDestroy(true).init(new NettyServletConfig(config.initParams(), servletContext));
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        this.suspendTimer = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors());
        this.webSocketProcessor = WebSocketProcessorFactory.getDefault().getWebSocketProcessor(this.framework);
        this.channelBufferPool = config.supportChunking() ? new ChannelBufferPool(0, config.writeBufferPoolSize(), config.writeBufferPoolCleanupFrequency(), this.framework.getAtmosphereConfig()) : null;
        for (String s : config.excludedInterceptors()) {
            this.framework.excludeInterceptor(s);
        }
        this.asynchronousProcessor = (AsynchronousProcessor)AsynchronousProcessor.class.cast(this.framework.getAsyncSupport());
    }

    public AtmosphereFramework framework() {
        return this.framework;
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent messageEvent) throws URISyntaxException, IOException {
        Object msg = messageEvent.getMessage();
        if (this.isShutdown.get()) {
            ctx.getChannel().close().addListener(ChannelFutureListener.CLOSE);
            return;
        }
        if (msg instanceof HttpRequest) {
            HttpRequest r = (HttpRequest)HttpRequest.class.cast(msg);
            List c = r.getHeaders("Connection");
            String u = r.getHeader("Upgrade");
            boolean webSocket = false;
            if (u != null && u.equalsIgnoreCase("websocket")) {
                webSocket = true;
            }
            for (String connection : c) {
                if (connection == null || !connection.toLowerCase().equalsIgnoreCase("upgrade")) continue;
                webSocket = true;
            }
            logger.trace("Handling request {}", (Object)r);
            if (webSocket) {
                this.handleWebSocketHandshake(ctx, messageEvent);
            } else {
                this.handleHttp(ctx, messageEvent);
            }
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, messageEvent);
        } else if (msg instanceof HttpChunk) {
            this.handleHttp(ctx, messageEvent);
        }
    }

    private void handleWebSocketHandshake(final ChannelHandlerContext ctx, MessageEvent messageEvent) throws IOException, URISyntaxException {
        final HttpRequest request = (HttpRequest)messageEvent.getMessage();
        if (request.getMethod() != HttpMethod.GET) {
            this.sendHttpResponse(ctx, request, (HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
            return;
        }
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketLocation(request), null, false);
        WebSocketServerHandshaker handshaker = wsFactory.newHandshaker(request);
        if (handshaker == null) {
            wsFactory.sendUnsupportedWebSocketVersionResponse(ctx.getChannel());
        } else {
            handshaker.handshake(ctx.getChannel(), request).addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        future.getChannel().close();
                    } else {
                        BridgeRuntime.this.websocketChannels.add((Object)ctx.getChannel());
                        AtmosphereRequest r = BridgeRuntime.this.createAtmosphereRequest(ctx, request);
                        NettyWebSocket webSocket = new NettyWebSocket(ctx.getChannel(), BridgeRuntime.this.framework.getAtmosphereConfig());
                        ctx.setAttachment((Object)webSocket);
                        if (request.headers().contains("X-wakeUpNIO")) {
                            for (int i = 0; i < 512; ++i) {
                                ((WebSocket)webSocket).write(" ");
                            }
                        }
                        BridgeRuntime.this.webSocketProcessor.open(webSocket, r, AtmosphereResponse.newInstance(BridgeRuntime.this.framework.getAtmosphereConfig(), r, webSocket));
                    }
                }
            });
        }
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, MessageEvent messageEvent) throws URISyntaxException, IOException {
        WebSocketFrame frame = (WebSocketFrame)messageEvent.getMessage();
        if (frame instanceof CloseWebSocketFrame) {
            ctx.getChannel().write((Object)frame).addListener(ChannelFutureListener.CLOSE);
        } else if (frame instanceof PingWebSocketFrame) {
            ctx.getChannel().write((Object)new PongWebSocketFrame(frame.getBinaryData()));
        } else if (frame instanceof BinaryWebSocketFrame) {
            ChannelBuffer binaryData = frame.getBinaryData();
            this.webSocketProcessor.invokeWebSocketProtocol((WebSocket)ctx.getAttachment(), binaryData.array(), binaryData.arrayOffset(), binaryData.readableBytes());
        } else if (frame instanceof TextWebSocketFrame) {
            this.webSocketProcessor.invokeWebSocketProtocol((WebSocket)ctx.getAttachment(), ((TextWebSocketFrame)frame).getText());
        } else if (frame instanceof PongWebSocketFrame) {
            if (this.config.enablePong()) {
                ctx.getChannel().write((Object)new PingWebSocketFrame(frame.getBinaryData()));
            } else {
                logger.trace("Received Pong Frame on Channel {}", (Object)ctx.getChannel());
            }
        } else {
            logger.warn("{} frame types not supported", frame.getClass());
            ctx.getChannel().close();
        }
    }

    private AtmosphereRequest createAtmosphereRequest(final ChannelHandlerContext ctx, HttpRequest request) throws URISyntaxException, UnsupportedEncodingException, MalformedURLException {
        String[] uuid;
        String[] transport;
        String u;
        String base = this.getBaseUri(request);
        URI requestUri = new URI(base.substring(0, base.length() - 1) + request.getUri());
        String ct = HttpHeaders.getHeader((HttpMessage)request, (String)"Content-Type", (String)"text/plain");
        long cl = HttpHeaders.getContentLength((HttpMessage)request, (long)0L);
        String method = request.getMethod().getName();
        String queryString = requestUri.getQuery();
        HashMap<String, String[]> qs = new HashMap<String, String[]>();
        if (queryString != null) {
            this.parseQueryString(qs, queryString);
        }
        if (ct.equalsIgnoreCase("application/x-www-form-urlencoded")) {
            this.parseQueryString(qs, new String(request.getContent().array(), "UTF-8"));
        }
        int last = (u = requestUri.toURL().toString()).indexOf("?") == -1 ? u.length() : u.indexOf("?");
        String url = u.substring(0, last);
        int l = url.contains(this.config.mappingPath()) ? requestUri.getAuthority().length() + requestUri.getScheme().length() + 3 + this.config.mappingPath().length() : requestUri.getAuthority().length() + requestUri.getScheme().length() + 3;
        HttpSession session = null;
        if (this.framework.getAtmosphereConfig().isSupportSession() && (transport = (String[])qs.get("X-Atmosphere-Transport")) != null && transport.length > 0 && (uuid = (String[])qs.get("X-Atmosphere-tracking-id")) != null && uuid.length > 0) {
            if (transport[0].equalsIgnoreCase("close")) {
                this.sessions.remove(uuid[0]);
            } else {
                session = this.sessions.get(uuid[0]);
                if (session == null) {
                    session = new FakeHttpSession("-1", null, System.currentTimeMillis(), -1);
                }
            }
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        AtmosphereRequest.Builder requestBuilder = new AtmosphereRequest.Builder();
        requestBuilder.requestURI(url.substring(l)).requestURL(url).pathInfo(url.substring(l)).headers(this.getHeaders(request)).method(method).contentType(ct).contentLength(cl).destroyable(false).attributes(attributes).servletPath(this.config.mappingPath()).session(session).cookies(this.getCookies(request)).queryStrings(qs).remoteInetSocketAddress(new Callable<InetSocketAddress>(){

            @Override
            public InetSocketAddress call() throws Exception {
                return (InetSocketAddress)ctx.getChannel().getRemoteAddress();
            }
        }).localInetSocketAddress(new Callable<InetSocketAddress>(){

            @Override
            public InetSocketAddress call() throws Exception {
                return (InetSocketAddress)ctx.getChannel().getLocalAddress();
            }
        });
        ChannelBuffer internalBuffer = request.getContent();
        if (!this.config.aggregateRequestBodyInMemory() && !method.equalsIgnoreCase("GET")) {
            return requestBuilder.body(internalBuffer.array()).build();
        }
        logger.trace("Unable to read in memory the request's bytes. Using stream");
        return requestBuilder.inputStream((InputStream)new ChannelBufferInputStream(internalBuffer)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleHttp(ChannelHandlerContext ctx, MessageEvent messageEvent) throws URISyntaxException, IOException {
        String method;
        AtmosphereInterceptorWriter asyncWriter;
        boolean keptOpen;
        boolean resumeOnBroadcast;
        Action a;
        AtmosphereRequest request;
        AtmosphereResponse response;
        boolean skipClose;
        block48: {
            Action action;
            String transport;
            boolean forceSuspend;
            boolean writeHeader;
            block51: {
                boolean aggregateBodyInMemory;
                block50: {
                    boolean ka;
                    HttpRequest hrequest;
                    block47: {
                        skipClose = false;
                        response = null;
                        request = null;
                        a = null;
                        resumeOnBroadcast = false;
                        keptOpen = false;
                        asyncWriter = null;
                        method = "GET";
                        writeHeader = false;
                        forceSuspend = false;
                        aggregateBodyInMemory = this.config.aggregateRequestBodyInMemory();
                        if (!(messageEvent.getMessage() instanceof HttpRequest)) break block50;
                        hrequest = (HttpRequest)messageEvent.getMessage();
                        ka = HttpHeaders.isKeepAlive((HttpMessage)hrequest);
                        asyncWriter = this.config.supportChunking() ? new ChunkedWriter(ctx.getChannel(), true, ka, this.channelBufferPool) : new StreamWriter(ctx.getChannel(), true, ka);
                        method = hrequest.getMethod().getName();
                        if (!hrequest.getUri().contains("X-Atmosphere")) {
                            block46: {
                                try {
                                    hrequest.headers().add(STATIC_MAPPING, (Object)"true");
                                    super.messageReceived(ctx, messageEvent);
                                    if (HttpHeaders.getHeader((HttpMessage)hrequest, (String)SERVICED) == null) break block46;
                                }
                                catch (Exception e) {
                                    logger.debug("Unexpected State", (Throwable)e);
                                    break block47;
                                }
                                finally {
                                    hrequest.headers().set(STATIC_MAPPING, (Object)"false");
                                }
                            }
                            hrequest.headers().set(STATIC_MAPPING, (Object)"false");
                        }
                    }
                    request = this.createAtmosphereRequest(ctx, hrequest);
                    request.setAttribute(KEEP_ALIVE, new Boolean(ka));
                    AtmosphereRequest.Body b = request.body();
                    if (!aggregateBodyInMemory && !hrequest.getMethod().equals((Object)HttpMethod.GET) && !b.isEmpty() && b.hasString() && b.asString().isEmpty() || b.hasBytes() && b.asBytes().length == 0) {
                        forceSuspend = true;
                    }
                    break block51;
                }
                request = ((State)State.class.cast((Object)ctx.getAttachment())).request;
                boolean isLast = ((HttpChunk)HttpChunk.class.cast(messageEvent.getMessage())).isLast();
                Boolean ka = (Boolean)request.getAttribute(KEEP_ALIVE);
                asyncWriter = this.config.supportChunking() ? new ChunkedWriter(ctx.getChannel(), isLast, ka, this.channelBufferPool) : new StreamWriter(ctx.getChannel(), isLast, ka);
                method = request.getMethod();
                ChannelBuffer internalBuffer = ((HttpChunk)HttpChunk.class.cast(messageEvent.getMessage())).getContent();
                if (!aggregateBodyInMemory && internalBuffer.hasArray()) {
                    request.body(internalBuffer.array());
                } else {
                    logger.trace("Unable to read in memory the request's bytes. Using stream");
                    request.body((InputStream)new ChannelBufferInputStream(internalBuffer));
                }
                if (!isLast) {
                    forceSuspend = true;
                }
            }
            response = new AtmosphereResponse.Builder().asyncIOWriter(asyncWriter).writeHeader(writeHeader).destroyable(false).header("Connection", "Keep-Alive").header("Server", "Nettosphere/2.0").request(request).build();
            if (this.config.supportChunking()) {
                response.setHeader("Transfer-Encoding", "chunked");
            }
            a = this.framework.doCometSupport(request, response);
            if (forceSuspend) {
                a.type(Action.TYPE.SUSPEND);
                keptOpen = true;
            }
            if ((transport = (String)request.getAttribute(FrameworkConfig.TRANSPORT_IN_USE)) == null) {
                transport = request.getHeader("X-Atmosphere-Transport");
            }
            if (a.type() == Action.TYPE.SUSPEND) {
                if (transport != null && (transport.equalsIgnoreCase("streaming") || transport.equalsIgnoreCase("sse"))) {
                    keptOpen = true;
                } else if (transport != null && (transport.equalsIgnoreCase("long-polling") || transport.equalsIgnoreCase("jsonp"))) {
                    resumeOnBroadcast = true;
                }
            }
            final State state = new State(request, (action = (Action)request.getAttribute(NettyCometSupport.SUSPEND)) == null ? Action.CONTINUE : action);
            ctx.setAttachment((Object)state);
            if (action != null && action.type() == Action.TYPE.SUSPEND) {
                if (action.timeout() != -1L) {
                    final AtomicReference<AtmosphereInterceptorWriter> w = new AtomicReference<AtmosphereInterceptorWriter>(asyncWriter);
                    final AtomicReference f = new AtomicReference();
                    f.set(this.suspendTimer.scheduleAtFixedRate(new Runnable(){

                        @Override
                        public void run() {
                            AtmosphereResourceImpl impl;
                            if (!((ChannelWriter)w.get()).isClosed() && System.currentTimeMillis() - ((ChannelWriter)w.get()).lastTick() > action.timeout() && (impl = state.resource()) != null) {
                                BridgeRuntime.this.asynchronousProcessor.endRequest(impl, false);
                                ((Future)f.get()).cancel(true);
                            }
                        }
                    }, action.timeout(), action.timeout(), TimeUnit.MILLISECONDS));
                }
                break block48;
            }
            if (action == null || action.type() != Action.TYPE.RESUME) break block48;
            resumeOnBroadcast = false;
        }
        try {
            if (asyncWriter == null) return;
            if (resumeOnBroadcast) return;
            if (keptOpen) return;
            if (!skipClose && response != null) {
                asyncWriter.close(response);
                return;
            }
            this.httpChannels.add((Object)ctx.getChannel());
            return;
        }
        finally {
            if (request != null && a != null && a.type() != Action.TYPE.SUSPEND) {
                request.destroy();
                response.destroy();
                this.framework.notify(Action.TYPE.DESTROYED, request, response);
            }
        }
        catch (AtmosphereMappingException ex) {
            block49: {
                if (!method.equalsIgnoreCase("GET")) break block49;
                logger.trace("Unable to map the request {}, trying static file", messageEvent.getMessage());
                try {
                    skipClose = true;
                    super.messageReceived(ctx, messageEvent);
                }
                catch (Exception e) {
                    logger.error("Unable to process request", (Throwable)e);
                    throw new IOException(e);
                }
                {
                    catch (Throwable throwable) {
                        try {
                            if (asyncWriter == null) throw throwable;
                            if (resumeOnBroadcast) throw throwable;
                            if (keptOpen) throw throwable;
                            if (!skipClose && response != null) {
                                asyncWriter.close(response);
                                throw throwable;
                            }
                            this.httpChannels.add((Object)ctx.getChannel());
                            throw throwable;
                        }
                        finally {
                            if (request != null && a != null && a.type() != Action.TYPE.SUSPEND) {
                                request.destroy();
                                response.destroy();
                                this.framework.notify(Action.TYPE.DESTROYED, request, response);
                            }
                        }
                    }
                }
            }
            try {
                if (asyncWriter == null) return;
                if (resumeOnBroadcast) return;
                if (keptOpen) return;
                if (!skipClose && response != null) {
                    asyncWriter.close(response);
                    return;
                }
                this.httpChannels.add((Object)ctx.getChannel());
                return;
            }
            finally {
                if (request != null && a != null && a.type() != Action.TYPE.SUSPEND) {
                    request.destroy();
                    response.destroy();
                    this.framework.notify(Action.TYPE.DESTROYED, request, response);
                }
            }
            catch (Throwable e) {
                logger.error("Unable to process request", e);
                throw new IOException(e);
            }
        }
    }

    @Override
    protected void sendError(ChannelHandlerContext ctx, HttpResponseStatus status, MessageEvent e) {
        if (this.websocketChannels.contains((Object)ctx.getChannel())) {
            logger.debug("Error {} for {}", (Object)status, (Object)e);
            ctx.getChannel().close().addListener(ChannelFutureListener.CLOSE);
        } else if (e != null) {
            HttpRequest request = (HttpRequest)e.getMessage();
            if (HttpHeaders.getHeader((HttpMessage)request, (String)STATIC_MAPPING, (String)"false").equalsIgnoreCase("false")) {
                super.sendError(ctx, status, e);
            }
        } else {
            super.sendError(ctx, status, e);
        }
    }

    public void destroy() {
        this.isShutdown.set(true);
        this.httpChannels.close();
        this.websocketChannels.write((Object)new CloseWebSocketFrame());
        if (this.framework != null) {
            this.framework.destroy();
        }
        this.suspendTimer.shutdown();
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelClosed(ctx, e);
        Object o = ctx.getAttachment();
        if (o == null) {
            return;
        }
        if (WebSocket.class.isAssignableFrom(o.getClass())) {
            WebSocket webSocket = (WebSocket)WebSocket.class.cast(o);
            AtmosphereResource r = webSocket.resource();
            logger.trace("Closing {}", (Object)(r != null ? r.uuid() : "NULL"));
            try {
                this.webSocketProcessor.close(webSocket, 1005);
            }
            catch (Exception ex) {
                logger.error("{}", (Object)webSocket, (Object)ex);
            }
        } else if (State.class.isAssignableFrom(o.getClass())) {
            logger.trace("State {}", o);
            State s = (State)State.class.cast(o);
            if (s.action.type() == Action.TYPE.SUSPEND) {
                this.asynchronousProcessor.endRequest(s.resource(), true);
            }
        } else {
            logger.error("Invalid state {} and Channel {}", o, (Object)ctx.getChannel());
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (e.getCause() != null && (e.getCause().getClass().equals(ClosedChannelException.class) || e.getCause().getClass().equals(IOException.class))) {
            logger.trace("Exception", e.getCause());
        } else if (e.getCause() != null && e.getCause().getClass().equals(TooLongFrameException.class)) {
            logger.error("TooLongFrameException. The request will be closed, make sure you increase the Config.maxChunkContentLength() to a higher value.", e.getCause());
            super.exceptionCaught(ctx, e);
        } else {
            logger.debug("Exception", e.getCause());
            super.exceptionCaught(ctx, e);
        }
    }

    private Map<String, String> getHeaders(HttpRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String name : request.getHeaderNames()) {
            headers.put(name, HttpHeaders.getHeader((HttpMessage)request, (String)name));
        }
        return headers;
    }

    private String getBaseUri(HttpRequest request) {
        return "http://" + HttpHeaders.getHeader((HttpMessage)request, (String)"Host", (String)"127.0.0.1") + "/";
    }

    private void parseQueryString(Map<String, String[]> qs, String queryString) {
        if (queryString != null) {
            String[] s;
            for (String a : s = queryString.split("&")) {
                String[] q = a.split("=");
                String[] z = new String[]{q.length > 1 ? q[1] : ""};
                qs.put(q[0], z);
            }
        }
    }

    private Set<javax.servlet.http.Cookie> getCookies(HttpRequest request) {
        HashSet<javax.servlet.http.Cookie> result = new HashSet<javax.servlet.http.Cookie>();
        String cookieHeader = request.getHeader("Cookie");
        if (cookieHeader != null) {
            Set cookies = new CookieDecoder().decode(cookieHeader);
            for (Cookie cookie : cookies) {
                javax.servlet.http.Cookie c = new javax.servlet.http.Cookie(cookie.getName(), cookie.getValue());
                if (cookie.getComment() != null) {
                    c.setComment(cookie.getComment());
                }
                if (cookie.getDomain() != null) {
                    c.setDomain(cookie.getDomain());
                }
                c.setHttpOnly(cookie.isHttpOnly());
                c.setMaxAge(cookie.getMaxAge());
                if (cookie.getPath() != null) {
                    c.setPath(cookie.getPath());
                }
                c.setSecure(cookie.isSecure());
                c.setVersion(cookie.getVersion());
                result.add(c);
            }
        }
        return result;
    }

    Config config() {
        return this.config;
    }

    private void sendHttpResponse(ChannelHandlerContext ctx, HttpRequest req, HttpResponse res) {
        if (res.getStatus().getCode() != 200) {
            res.setContent(ChannelBuffers.copiedBuffer((CharSequence)res.getStatus().toString(), (Charset)CharsetUtil.UTF_8));
            HttpHeaders.setContentLength((HttpMessage)res, (long)res.getContent().readableBytes());
        }
        ChannelFuture f = ctx.getChannel().write((Object)res);
        if (!HttpHeaders.isKeepAlive((HttpMessage)req) || res.getStatus().getCode() != 200) {
            f.addListener(ChannelFutureListener.CLOSE);
        }
    }

    private String getWebSocketLocation(HttpRequest req) {
        return "ws://" + req.getHeader("Host") + req.getUri();
    }

    private static final class NettyServletConfig
    implements ServletConfig {
        private final Map<String, String> initParams;
        private final ServletContext ctx;

        public NettyServletConfig(Map<String, String> initParams, ServletContext ctx) {
            this.initParams = initParams;
            this.ctx = ctx;
        }

        public String getServletName() {
            return "Netty";
        }

        public ServletContext getServletContext() {
            return this.ctx;
        }

        public String getInitParameter(String name) {
            return this.initParams.get(name);
        }

        public Enumeration getInitParameterNames() {
            return Collections.enumeration(this.initParams.keySet());
        }
    }

    public static final class State {
        final AtmosphereRequest request;
        final Action action;

        public State(AtmosphereRequest request, Action action) {
            this.request = request;
            this.action = action;
        }

        public AtmosphereResourceImpl resource() {
            return (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(this.request.resource());
        }
    }
}

