/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.Response;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.tomcat.util.http.mapper.MappingData;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.util.ExecutorsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tomcat7CometSupport
extends AsynchronousProcessor {
    private static final Logger logger = LoggerFactory.getLogger(Tomcat7CometSupport.class);
    public static final String COMET_EVENT = "CometEvent";
    private static final String SUSPENDED = Tomcat7CometSupport.class.getName() + ".suspended";
    private final Boolean closeConnectionOnInputStream;
    private static final IllegalStateException unableToDetectComet = new IllegalStateException(Tomcat7CometSupport.unableToDetectComet());

    public Tomcat7CometSupport(AtmosphereConfig config) {
        super(config);
        String b = config.getInitParameter("org.atmosphere.container.TomcatCometSupport.discardEOF");
        this.closeConnectionOnInputStream = b == null ? true : Boolean.parseBoolean(b.toString());
        try {
            Class.forName(CometEvent.class.getName());
        }
        catch (Throwable e) {
            logger.error("Unable to load class {}. Please make sure you have properly installed Atmosphere http://goo.gl/KEi8pc", e);
            throw new IllegalStateException(Tomcat7CometSupport.unableToDetectComet());
        }
    }

    @Override
    public Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        CometEvent event = (CometEvent)req.getAttribute(COMET_EVENT);
        if (event == null) {
            throw unableToDetectComet;
        }
        logger.trace("event {} with request {}", event, (Object)req);
        Action action = null;
        if (event.getEventType() == CometEvent.EventType.BEGIN) {
            action = this.suspended(req, res);
            if (action.type() == Action.TYPE.SUSPEND) {
                try {
                    if (action.timeout() != -1L) {
                        event.setTimeout((int)action.timeout());
                    } else {
                        event.setTimeout(Integer.MAX_VALUE);
                    }
                }
                catch (UnsupportedOperationException ex) {
                    logger.trace("Warning: CometEvent.setTimeout not supported on this Tomcat instance.  [The Tomcat native connector does not support timeouts on asynchronous I/O.]");
                }
                req.setAttribute(SUSPENDED, true);
            } else {
                this.bz51881(event, false);
            }
        } else if (event.getEventType() != CometEvent.EventType.READ) {
            if (event.getEventSubType() == CometEvent.EventSubType.CLIENT_DISCONNECT) {
                if (req.getAttribute(SUSPENDED) != null) {
                    req.setAttribute(SUSPENDED, null);
                    action = this.cancelled(req, res);
                }
                this.bz51881(event, false);
            } else if (event.getEventSubType() == CometEvent.EventSubType.TIMEOUT) {
                action = this.timedout(req, res);
                this.bz51881(event, false);
            } else if (event.getEventType() == CometEvent.EventType.ERROR) {
                this.bz51881(event, false);
            } else if (event.getEventType() == CometEvent.EventType.END) {
                if (req.resource() != null && req.resource().isResumed()) {
                    ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(req.resource())).cancel();
                } else if (req.getAttribute(SUSPENDED) != null && this.closeConnectionOnInputStream.booleanValue()) {
                    req.setAttribute(SUSPENDED, null);
                    action = this.cancelled(req, res);
                } else {
                    this.bz51881(event, false);
                }
            }
        }
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bz51881(final CometEvent event, boolean delay) throws IOException {
        block14: {
            try {
                String[] tomcatVersion = this.config.getServletContext().getServerInfo().substring(14).split("\\.");
                String minorVersion = tomcatVersion[2];
                if (minorVersion.indexOf("-") != -1 && Integer.valueOf(minorVersion = minorVersion.substring(0, minorVersion.indexOf("-"))) == 22) {
                    minorVersion = "23";
                }
                if (Integer.valueOf(tomcatVersion[0]) == 7 && Integer.valueOf(minorVersion) < 23) {
                    Request r;
                    logger.info("Patching Tomcat 7.0.22 and lower bz51881. Expect NPE inside CoyoteAdapter, just ignore them. Upgrade to 7.0.23");
                    try {
                        RequestFacade request = (RequestFacade)RequestFacade.class.cast(event.getHttpServletRequest());
                        Field coyoteRequest = RequestFacade.class.getDeclaredField("request");
                        coyoteRequest.setAccessible(true);
                        r = (Request)coyoteRequest.get(request);
                        r.recycle();
                        Field mappingData = Request.class.getDeclaredField("mappingData");
                        mappingData.setAccessible(true);
                        MappingData m = new MappingData();
                        m.context = null;
                        mappingData.set(r, m);
                    }
                    catch (Throwable t) {
                        logger.trace("Was unable to recycle internal Tomcat object");
                    }
                    finally {
                        this.close(event);
                    }
                    try {
                        ResponseFacade response = (ResponseFacade)ResponseFacade.class.cast(event.getHttpServletResponse());
                        Field coyoteResponse = ResponseFacade.class.getDeclaredField("response");
                        coyoteResponse.setAccessible(true);
                        r = (Response)coyoteResponse.get(response);
                        r.recycle();
                    }
                    catch (Throwable t) {
                        logger.trace("Was unable to recycle internal Tomcat object");
                    }
                    break block14;
                }
                if (delay) {
                    ExecutorsFactory.getScheduler(this.config).schedule(new Runnable(){

                        @Override
                        public void run() {
                            Tomcat7CometSupport.this.close(event);
                        }
                    }, 500L, TimeUnit.MILLISECONDS);
                } else {
                    this.close(event);
                }
            }
            catch (NumberFormatException ex) {
                logger.trace("This is a mofified version of Tomcat {}", this.config.getServletContext().getServerInfo().substring(14).split("\\."));
                this.close(event);
            }
        }
    }

    private void close(CometEvent event) {
        try {
            event.close();
        }
        catch (Exception ex) {
            logger.trace("event.close", ex);
        }
    }

    @Override
    public void action(AtmosphereResourceImpl r) {
        CometEvent event;
        super.action(r);
        if (r.action().type() == Action.TYPE.RESUME && r.isInScope() && (event = (CometEvent)r.getRequest(false).getAttribute(COMET_EVENT)) != null && !r.transport().equals((Object)AtmosphereResource.TRANSPORT.WEBSOCKET)) {
            this.close(event);
        }
    }

    @Override
    public AsyncSupport complete(AtmosphereResourceImpl r) {
        try {
            CometEvent event = (CometEvent)r.getRequest(false).getAttribute(COMET_EVENT);
            if (event == null) {
                return this;
            }
            if (!r.transport().equals((Object)AtmosphereResource.TRANSPORT.WEBSOCKET)) {
                this.bz51881(event, !r.isResumed());
            }
        }
        catch (IOException ex) {
            logger.debug("action failed", ex);
        }
        return this;
    }

    @Override
    public Action cancelled(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        Action action = super.cancelled(req, res);
        if (req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity") != null && (Long)Long.class.cast(req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity")) == -1L) {
            CometEvent event = (CometEvent)req.getAttribute(COMET_EVENT);
            if (event == null) {
                return action;
            }
            this.bz51881(event, false);
        }
        return action;
    }

    private static String unableToDetectComet() {
        StringBuilder sb = new StringBuilder();
        sb.append("Tomcat failed to detect this is a Comet application because context.xml ");
        sb.append("is missing or the Http11NioProtocol Connector is not enabled.");
        sb.append("You must use the atmosphere-native-runtime dependency in order to use native Comet Support");
        sb.append("\nIf that's not the case, you can also remove META-INF/context.xml and WEB-INF/lib/atmosphere-compat-tomcat7.jar");
        return sb.toString();
    }
}

