/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.nettosphere.ChannelWriter;
import org.atmosphere.nettosphere.util.ChannelBufferPool;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkedWriter
extends ChannelWriter {
    private static final Logger logger = LoggerFactory.getLogger(ChunkedWriter.class);
    private final ChannelBufferPool channelBufferPool;
    private final ChannelBuffer END = ChannelBuffers.wrappedBuffer((byte[])ENDCHUNK);
    private final ChannelBuffer DELIMITER = ChannelBuffers.wrappedBuffer((byte[])CHUNK_DELIMITER);
    private final AtomicBoolean headerWritten = new AtomicBoolean();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public ChunkedWriter(Channel channel, boolean writeHeader, boolean keepAlive, ChannelBufferPool channelBufferPool) {
        super(channel, writeHeader, keepAlive);
        this.channelBufferPool = channelBufferPool;
    }

    private ChannelBuffer writeHeaders(AtmosphereResponse response) throws UnsupportedEncodingException {
        if (this.writeHeader && !this.headerWritten.getAndSet(true) && response != null) {
            ChannelBuffer writeBuffer = this.channelBufferPool.poll();
            return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{writeBuffer, ChannelBuffers.wrappedBuffer((byte[])this.constructStatusAndHeaders(response, -1).getBytes("UTF-8"))});
        }
        return ChannelBuffers.EMPTY_BUFFER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(final AtmosphereResponse response) throws IOException {
        if (!this.channel.isOpen() || this.doneProcessing.get()) {
            return;
        }
        ChannelBuffer writeBuffer = this.writeHeaders(response);
        if (writeBuffer.readableBytes() > 0 && response != null) {
            final AtomicReference<ChannelBuffer> recycle = new AtomicReference<ChannelBuffer>(writeBuffer);
            try {
                this.lock.writeLock().lock();
                this.channel.write((Object)writeBuffer).addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        ChunkedWriter.this.channelBufferPool.offer((ChannelBuffer)recycle.get());
                        ChunkedWriter.this.prepareForClose(response);
                    }
                });
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        try {
            this.lock.writeLock().lock();
            this.prepareForClose(response);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void prepareForClose(AtmosphereResponse response) throws UnsupportedEncodingException {
        AtmosphereResource r;
        AtmosphereResource atmosphereResource = r = response != null ? response.resource() : null;
        if (r == null || r.isSuspended() && !r.isResumed()) {
            this.keepAlive = false;
        }
        this._close(response);
    }

    void _close(AtmosphereResponse response) throws UnsupportedEncodingException {
        if (!this.doneProcessing.getAndSet(true) && this.channel.isOpen()) {
            ChannelBuffer writeBuffer = this.writeHeaders(response);
            writeBuffer = ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{writeBuffer, this.END});
            this.channel.write((Object)writeBuffer).addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    logger.trace("Async Closing Done {}", (Object)ChunkedWriter.this.channel);
                    if (!ChunkedWriter.this.keepAlive) {
                        ChunkedWriter.this.channel.close().awaitUninterruptibly();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncIOWriter asyncWrite(final AtmosphereResponse response, byte[] data, int offset, int length) throws IOException {
        if (length == 0) {
            logger.trace("Data is empty {} => {}", (Object)data, (Object)length);
            return this;
        }
        ChannelBuffer writeBuffer = this.writeHeaders(response);
        if (this.headerWritten.get()) {
            writeBuffer = ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{writeBuffer, ChannelBuffers.wrappedBuffer((byte[])Integer.toHexString(length - offset).getBytes("UTF-8"))});
            writeBuffer = ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{writeBuffer, this.DELIMITER});
        }
        writeBuffer = ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{writeBuffer, ChannelBuffers.wrappedBuffer((byte[])data, (int)offset, (int)length)});
        if (this.headerWritten.get()) {
            writeBuffer = ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{writeBuffer, this.DELIMITER});
        }
        final AtomicReference<ChannelBuffer> recycle = new AtomicReference<ChannelBuffer>(writeBuffer);
        try {
            this.lock.writeLock().lock();
            if (this.doneProcessing.get()) {
                throw new IOException(this.channel + ": content already processed for " + response.uuid());
            }
            this.channel.write((Object)writeBuffer).addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    ChunkedWriter.this.channelBufferPool.offer((ChannelBuffer)recycle.get());
                    if (ChunkedWriter.this.channel.isOpen() && !future.isSuccess()) {
                        ChunkedWriter.this._close(response);
                    }
                }
            });
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.lastWrite = System.currentTimeMillis();
        return this;
    }
}

