/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.annotation.HandlesTypes;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.container.JSR356AsyncSupport;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.DefaultAsyncSupportResolver;
import org.atmosphere.cpr.SessionSupport;
import org.atmosphere.util.IOUtils;
import org.atmosphere.util.Utils;

@HandlesTypes(value={})
public class AtmosphereInitializer
implements ServletContainerInitializer {
    private static final String DISABLE_SWITCH_KEY = "org.atmosphere.cpr.AtmosphereInitializer.disabled";

    @Override
    public void onStartup(Set<Class<?>> classes, final ServletContext c) throws ServletException {
        c.log("Initializing AtmosphereFramework");
        for (Map.Entry<String, ? extends ServletRegistration> reg : c.getServletRegistrations().entrySet()) {
            String disableSwitchValue = reg.getValue().getInitParameter(DISABLE_SWITCH_KEY);
            if (Boolean.parseBoolean(disableSwitchValue)) {
                c.log("container managed initialization disabled for servlet: " + reg.getValue().getName());
                continue;
            }
            if (c.getAttribute(reg.getKey()) != null || !IOUtils.isAtmosphere(reg.getValue().getClassName())) continue;
            final AtmosphereFramework framework = new AtmosphereFramework(false, true);
            DefaultAsyncSupportResolver resolver = new DefaultAsyncSupportResolver(framework.getAtmosphereConfig());
            List<Class<? extends AsyncSupport>> l = resolver.detectWebSocketPresent(false, true);
            if (l.size() == 0 && resolver.testClassExists("javax.websocket.Endpoint")) {
                framework.setAsyncSupport(new JSR356AsyncSupport(new AtmosphereConfig(framework){

                    @Override
                    public ServletContext getServletContext() {
                        return c;
                    }

                    @Override
                    public String getInitParameter(String name) {
                        return c.getInitParameter(name);
                    }

                    @Override
                    public Enumeration<String> getInitParameterNames() {
                        return c.getInitParameterNames();
                    }
                }));
            }
            try {
                c.addListener(new ServletRequestListener(){

                    @Override
                    public void requestDestroyed(ServletRequestEvent sre) {
                    }

                    @Override
                    public void requestInitialized(ServletRequestEvent sre) {
                        HttpServletRequest r = (HttpServletRequest)HttpServletRequest.class.cast(sre.getServletRequest());
                        if (framework.getAtmosphereConfig().isSupportSession() && Utils.webSocketEnabled(r)) {
                            r.getSession(true);
                        }
                    }
                });
            }
            catch (Throwable t) {
                c.log("AtmosphereFramework : Unable to install WebSocket Session Creator", t);
            }
            try {
                boolean sessionSupport;
                String s = c.getInitParameter("org.atmosphere.cpr.sessionSupport");
                if (s != null && (sessionSupport = Boolean.valueOf(s).booleanValue()) && c.getMajorVersion() > 2) {
                    c.addListener(SessionSupport.class);
                    c.log("AtmosphereFramework : Installed " + SessionSupport.class);
                }
            }
            catch (Throwable t) {
                c.log("AtmosphereFramework : SessionSupport error. Make sure you also define {} as a listener in web.xml, see https://github.com/Atmosphere/atmosphere/wiki/Enabling-HttpSession-Support", t);
            }
            c.setAttribute(reg.getKey(), framework);
        }
    }
}

