/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.AtmosphereServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereFilter.class);
    private final AtmosphereServlet as = new AtmosphereServlet(true);
    private static final String EXCLUDE_FILES = "^.*\\.(ico|ICO|jpg|JPG|gif|GIF|doc|DOC|pdf|PDF)$";
    private String excluded = "^.*\\.(ico|ICO|jpg|JPG|gif|GIF|doc|DOC|pdf|PDF)$";

    @Override
    public void init(final FilterConfig filterConfig) throws ServletException {
        logger.info("AtmosphereServlet running as a Filter");
        this.as.init(new ServletConfig(){

            @Override
            public String getServletName() {
                return filterConfig.getFilterName();
            }

            @Override
            public ServletContext getServletContext() {
                return filterConfig.getServletContext();
            }

            @Override
            public String getInitParameter(String name) {
                return filterConfig.getInitParameter(name);
            }

            @Override
            public Enumeration<String> getInitParameterNames() {
                return filterConfig.getInitParameterNames();
            }
        });
        String s = filterConfig.getInitParameter("org.atmosphere.cpr.AtmosphereFilter.excludes");
        if (s != null) {
            this.excluded = s;
        }
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        AtmosphereRequest req = AtmosphereRequest.wrap((HttpServletRequest)request);
        AtmosphereResponse res = AtmosphereResponse.wrap((HttpServletResponse)response);
        Action a = null;
        if (req.getServletPath() == null || this.as.framework().getServletContext().getResource(req.getServletPath()) == null && !req.getServletPath().matches(this.excluded)) {
            a = this.as.framework().doCometSupport(req, res);
        }
        if (a == null || a.type() != Action.TYPE.SUSPEND) {
            chain.doFilter(request, response);
        }
    }

    @Override
    public void destroy() {
        this.as.destroy();
    }
}

