/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.inject;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereObjectFactory;
import org.atmosphere.inject.AtmosphereConfigInjectable;
import org.atmosphere.inject.AtmosphereFrameworkInjectable;
import org.atmosphere.inject.AtmosphereResourceFactoryInjectable;
import org.atmosphere.inject.AtmosphereResourceSessionFactoryInjectable;
import org.atmosphere.inject.BroadcasterFactoryInjectable;
import org.atmosphere.inject.Injectable;
import org.atmosphere.inject.MetaBroadcasterInjectable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectableObjectFactory
implements AtmosphereObjectFactory<Injectable<?>> {
    protected static final Logger logger = LoggerFactory.getLogger(AtmosphereFramework.class);
    public static final Class<Injectable<?>>[] DEFAULT_ATMOSPHERE_INJECTABLE = new Class[]{AtmosphereConfigInjectable.class, AtmosphereFrameworkInjectable.class, AtmosphereResourceFactoryInjectable.class, AtmosphereResourceSessionFactoryInjectable.class, BroadcasterFactoryInjectable.class, MetaBroadcasterInjectable.class};
    private final List<Injectable<?>> injectables = new ArrayList();
    private AtmosphereConfig config;

    @Override
    public void configure(AtmosphereConfig config) {
        this.config = config;
        for (Class<Injectable<?>> i : DEFAULT_ATMOSPHERE_INJECTABLE) {
            try {
                this.injectables.add(i.newInstance());
            }
            catch (Exception e) {
                logger.error("", e);
            }
        }
    }

    @Override
    public <T, U extends T> U newClassInstance(Class<T> classType, Class<U> defaultType) throws InstantiationException, IllegalAccessException {
        U instance = defaultType.newInstance();
        this.injectAtmosphereInternalObject(instance, defaultType, this.config.framework());
        this.postConstructExecution(instance, defaultType);
        return instance;
    }

    public <U> void postConstructExecution(U instance, Class<U> defaultType) throws IllegalAccessException {
        Method[] methods;
        for (Method m : methods = defaultType.getMethods()) {
            if (!m.isAnnotationPresent(PostConstruct.class)) continue;
            try {
                m.invoke(instance, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public <U> void injectAtmosphereInternalObject(U instance, Class<U> defaultType, AtmosphereFramework framework) throws IllegalAccessException {
        Field[] fields;
        block0: for (Field field : fields = defaultType.getDeclaredFields()) {
            field.setAccessible(true);
            if (!field.isAnnotationPresent(Inject.class)) continue;
            for (Injectable<?> c : this.injectables) {
                if (!c.supportedType(field.getType())) continue;
                field.set(instance, c.injectable(framework.getAtmosphereConfig()));
                continue block0;
            }
        }
    }

    @Override
    public AtmosphereObjectFactory allowInjectionOf(Injectable<?> injectable) {
        this.injectables.add(injectable);
        return this;
    }

    public String toString() {
        return InjectableObjectFactory.class.getName();
    }
}

