/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import java.io.IOException;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.nettosphere.ChannelWriter;
import org.atmosphere.nettosphere.util.Utils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamWriter
extends ChannelWriter {
    private static final Logger logger = LoggerFactory.getLogger(StreamWriter.class);
    private ChannelBuffer chainedBodyBuffer;

    public StreamWriter(Channel channel, boolean writeHeader, boolean keepAlive) {
        super(channel, writeHeader, keepAlive);
        this.setUpBuffers();
    }

    @Override
    public AsyncIOWriter asyncWrite(AtmosphereResponse response, byte[] data, int offset, int length) throws IOException {
        this.chainedBodyBuffer = ChannelBuffers.wrappedBuffer(this.chainedBodyBuffer, ChannelBuffers.wrappedBuffer(data, offset, length));
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    private void setUpBuffers() {
        if (this.chainedBodyBuffer == null) {
            this.chainedBodyBuffer = ChannelBuffers.EMPTY_BUFFER;
        }
    }

    @Override
    public void close(AtmosphereResponse response) throws IOException {
        if (this.doneProcessing.getAndSet(true) || !this.channel.isOpen()) {
            throw Utils.ioExceptionForChannel(this.channel, response.uuid());
        }
        logger.trace("About to flush to {} for {}", this.channel, (Object)response.uuid());
        ChannelBuffer statusAndHeadersBuffer = this.writeHeader ? ChannelBuffers.wrappedBuffer(this.constructStatusAndHeaders(response, this.chainedBodyBuffer.readableBytes()).getBytes("UTF-8")) : ChannelBuffers.EMPTY_BUFFER;
        ChannelBuffer drain = ChannelBuffers.wrappedBuffer(statusAndHeadersBuffer, this.chainedBodyBuffer);
        this.channel.write(drain).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                StreamWriter.this.chainedBodyBuffer = null;
                if (!StreamWriter.this.keepAlive) {
                    StreamWriter.this.channel.close().awaitUninterruptibly();
                }
            }
        });
    }
}

