/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.config.managed;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.atmosphere.config.managed.ManagedAtmosphereHandler;
import org.atmosphere.config.managed.ServiceInterceptor;
import org.atmosphere.config.service.ManagedService;
import org.atmosphere.config.service.PathParam;
import org.atmosphere.config.service.Singleton;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.handler.AnnotatedProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedServiceInterceptor
extends ServiceInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(ManagedServiceInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void mapAnnotatedService(boolean reMap, String path, AtmosphereRequest request, AtmosphereFramework.AtmosphereHandlerWrapper w) {
        Map<String, AtmosphereFramework.AtmosphereHandlerWrapper> map = this.config.handlers();
        synchronized (map) {
            if (this.config.handlers().get(path) == null) {
                String targetPath;
                AnnotatedProxy ap;
                ManagedAnnotation a;
                if (AnnotatedProxy.class.isAssignableFrom(w.atmosphereHandler.getClass()) && (a = this.managed(ap = (AnnotatedProxy)AnnotatedProxy.class.cast(w.atmosphereHandler), w.broadcaster.getClass())) != null && (targetPath = a.path()).indexOf("{") != -1 && targetPath.indexOf("}") != -1) {
                    try {
                        boolean singleton;
                        boolean bl = singleton = ap.target().getClass().getAnnotation(Singleton.class) != null;
                        if (!singleton) {
                            AnnotatedProxy h = this.proxyHandler();
                            Object o = this.config.framework().newClassInstance(Object.class, ap.target().getClass());
                            h.configure(this.config, o);
                            if (h.pathParams()) {
                                this.prepareForPathInjection(path, targetPath, o);
                            }
                            this.config.framework().addAtmosphereHandler(path, (AtmosphereHandler)h, this.config.getBroadcasterFactory().lookup(a.broadcaster(), path, true), w.interceptors);
                        } else {
                            this.config.framework().addAtmosphereHandler(path, w.atmosphereHandler, this.config.getBroadcasterFactory().lookup(a.broadcaster(), path, true), w.interceptors);
                        }
                        request.setAttribute(FrameworkConfig.NEW_MAPPING, "true");
                    }
                    catch (Throwable e) {
                        logger.warn("Unable to create AtmosphereHandler", e);
                    }
                }
            } else if (reMap) {
                request.setAttribute(FrameworkConfig.NEW_MAPPING, "true");
            }
        }
    }

    protected AnnotatedProxy proxyHandler() throws IllegalAccessException, InstantiationException {
        return this.config.framework().newClassInstance(AnnotatedProxy.class, ManagedAtmosphereHandler.class);
    }

    protected ManagedAnnotation managed(AnnotatedProxy ap, final Class<? extends Broadcaster> aClass) {
        final ManagedService a = ap.target().getClass().getAnnotation(ManagedService.class);
        if (a == null) {
            return null;
        }
        return new ManagedAnnotation(){

            @Override
            public String path() {
                return a.path();
            }

            @Override
            public Class<? extends Broadcaster> broadcaster() {
                return aClass;
            }
        };
    }

    protected void prepareForPathInjection(String path, String targetPath, Object o) {
        logger.debug("Path: {}, targetPath: {}", (Object)path, (Object)targetPath);
        String[] inParts = path.split("/");
        String[] outParts = targetPath.split("/");
        HashMap<String, String> annotatedPathVars = new HashMap<String, String>();
        int len = Math.min(outParts.length, inParts.length);
        for (int i = 0; i < len; ++i) {
            String s = outParts[i];
            if (!s.startsWith("{") || !s.endsWith("}")) continue;
            int end = s.contains(":") ? s.indexOf(":") : s.length() - 1;
            annotatedPathVars.put(s.substring(1, end), inParts[i]);
            logger.debug("Putting PathVar pair: {} -> {}", (Object)s.substring(1, s.length() - 1), (Object)inParts[i]);
        }
        this.injectPathParams(o, annotatedPathVars);
    }

    protected void injectPathParams(Object o, Map<String, String> annotatedPathVars) {
        for (Field field : o.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(PathParam.class)) continue;
            PathParam annotation = field.getAnnotation(PathParam.class);
            String name = annotation.value();
            if (name.isEmpty()) {
                name = field.getName();
            }
            if (annotatedPathVars.containsKey(name)) {
                try {
                    logger.debug("Annotating field {}", (Object)name);
                    field.setAccessible(true);
                    field.set(o, annotatedPathVars.get(name));
                }
                catch (Exception e) {
                    logger.error("Error processing @PathVariable annotation", (Throwable)e);
                }
                continue;
            }
            logger.error("No path marker found for PathVariable {}, class {}", (Object)field.getName(), o.getClass());
        }
    }

    @Override
    public String toString() {
        return "@ManagedService Interceptor";
    }

    protected static interface ManagedAnnotation {
        public String path();

        public Class<? extends Broadcaster> broadcaster();
    }
}

