/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.nettosphere.util.Utils;
import org.atmosphere.util.IOUtils;
import org.atmosphere.websocket.WebSocket;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyWebSocket
extends WebSocket {
    private static final Logger logger = LoggerFactory.getLogger(NettyWebSocket.class);
    private final Channel channel;
    private final AtomicBoolean firstWrite = new AtomicBoolean(false);
    private int bufferBinarySize = Integer.MAX_VALUE;
    private int bufferStringSize = Integer.MAX_VALUE;
    private boolean binaryWrite = false;
    private final boolean noInternalAlloc;
    private Future<?> closeFuture;
    private final AtomicBoolean isClosed = new AtomicBoolean();

    public NettyWebSocket(Channel channel, AtmosphereConfig config, boolean noInternalAlloc, boolean binaryWrite) {
        super(config);
        this.channel = channel;
        String s = config.getInitParameter("org.atmosphere.websocket.maxBinaryMessageSize");
        if (s != null) {
            this.bufferBinarySize = Integer.valueOf(s);
        }
        if ((s = config.getInitParameter("org.atmosphere.websocket.maxTextMessageSize")) != null) {
            this.bufferStringSize = Integer.valueOf(s);
        }
        this.noInternalAlloc = noInternalAlloc;
        this.binaryWrite = binaryWrite;
        this.lastWrite = System.currentTimeMillis();
    }

    @Override
    public WebSocket resource(AtmosphereResource r) {
        super.resource(r);
        if (this.noInternalAlloc) {
            this.uuid = String.valueOf(this.channel.getId());
        }
        if (!this.binaryWrite && r != null && r.getRequest() != null) {
            try {
                this.binaryWrite = IOUtils.isBodyBinary(r.getRequest());
            }
            catch (Exception ex) {
                logger.trace("", (Throwable)ex);
            }
        }
        return this;
    }

    @Override
    public WebSocket write(String data) throws IOException {
        this.firstWrite.set(true);
        if (!this.channel.isOpen()) {
            throw Utils.REMOTELY_CLOSED;
        }
        logger.trace("WebSocket.write() as binary {}", (Object)this.binaryWrite);
        if (this.binaryWrite) {
            this.channel.write((Object)new BinaryWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])data.getBytes("UTF-8"))));
        } else {
            this.channel.write((Object)new TextWebSocketFrame(data));
        }
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    public WebSocket write(byte[] data) throws IOException {
        this._write(data, 0, data.length);
        return this;
    }

    @Override
    public WebSocket write(byte[] data, int offset, int length) throws IOException {
        this._write(data, offset, length);
        return this;
    }

    void _write(byte[] data, int offset, int length) throws IOException {
        this.firstWrite.set(true);
        if (!this.channel.isOpen()) {
            throw Utils.REMOTELY_CLOSED;
        }
        logger.trace("WebSocket.write() as binary {}", (Object)this.binaryWrite);
        if (this.binaryWrite) {
            this.channel.write((Object)new BinaryWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])data, (int)offset, (int)length)));
        } else {
            this.channel.write((Object)new TextWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])data, (int)offset, (int)length)));
        }
        this.lastWrite = System.currentTimeMillis();
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() {
        if (this.isClosed.getAndSet(true)) {
            return;
        }
        this.channel.write((Object)new CloseWebSocketFrame()).addListener(ChannelFutureListener.CLOSE);
        if (this.closeFuture != null) {
            this.closeFuture.cancel(true);
        }
    }

    @Override
    public WebSocket sendPing(byte[] payload) {
        this.channel.write((Object)new PingWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])payload)));
        return this;
    }

    @Override
    public WebSocket sendPong(byte[] payload) {
        this.channel.write((Object)new PongWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])payload)));
        return this;
    }

    public String address() {
        return ((InetSocketAddress)this.channel.getRemoteAddress()).getAddress().getHostAddress();
    }

    protected WebSocket closeFuture(Future<?> closeFuture) {
        this.closeFuture = closeFuture;
        return this;
    }

    protected Future<?> closeFuture() {
        return this.closeFuture;
    }
}

