/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.atmosphere.cache.BroadcastMessage;
import org.atmosphere.cache.BroadcasterCacheInspector;
import org.atmosphere.cache.CacheMessage;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.cpr.BroadcasterCacheListener;
import org.atmosphere.util.ExecutorsFactory;
import org.atmosphere.util.UUIDProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UUIDBroadcasterCache
implements BroadcasterCache {
    private static final Logger logger = LoggerFactory.getLogger(UUIDBroadcasterCache.class);
    private final Map<String, ClientQueue> messages = new ConcurrentHashMap<String, ClientQueue>();
    private final Map<String, Long> activeClients = new ConcurrentHashMap<String, Long>();
    protected final List<BroadcasterCacheInspector> inspectors = new LinkedList<BroadcasterCacheInspector>();
    private ScheduledFuture scheduledFuture;
    protected ScheduledExecutorService taskScheduler;
    private long clientIdleTime = TimeUnit.SECONDS.toMillis(60L);
    private long invalidateCacheInterval = TimeUnit.SECONDS.toMillis(30L);
    private boolean shared = true;
    protected final List<Object> emptyList = Collections.emptyList();
    protected final List<BroadcasterCacheListener> listeners = new LinkedList<BroadcasterCacheListener>();
    private UUIDProvider uuidProvider;

    @Override
    public void configure(AtmosphereConfig config) {
        Object o = config.properties().get("shared");
        if (o != null) {
            this.shared = Boolean.parseBoolean(o.toString());
        }
        this.taskScheduler = this.shared ? ExecutorsFactory.getScheduler(config) : Executors.newSingleThreadScheduledExecutor();
        this.clientIdleTime = TimeUnit.SECONDS.toMillis(Long.valueOf(config.getInitParameter("org.atmosphere.cache.UUIDBroadcasterCache.clientIdleTime", "60")));
        this.invalidateCacheInterval = TimeUnit.SECONDS.toMillis(Long.valueOf(config.getInitParameter("org.atmosphere.cache.UUIDBroadcasterCache.invalidateCacheInterval", "30")));
        this.uuidProvider = config.uuidProvider();
    }

    @Override
    public void start() {
        this.scheduledFuture = this.taskScheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                UUIDBroadcasterCache.this.invalidateExpiredEntries();
            }
        }, 0L, this.invalidateCacheInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        this.cleanup();
        if (this.taskScheduler != null) {
            this.taskScheduler.shutdown();
        }
    }

    @Override
    public void cleanup() {
        this.messages.clear();
        this.activeClients.clear();
        this.emptyList.clear();
        this.inspectors.clear();
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
            this.scheduledFuture = null;
        }
    }

    @Override
    public CacheMessage addToCache(String broadcasterId, String uuid, BroadcastMessage message) {
        if (logger.isTraceEnabled()) {
            logger.trace("Adding for AtmosphereResource {} cached messages {}", (Object)uuid, message.message());
            logger.trace("Active clients {}", this.activeClients());
        }
        String messageId = this.uuidProvider.generateUuid();
        boolean cache = true;
        if (!this.inspect(message)) {
            cache = false;
        }
        CacheMessage cacheMessage = new CacheMessage(messageId, message.message(), uuid);
        if (cache) {
            if (uuid.equals("null")) {
                for (Map.Entry<String, Long> entry : this.activeClients.entrySet()) {
                    this.addMessageIfNotExists(broadcasterId, entry.getKey(), cacheMessage);
                }
            } else {
                this.cacheCandidate(broadcasterId, uuid);
                this.addMessageIfNotExists(broadcasterId, uuid, cacheMessage);
            }
        }
        return cacheMessage;
    }

    @Override
    public List<Object> retrieveFromCache(String broadcasterId, String uuid) {
        ArrayList<Object> result = new ArrayList<Object>();
        this.cacheCandidate(broadcasterId, uuid);
        ClientQueue clientQueue = this.messages.remove(uuid);
        if (clientQueue != null) {
            ConcurrentLinkedQueue<CacheMessage> clientMessages = clientQueue.getQueue();
            for (CacheMessage cacheMessage : clientMessages) {
                result.add(cacheMessage.getMessage());
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Retrieved for AtmosphereResource {} cached messages {}", (Object)uuid, result);
            logger.trace("Available cached message {}", this.messages);
        }
        return result;
    }

    @Override
    public BroadcasterCache clearCache(String broadcasterId, String uuid, CacheMessage message) {
        ClientQueue clientQueue = this.messages.get(uuid);
        if (clientQueue != null) {
            logger.trace("Removing for AtmosphereResource {} cached message {}", (Object)uuid, message.getMessage());
            this.notifyRemoveCache(broadcasterId, message);
            clientQueue.getQueue().remove(message);
            clientQueue.getIds().remove(message.getId());
        }
        return this;
    }

    @Override
    public BroadcasterCache inspector(BroadcasterCacheInspector b) {
        this.inspectors.add(b);
        return this;
    }

    @Override
    public BroadcasterCache addBroadcasterCacheListener(BroadcasterCacheListener l) {
        this.listeners.add(l);
        return this;
    }

    @Override
    public BroadcasterCache removeBroadcasterCacheListener(BroadcasterCacheListener l) {
        this.listeners.remove(l);
        return this;
    }

    protected String uuid(AtmosphereResource r) {
        return r.uuid();
    }

    private void addMessageIfNotExists(String broadcasterId, String clientId, CacheMessage message) {
        if (!this.hasMessage(clientId, message.getId())) {
            this.addMessage(broadcasterId, clientId, message);
        } else {
            logger.debug("Duplicate message {} for client {}", message, (Object)clientId);
        }
    }

    private void addMessage(String broadcasterId, String clientId, CacheMessage message) {
        ClientQueue clientQueue = this.messages.get(clientId);
        if (clientQueue == null) {
            clientQueue = new ClientQueue();
            if (this.activeClients.get(clientId) != null) {
                this.messages.put(clientId, clientQueue);
            } else {
                logger.debug("Client {} is no longer active. Not caching message {}}", (Object)clientId, (Object)message);
                return;
            }
        }
        this.notifyAddCache(broadcasterId, message);
        clientQueue.getQueue().offer(message);
        clientQueue.getIds().add(message.getId());
    }

    private void notifyAddCache(String broadcasterId, CacheMessage message) {
        for (BroadcasterCacheListener l : this.listeners) {
            try {
                l.onAddCache(broadcasterId, message);
            }
            catch (Exception ex) {
                logger.warn("Listener exception", ex);
            }
        }
    }

    private void notifyRemoveCache(String broadcasterId, CacheMessage message) {
        for (BroadcasterCacheListener l : this.listeners) {
            try {
                l.onRemoveCache(broadcasterId, message);
            }
            catch (Exception ex) {
                logger.warn("Listener exception", ex);
            }
        }
    }

    private boolean hasMessage(String clientId, String messageId) {
        ClientQueue clientQueue = this.messages.get(clientId);
        return clientQueue != null && clientQueue.getIds().contains(messageId);
    }

    public Map<String, ClientQueue> messages() {
        return this.messages;
    }

    public Map<String, Long> activeClients() {
        return this.activeClients;
    }

    protected boolean inspect(BroadcastMessage m) {
        for (BroadcasterCacheInspector b : this.inspectors) {
            if (b.inspect(m)) continue;
            return false;
        }
        return true;
    }

    public void setInvalidateCacheInterval(long invalidateCacheInterval) {
        this.invalidateCacheInterval = invalidateCacheInterval;
        this.scheduledFuture.cancel(true);
        this.start();
    }

    public void setClientIdleTime(long clientIdleTime) {
        this.clientIdleTime = clientIdleTime;
    }

    protected void invalidateExpiredEntries() {
        long now = System.currentTimeMillis();
        HashSet<String> inactiveClients = new HashSet<String>();
        for (Map.Entry<String, Long> entry : this.activeClients.entrySet()) {
            if (now - entry.getValue() <= this.clientIdleTime) continue;
            logger.trace("Invalidate client {}", (Object)entry.getKey());
            inactiveClients.add(entry.getKey());
        }
        for (String clientId : inactiveClients) {
            this.activeClients.remove(clientId);
            this.messages.remove(clientId);
        }
        for (String msg : this.messages().keySet()) {
            if (this.activeClients().containsKey(msg)) continue;
            this.messages().remove(msg);
        }
    }

    @Override
    public BroadcasterCache excludeFromCache(String broadcasterId, AtmosphereResource r) {
        this.activeClients.remove(r.uuid());
        return this;
    }

    @Override
    public BroadcasterCache cacheCandidate(String broadcasterId, String uuid) {
        long now = System.currentTimeMillis();
        this.activeClients.put(uuid, now);
        return this;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public List<BroadcasterCacheListener> listeners() {
        return this.listeners;
    }

    public List<BroadcasterCacheInspector> inspectors() {
        return this.inspectors;
    }

    public static final class ClientQueue
    implements Serializable {
        private static final long serialVersionUID = -126253550299206646L;
        private final ConcurrentLinkedQueue<CacheMessage> queue = new ConcurrentLinkedQueue();
        private final Set<String> ids = Collections.synchronizedSet(new HashSet());

        public ConcurrentLinkedQueue<CacheMessage> getQueue() {
            return this.queue;
        }

        public Set<String> getIds() {
            return this.ids;
        }

        public String toString() {
            return this.queue.toString();
        }
    }
}

