/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.container.JettyWebSocketHandler;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereRequestImpl;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.util.Utils;
import org.atmosphere.websocket.WebSocketProcessor;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketUtil {
    private static final Logger logger = LoggerFactory.getLogger(JettyWebSocketUtil.class);

    public static final Action doService(AsynchronousProcessor cometSupport, AtmosphereRequest req, AtmosphereResponse res, WebSocketFactory webSocketFactory) throws IOException, ServletException {
        Boolean b = (Boolean)req.getAttribute(org.atmosphere.websocket.WebSocket.WEBSOCKET_INITIATED);
        if (b == null) {
            b = Boolean.FALSE;
        }
        if (!Utils.webSocketEnabled(req) && req.getAttribute(org.atmosphere.websocket.WebSocket.WEBSOCKET_ACCEPT_DONE) == null) {
            if (req.resource() != null && req.resource().transport() == AtmosphereResource.TRANSPORT.WEBSOCKET) {
                org.atmosphere.websocket.WebSocket.notSupported(req, res);
                return Action.CANCELLED;
            }
            return null;
        }
        if (webSocketFactory != null && !b.booleanValue()) {
            req.setAttribute(org.atmosphere.websocket.WebSocket.WEBSOCKET_INITIATED, true);
            try {
                webSocketFactory.acceptWebSocket((HttpServletRequest)req, (HttpServletResponse)res);
            }
            catch (IllegalStateException ex) {
                logger.trace("", ex);
                org.atmosphere.websocket.WebSocket.notSupported(req, res);
                return Action.CANCELLED;
            }
            req.setAttribute(org.atmosphere.websocket.WebSocket.WEBSOCKET_ACCEPT_DONE, true);
            return new Action();
        }
        Action action = cometSupport.suspended(req, res);
        if (action.type() != Action.TYPE.SUSPEND && action.type() == Action.TYPE.RESUME) {
            req.setAttribute(org.atmosphere.websocket.WebSocket.WEBSOCKET_RESUME, true);
        }
        return action;
    }

    public static final WebSocketFactory getFactory(final AtmosphereConfig config, final WebSocketProcessor webSocketProcessor) {
        final AtomicBoolean useBuildInSession = new AtomicBoolean(config.isSupportSession());
        String s = config.getInitParameter("org.atmosphere.cpr.useBuildInSession");
        if (s != null) {
            useBuildInSession.set(Boolean.valueOf(s));
        }
        WebSocketFactory webSocketFactory = new WebSocketFactory(new WebSocketFactory.Acceptor(){

            public boolean checkOrigin(HttpServletRequest request, String origin) {
                logger.trace("WebSocket-checkOrigin request {} with origin {}", (Object)request.getRequestURI(), (Object)origin);
                return true;
            }

            public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
                logger.trace("WebSocket-connect request {} with protocol {}", (Object)request.getRequestURI(), (Object)protocol);
                boolean isDestroyable = false;
                String s = config.getInitParameter("org.atmosphere.cpr.recycleAtmosphereRequestResponse");
                if (s != null && Boolean.valueOf(s).booleanValue()) {
                    isDestroyable = true;
                }
                if (!webSocketProcessor.handshake(request)) {
                    throw new IllegalStateException();
                }
                return new JettyWebSocketHandler(AtmosphereRequestImpl.cloneRequest(request, false, useBuildInSession.get(), isDestroyable, config.getInitParameter("org.atmosphere.cpr.sessionCreate", true)), config.framework(), webSocketProcessor);
            }
        });
        int bufferSize = 8192;
        if (config.getInitParameter("org.atmosphere.websocket.bufferSize") != null) {
            bufferSize = Integer.valueOf(config.getInitParameter("org.atmosphere.websocket.bufferSize"));
        }
        logger.debug("WebSocket Buffer size {}", bufferSize);
        webSocketFactory.setBufferSize(bufferSize);
        int timeOut = 300000;
        if (config.getInitParameter("org.atmosphere.websocket.maxIdleTime") != null) {
            timeOut = Integer.valueOf(config.getInitParameter("org.atmosphere.websocket.maxIdleTime"));
        }
        logger.debug("WebSocket idle timeout {}", timeOut);
        webSocketFactory.setMaxIdleTime(timeOut);
        int maxTextBufferSize = 8192;
        if (config.getInitParameter("org.atmosphere.websocket.maxTextMessageSize") != null) {
            maxTextBufferSize = Integer.valueOf(config.getInitParameter("org.atmosphere.websocket.maxTextMessageSize"));
        }
        logger.debug("WebSocket maxTextBufferSize {}", maxTextBufferSize);
        webSocketFactory.setMaxTextMessageSize(maxTextBufferSize);
        int maxBinaryBufferSize = 8192;
        if (config.getInitParameter("org.atmosphere.websocket.maxBinaryMessageSize") != null) {
            maxBinaryBufferSize = Integer.valueOf(config.getInitParameter("org.atmosphere.websocket.maxBinaryMessageSize"));
        }
        logger.debug("WebSocket maxBinaryBufferSize {}", maxBinaryBufferSize);
        webSocketFactory.setMaxBinaryMessageSize(maxBinaryBufferSize);
        if (config.getInitParameter("org.atmosphere.websocket.jetty.minVersion") != null) {
            int minVersion = Integer.valueOf(config.getInitParameter("org.atmosphere.websocket.jetty.minVersion"));
            webSocketFactory.setMinVersion(minVersion);
            logger.debug("WebSocket Jetty minVersion {}", minVersion);
        }
        return webSocketFactory;
    }
}

