/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.inject;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ServiceLoader;
import java.util.Set;
import javax.inject.Inject;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereObjectFactory;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.inject.InjectIntrospector;
import org.atmosphere.inject.Injectable;
import org.atmosphere.inject.annotation.ApplicationScoped;
import org.atmosphere.inject.annotation.RequestScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectableObjectFactory
implements AtmosphereObjectFactory<Injectable<?>> {
    protected static final Logger logger = LoggerFactory.getLogger(AtmosphereFramework.class);
    private static final ServiceLoader<Injectable> injectableServiceLoader = ServiceLoader.load(Injectable.class);
    private final LinkedList<Injectable<?>> injectables = new LinkedList();
    private final LinkedList<InjectIntrospector<?>> introspectors = new LinkedList();
    private final LinkedList<InjectIntrospector<?>> requestScopedIntrospectors = new LinkedList();
    private AtmosphereConfig config;

    @Override
    public void configure(AtmosphereConfig config) {
        this.config = config;
        for (Injectable injectable : injectableServiceLoader) {
            try {
                logger.debug("Adding class {} as injectable", injectable.getClass());
                if (InjectIntrospector.class.isAssignableFrom(injectable.getClass())) {
                    InjectIntrospector ii = (InjectIntrospector)InjectIntrospector.class.cast(injectable);
                    this.introspectors.addFirst(ii);
                    if (injectable.getClass().isAnnotationPresent(RequestScoped.class)) {
                        config.properties().put(FrameworkConfig.NEED_RUNTIME_INJECTION, true);
                        this.requestScopedIntrospectors.addFirst(ii);
                    }
                }
                if (!injectable.getClass().isAnnotationPresent(ApplicationScoped.class) && (injectable.getClass().isAnnotationPresent(RequestScoped.class) || injectable.getClass().isAnnotationPresent(RequestScoped.class))) continue;
                this.injectables.addFirst(injectable);
            }
            catch (Exception e) {
                logger.error("", e);
            }
        }
        for (Injectable<Object> injectable : this.injectables) {
            try {
                this.injectInjectable(injectable, injectable.getClass(), config.framework());
            }
            catch (IllegalAccessException e) {
                logger.error("", e);
            }
        }
    }

    @Override
    public <T, U extends T> U newClassInstance(Class<T> classType, Class<U> defaultType) throws InstantiationException, IllegalAccessException {
        U instance = defaultType.newInstance();
        this.injectInjectable(instance, defaultType, this.config.framework());
        this.applyMethods(instance, defaultType);
        return instance;
    }

    public <T> T inject(T instance) throws InstantiationException, IllegalAccessException {
        this.injectInjectable(instance, instance.getClass(), this.config.framework());
        this.applyMethods(instance, instance.getClass());
        return instance;
    }

    public <U> void applyMethods(U instance, Class<U> defaultType) throws IllegalAccessException {
        HashSet<Method> methods = new HashSet<Method>();
        methods.addAll(Arrays.asList(defaultType.getDeclaredMethods()));
        methods.addAll(Arrays.asList(defaultType.getMethods()));
        this.injectMethods(methods, instance);
    }

    private <U> void injectMethods(Set<Method> methods, U instance) throws IllegalAccessException {
        for (Method m : methods) {
            for (Injectable injectable : this.introspectors) {
                ((InjectIntrospector)InjectIntrospector.class.cast(injectable)).introspectMethod(m, instance);
            }
        }
    }

    public <U> void injectInjectable(U instance, Class<? extends U> defaultType, AtmosphereFramework framework) throws IllegalAccessException {
        HashSet<Field> fields = new HashSet<Field>();
        fields.addAll(this.getInheritedPrivateFields(defaultType));
        this.injectFields(fields, instance, framework, this.injectables);
    }

    private Set<Field> getInheritedPrivateFields(Class<?> type) {
        HashSet<Field> result = new HashSet<Field>();
        for (Class<?> i = type; i != null && i != Object.class; i = i.getSuperclass()) {
            for (Field field : i.getDeclaredFields()) {
                if (field.isSynthetic()) continue;
                result.add(field);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <U> void injectFields(Set<Field> fields, U instance, AtmosphereFramework framework, LinkedList<Injectable<?>> injectable) throws IllegalAccessException {
        block3: for (Field field : fields) {
            if (!field.isAnnotationPresent(Inject.class)) continue;
            for (Injectable injectable2 : injectable) {
                if (!injectable2.supportedType(field.getType())) continue;
                if (InjectIntrospector.class.isAssignableFrom(injectable2.getClass())) {
                    ((InjectIntrospector)InjectIntrospector.class.cast(injectable2)).introspectField(field);
                }
                try {
                    field.setAccessible(true);
                    field.set(instance, injectable2.injectable(framework.getAtmosphereConfig()));
                    continue block3;
                }
                finally {
                    field.setAccessible(false);
                    continue block3;
                }
            }
        }
    }

    @Override
    public AtmosphereObjectFactory allowInjectionOf(Injectable<?> injectable) {
        this.injectables.add(injectable);
        return this;
    }

    public String toString() {
        return InjectableObjectFactory.class.getName();
    }

    public <U> U getInjectable(Class<U> u) {
        for (Injectable injectable : this.injectables) {
            if (!injectable.supportedType(u)) continue;
            return (U)injectable.injectable(this.config);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestScoped(Object instance, Class defaultType, AtmosphereResource r) throws IllegalAccessException {
        HashSet<Field> fields = new HashSet<Field>();
        fields.addAll(Arrays.asList(defaultType.getDeclaredFields()));
        fields.addAll(Arrays.asList(defaultType.getFields()));
        block3: for (Field field : fields) {
            if (!field.isAnnotationPresent(Inject.class)) continue;
            for (InjectIntrospector injectIntrospector : this.requestScopedIntrospectors) {
                injectIntrospector.introspectField(field);
                if (!injectIntrospector.supportedType(field.getType())) continue;
                try {
                    field.setAccessible(true);
                    field.set(instance, injectIntrospector.injectable(r));
                    continue block3;
                }
                finally {
                    field.setAccessible(false);
                    continue block3;
                }
            }
        }
    }
}

