/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import java.util.HashSet;
import java.util.Set;
import org.atmosphere.nettosphere.BridgeRuntime;
import org.atmosphere.nettosphere.util.ChannelBufferPool;
import org.atmosphere.websocket.WebSocket;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.group.ChannelGroup;

public class RuntimeEngine {
    private final BridgeRuntime runtime;

    public RuntimeEngine(BridgeRuntime runtime) {
        this.runtime = runtime;
    }

    public Channel find(int id) {
        Channel c = this.runtime.websocketChannels().find(id);
        if (c == null) {
            c = this.runtime.httpChannels().find(id);
        }
        return c;
    }

    public WebSocket findWebSocket(int id) {
        Object o;
        Channel c = this.runtime.websocketChannels().find(id);
        if (c != null && (o = c.getAttachment()) != null && WebSocket.class.isAssignableFrom(o.getClass())) {
            return (WebSocket)WebSocket.class.cast(o);
        }
        return null;
    }

    public Set<WebSocket> findAllWebSockets() {
        HashSet<WebSocket> s = new HashSet<WebSocket>();
        for (Channel c : this.runtime.websocketChannels()) {
            Object o;
            if (c == null || (o = c.getAttachment()) == null || !WebSocket.class.isAssignableFrom(o.getClass())) continue;
            s.add((WebSocket)WebSocket.class.cast(o));
        }
        return s;
    }

    public ChannelGroup httpChannels() {
        return this.runtime.httpChannels();
    }

    public ChannelGroup websocketChannels() {
        return this.runtime.websocketChannels();
    }

    public ChannelBufferPool channelBufferPool() {
        return this.runtime.channelBufferPool();
    }
}

