/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.nettosphere.util.Utils;
import org.atmosphere.util.IOUtils;
import org.atmosphere.websocket.WebSocket;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyWebSocket
extends WebSocket {
    private static final Logger logger = LoggerFactory.getLogger(NettyWebSocket.class);
    private Channel channel;
    private final AtomicBoolean firstWrite = new AtomicBoolean(false);
    private boolean binaryWrite = false;
    private final boolean noInternalAlloc;
    private Future<?> closeFuture;
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final Map<String, String> headers;

    public NettyWebSocket(Channel channel, AtmosphereConfig config, boolean noInternalAlloc, boolean binaryWrite, Map<String, String> headers) {
        super(config);
        this.channel = channel;
        this.noInternalAlloc = noInternalAlloc;
        this.binaryWrite = binaryWrite;
        this.headers = headers;
        this.lastWrite = System.currentTimeMillis();
    }

    @Override
    public WebSocket resource(AtmosphereResource r) {
        super.resource(r);
        if (this.noInternalAlloc) {
            this.uuid = String.valueOf(this.channel.getId());
        }
        if (!this.binaryWrite && r != null && r.getRequest() != null) {
            try {
                this.binaryWrite = IOUtils.isBodyBinary(r.getRequest());
            }
            catch (Exception ex) {
                logger.trace("", (Throwable)ex);
            }
        }
        logger.trace("WebSocket.write() as binary {}", (Object)this.binaryWrite);
        return this;
    }

    @Override
    public WebSocket write(String data) throws IOException {
        this.firstWrite.set(true);
        if (!this.channel.isOpen()) {
            throw Utils.REMOTELY_CLOSED;
        }
        if (this.binaryWrite) {
            this.channel.write((Object)new BinaryWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])data.getBytes("UTF-8"))));
        } else {
            this.channel.write((Object)new TextWebSocketFrame(data));
        }
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    @Override
    public WebSocket write(byte[] data) throws IOException {
        this._write(data, 0, data.length);
        return this;
    }

    @Override
    public WebSocket write(byte[] data, int offset, int length) throws IOException {
        this._write(data, offset, length);
        return this;
    }

    void _write(byte[] data, int offset, int length) throws IOException {
        this.firstWrite.set(true);
        if (!this.channel.isOpen()) {
            throw Utils.REMOTELY_CLOSED;
        }
        if (this.binaryWrite) {
            this.channel.write((Object)new BinaryWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])data, (int)offset, (int)length)));
        } else {
            this.channel.write((Object)new TextWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])data, (int)offset, (int)length)));
        }
        this.lastWrite = System.currentTimeMillis();
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() {
        if (this.isClosed.getAndSet(true)) {
            return;
        }
        try {
            this.channel.write((Object)new CloseWebSocketFrame()).addListener(ChannelFutureListener.CLOSE);
        }
        finally {
            if (this.closeFuture != null) {
                this.closeFuture.cancel(true);
            }
            this.headers.clear();
            this.channel.close();
        }
    }

    public void recycle() {
        if (this.headers != null) {
            this.headers.clear();
        }
        this.channel = null;
    }

    @Override
    public WebSocket sendPing(byte[] payload) {
        this.channel.write((Object)new PingWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])payload)));
        return this;
    }

    @Override
    public WebSocket sendPong(byte[] payload) {
        this.channel.write((Object)new PongWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])payload)));
        return this;
    }

    public String address() {
        return ((InetSocketAddress)this.channel.getRemoteAddress()).getAddress().getHostAddress();
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    protected WebSocket closeFuture(Future<?> closeFuture) {
        this.closeFuture = closeFuture;
        return this;
    }

    protected Future<?> closeFuture() {
        return this.closeFuture;
    }
}

