/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.config.managed;

import javax.inject.Named;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.interceptor.InvokationOrder;
import org.atmosphere.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceInterceptor
extends AtmosphereInterceptorAdapter {
    private final Logger logger = LoggerFactory.getLogger(ServiceInterceptor.class);
    protected AtmosphereConfig config;

    @Override
    public void configure(AtmosphereConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Action inspect(AtmosphereResource r) {
        AtmosphereFramework.AtmosphereHandlerWrapper w = null;
        try {
            w = (AtmosphereFramework.AtmosphereHandlerWrapper)r.getRequest().getAttribute(FrameworkConfig.ATMOSPHERE_HANDLER_WRAPPER);
            if (!w.wildcardMapping()) {
                Action action = Action.CONTINUE;
                return action;
            }
            this.mapAnnotatedService(r.getRequest(), w);
            Action action = Action.CONTINUE;
            return action;
        }
        finally {
            if (w != null && w.needRequestScopedInjection()) {
                try {
                    Utils.inject(r);
                }
                catch (IllegalAccessException e) {
                    this.logger.error("", e);
                }
            }
        }
    }

    protected void mapAnnotatedService(AtmosphereRequest request, AtmosphereFramework.AtmosphereHandlerWrapper w) {
        Broadcaster b = w.broadcaster;
        Object pathInfo = null;
        boolean reMap = false;
        String path = Utils.pathInfo(request);
        if (b.getID().contains("{")) {
            reMap = true;
            this.config.getBroadcasterFactory().remove(b.getID());
        }
        request.localAttributes().put(Named.class.getName(), path);
        this.mapAnnotatedService(reMap, path, request, w);
    }

    @Override
    public InvokationOrder.PRIORITY priority() {
        return InvokationOrder.AFTER_DEFAULT;
    }

    protected abstract void mapAnnotatedService(boolean var1, String var2, AtmosphereRequest var3, AtmosphereFramework.AtmosphereHandlerWrapper var4);
}

