/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereObjectFactory;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.handler.AnnotatedProxy;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.inject.InjectableObjectFactory;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    public static final boolean webSocketEnabled(HttpServletRequest request) {
        boolean allowWebSocketWithoutHeaders;
        if (Utils.closeMessage(request) || !Utils.webSocketQueryStringPresentOrNull(request)) {
            return false;
        }
        boolean bl = allowWebSocketWithoutHeaders = request.getHeader("X-Atmosphere-WebSocket-Proxy") != null;
        if (allowWebSocketWithoutHeaders) {
            return true;
        }
        boolean webSocketEnabled = Utils.rawWebSocket(request);
        return webSocketEnabled;
    }

    public static final boolean rawWebSocket(HttpServletRequest request) {
        Enumeration<String> connection = request.getHeaders("Connection");
        if (connection == null || !connection.hasMoreElements()) {
            connection = request.getHeaders("connection");
        }
        if (connection != null && connection.hasMoreElements()) {
            String[] e;
            for (String upgrade : e = connection.nextElement().toString().split(",")) {
                if (!upgrade.trim().equalsIgnoreCase("Upgrade")) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean firefoxWebSocketEnabled(HttpServletRequest request) {
        return Utils.webSocketEnabled(request) && request.getHeader("X-atmo-protocol") != null && request.getHeader("X-atmo-protocol").equals("true") && request.getHeader("User-Agent") != null && request.getHeader("User-Agent").toLowerCase().indexOf("firefox") != -1;
    }

    public static final boolean twoConnectionsTransport(AtmosphereResource.TRANSPORT t) {
        switch (t) {
            case JSONP: 
            case LONG_POLLING: 
            case STREAMING: 
            case SSE: 
            case POLLING: 
            case HTMLFILE: {
                return true;
            }
        }
        return false;
    }

    public static final boolean webSocketQueryStringPresentOrNull(HttpServletRequest request) {
        String transport = request.getHeader("X-Atmosphere-Transport");
        if (transport == null) {
            return true;
        }
        return transport.equalsIgnoreCase("websocket");
    }

    public static final boolean resumableTransport(AtmosphereResource.TRANSPORT t) {
        switch (t) {
            case JSONP: 
            case LONG_POLLING: {
                return true;
            }
        }
        return false;
    }

    public static final boolean pollableTransport(AtmosphereResource.TRANSPORT t) {
        switch (t) {
            case POLLING: 
            case CLOSE: 
            case AJAX: {
                return true;
            }
        }
        return false;
    }

    public static final boolean pushMessage(AtmosphereResource.TRANSPORT t) {
        switch (t) {
            case POLLING: 
            case AJAX: 
            case UNDEFINED: {
                return true;
            }
        }
        return false;
    }

    public static final boolean atmosphereProtocol(AtmosphereRequest r) {
        String p = r.getHeader("X-atmo-protocol");
        return p != null && Boolean.valueOf(p) != false;
    }

    public static final boolean webSocketMessage(AtmosphereResource r) {
        AtmosphereRequest request = ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).getRequest(false);
        return request.getAttribute(FrameworkConfig.WEBSOCKET_MESSAGE) != null;
    }

    public static boolean properProtocol(HttpServletRequest request) {
        boolean isWebSocket;
        Enumeration<String> connection = request.getHeaders("Connection");
        if (connection == null || !connection.hasMoreElements()) {
            connection = request.getHeaders("connection");
        }
        boolean isOK = false;
        boolean bl = isWebSocket = request.getHeader("sec-websocket-version") != null || request.getHeader("Sec-WebSocket-Draft") != null;
        if (connection != null && connection.hasMoreElements()) {
            String[] e;
            for (String upgrade : e = connection.nextElement().toString().split(",")) {
                if (!upgrade.trim().equalsIgnoreCase("upgrade")) continue;
                isOK = true;
            }
        }
        return isWebSocket ? isOK : true;
    }

    public static final AtmosphereResource websocketResource(AtmosphereResource r) {
        AtmosphereResource resource;
        String parentUUID = (String)((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).getRequest(false).getAttribute("org.atmosphere.cpr.AtmosphereResource.suspended.uuid");
        if (parentUUID != null && (resource = r.getAtmosphereConfig().resourcesFactory().find(parentUUID)) != null) {
            r = resource;
        }
        return r;
    }

    public static final boolean closeMessage(HttpServletRequest request) {
        String s = request.getHeader("X-Atmosphere-Transport");
        return s != null && s.equalsIgnoreCase("close");
    }

    public static Object invoke(Object proxiedInstance, Method m, Object o) {
        if (m != null) {
            try {
                Object[] objectArray;
                if (o == null || m.getParameterTypes().length == 0) {
                    objectArray = new Object[]{};
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = o;
                }
                return m.invoke(proxiedInstance, objectArray);
            }
            catch (IllegalAccessException e) {
                LOGGER.debug("", e);
            }
            catch (InvocationTargetException e) {
                LOGGER.debug("", e);
            }
        }
        LOGGER.trace("No Method Mapped for {}", o);
        return null;
    }

    public static final void inject(AtmosphereResource r) throws IllegalAccessException {
        AtmosphereConfig config = r.getAtmosphereConfig();
        if (config.properties().get(FrameworkConfig.NEED_RUNTIME_INJECTION) == null) {
            return;
        }
        AtmosphereObjectFactory injectableFactory = config.framework().objectFactory();
        if (!InjectableObjectFactory.class.isAssignableFrom(injectableFactory.getClass())) {
            return;
        }
        Object injectIn = Utils.injectIn(r);
        if (injectIn != null) {
            Utils.inject(injectIn, injectIn.getClass(), r);
        }
    }

    private static final void inject(Object object, Class clazz, AtmosphereResource r) throws IllegalAccessException {
        ((InjectableObjectFactory)InjectableObjectFactory.class.cast(r.getAtmosphereConfig().framework().objectFactory())).requestScoped(object, clazz, r);
    }

    public static final Object injectIn(AtmosphereResource r) {
        AtmosphereHandler h = r.getAtmosphereHandler();
        if (AtmosphereFramework.REFLECTOR_ATMOSPHEREHANDLER.getClass().isAssignableFrom(h.getClass())) {
            return ((WebSocketProcessor.WebSocketHandlerProxy)WebSocketProcessor.WebSocketHandlerProxy.class.cast(((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).webSocket().webSocketHandler())).proxied();
        }
        if (AnnotatedProxy.class.isAssignableFrom(h.getClass())) {
            return ((AnnotatedProxy)AnnotatedProxy.class.cast(h)).target();
        }
        if (ReflectorServletProcessor.class.isAssignableFrom(h.getClass())) {
            return ((ReflectorServletProcessor)ReflectorServletProcessor.class.cast(h)).getServlet();
        }
        return h;
    }

    public static final Set<Field> getInheritedPrivateFields(Class<?> type) {
        HashSet<Field> result = new HashSet<Field>();
        for (Class<?> i = type; i != null && i != Object.class; i = i.getSuperclass()) {
            for (Field field : i.getDeclaredFields()) {
                if (field.isSynthetic()) continue;
                result.add(field);
            }
        }
        return result;
    }

    public static final Set<Method> getInheritedPrivateMethod(Class<?> type) {
        HashSet<Method> result = new HashSet<Method>();
        for (Class<?> i = type; i != null && i != Object.class; i = i.getSuperclass()) {
            for (Method m : i.getDeclaredMethods()) {
                if (m.isSynthetic()) continue;
                result.add(m);
            }
        }
        return result;
    }
}

