/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.KeepOpenStreamAware;
import org.atmosphere.util.ByteArrayAsyncWriter;
import org.atmosphere.websocket.WebSocketHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebSocket
extends AtmosphereInterceptorWriter
implements KeepOpenStreamAware {
    protected static final Logger logger = LoggerFactory.getLogger(WebSocket.class);
    public static final String WEBSOCKET_INITIATED = WebSocket.class.getName() + ".initiated";
    public static final String WEBSOCKET_SUSPEND = WebSocket.class.getName() + ".suspend";
    public static final String WEBSOCKET_RESUME = WebSocket.class.getName() + ".resume";
    public static final String WEBSOCKET_ACCEPT_DONE = WebSocket.class.getName() + ".acceptDone";
    public static final String NOT_SUPPORTED = "Websocket protocol not supported";
    public static final String CLEAN_CLOSE = "Clean_Close";
    private AtmosphereResource r;
    protected long lastWrite = 0L;
    protected boolean binaryWrite;
    private final AtomicBoolean firstWrite = new AtomicBoolean(false);
    private final AtmosphereConfig config;
    private WebSocketHandler webSocketHandler;
    protected ByteBuffer bb = ByteBuffer.allocate(8192);
    protected CharBuffer cb = CharBuffer.allocate(8192);
    protected String uuid = "NUll";
    private Map<String, Object> attributesAtWebSocketOpen;
    private Object attachment;

    public WebSocket(AtmosphereConfig config) {
        String s = config.getInitParameter("org.atmosphere.websocket.binaryWrite");
        this.binaryWrite = s != null && Boolean.parseBoolean(s);
        this.config = config;
    }

    public AtmosphereConfig config() {
        return this.config;
    }

    protected WebSocket webSocketHandler(WebSocketHandler webSocketHandler) {
        this.webSocketHandler = webSocketHandler;
        return this;
    }

    public WebSocket binaryWrite(boolean binaryWrite) {
        this.binaryWrite = binaryWrite;
        return this;
    }

    public WebSocketHandler webSocketHandler() {
        return this.webSocketHandler;
    }

    public WebSocket resource(AtmosphereResource r) {
        if (this.r != null && r != null) {
            ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).cloneState(this.r);
        }
        this.r = r;
        if (r != null) {
            this.uuid = r.uuid();
        }
        return this;
    }

    public WebSocket shiftAttributes() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.putAll(((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(this.r)).getRequest(false).localAttributes());
        this.attributesAtWebSocketOpen = Collections.unmodifiableMap(m);
        return this;
    }

    public Map<String, Object> attributes() {
        return this.attributesAtWebSocketOpen;
    }

    public AtmosphereResource resource() {
        return this.r;
    }

    public long lastWriteTimeStampInMilliseconds() {
        return this.lastWrite == -1L ? System.currentTimeMillis() : this.lastWrite;
    }

    protected byte[] transform(byte[] b, int offset, int length) throws IOException {
        return this.transform(this.r.getResponse(), b, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] transform(AtmosphereResponse response, byte[] b, int offset, int length) throws IOException {
        AsyncIOWriter a = response.getAsyncIOWriter();
        ByteArrayAsyncWriter buffer = new ByteArrayAsyncWriter();
        try {
            response.asyncIOWriter(buffer);
            this.invokeInterceptor(response, b, offset, length);
            byte[] byArray = buffer.stream().toByteArray();
            return byArray;
        }
        finally {
            buffer.close(null);
            response.asyncIOWriter(a);
        }
    }

    @Override
    public WebSocket write(AtmosphereResponse r, String data) throws IOException {
        boolean transform;
        this.firstWrite.set(true);
        if (data == null) {
            logger.error("Cannot write null value for {}", (Object)this.resource());
            return this;
        }
        if (!this.isOpen()) {
            throw new IOException("Connection remotely closed for " + this.uuid);
        }
        logger.trace("WebSocket.write() {}", (Object)data);
        boolean bl = transform = this.filters.size() > 0 && r.getStatus() < 400;
        if (this.binaryWrite) {
            byte[] b = data.getBytes(this.resource().getResponse().getCharacterEncoding());
            if (transform) {
                b = this.transform(r, b, 0, b.length);
            }
            if (b != null) {
                this.write(b, 0, b.length);
            }
        } else {
            if (transform) {
                byte[] b = data.getBytes(this.resource().getResponse().getCharacterEncoding());
                data = new String(this.transform(r, b, 0, b.length), r.getCharacterEncoding());
            }
            if (data != null) {
                this.write(data);
            }
        }
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    @Override
    public WebSocket write(AtmosphereResponse r, byte[] data) throws IOException {
        if (data == null) {
            logger.error("Cannot write null value for {}", (Object)this.resource());
            return this;
        }
        return this.write(r, data, 0, data.length);
    }

    @Override
    public WebSocket write(AtmosphereResponse r, byte[] b, int offset, int length) throws IOException {
        boolean transform;
        this.firstWrite.set(true);
        if (b == null) {
            logger.error("Cannot write null value for {}", (Object)this.resource());
            return this;
        }
        if (!this.isOpen()) {
            throw new IOException("Connection remotely closed for " + this.uuid);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("WebSocket.write() {}", (Object)new String(b, offset, length, "UTF-8"));
        }
        boolean bl = transform = this.filters.size() > 0 && r.getStatus() < 400;
        if (this.binaryWrite || this.resource().forceBinaryWrite()) {
            if (transform) {
                b = this.transform(r, b, offset, length);
            }
            if (b != null) {
                this.write(b, 0, b.length);
            }
        } else {
            String data = null;
            String charset = r.getCharacterEncoding() == null ? "UTF-8" : r.getCharacterEncoding();
            data = transform ? new String(this.transform(r, b, offset, length), charset) : new String(b, offset, length, charset);
            if (data != null) {
                this.write(data);
            }
        }
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    public WebSocket broadcast(Object o) {
        if (this.r != null) {
            this.r.getBroadcaster().broadcast(o);
        } else {
            logger.debug("No AtmosphereResource Associated with this WebSocket.");
        }
        return this;
    }

    @Override
    public WebSocket writeError(AtmosphereResponse r, int errorCode, String message) throws IOException {
        super.writeError(r, errorCode, message);
        if (!this.firstWrite.get()) {
            logger.debug("The WebSocket handshake succeeded but the dispatched URI failed with status {} : {} The WebSocket connection is still open and client can continue sending messages.", (Object)(errorCode + " " + message), (Object)this.uuid());
        } else {
            logger.warn("Unable to write {} {}", (Object)errorCode, (Object)message);
        }
        return this;
    }

    @Override
    public WebSocket redirect(AtmosphereResponse r, String location) throws IOException {
        logger.error("WebSocket Redirect not supported");
        return this;
    }

    @Override
    public void close(AtmosphereResponse r) throws IOException {
        logger.trace("WebSocket.close() for {}", (Object)this.uuid);
        try {
            if (r.request() != null && r.request().getAttribute(CLEAN_CLOSE) == null) {
                this.close();
            }
        }
        catch (Exception ex) {
            logger.trace("", ex);
        }
        try {
            this.bb.clear();
            this.cb.clear();
        }
        catch (Exception ex) {
            logger.trace("", ex);
        }
    }

    @Override
    public WebSocket flush(AtmosphereResponse r) throws IOException {
        return this;
    }

    public abstract boolean isOpen();

    public abstract WebSocket write(String var1) throws IOException;

    public abstract WebSocket write(byte[] var1, int var2, int var3) throws IOException;

    public abstract void close();

    public String uuid() {
        return this.uuid;
    }

    public static void notSupported(AtmosphereRequest request, AtmosphereResponse response) throws IOException {
        response.addHeader("X-Atmosphere-error", NOT_SUPPORTED);
        response.sendError(501, NOT_SUPPORTED);
        logger.trace("{} for request {}", (Object)NOT_SUPPORTED, (Object)request);
    }

    public WebSocket sendPing(byte[] payload) {
        throw new UnsupportedOperationException();
    }

    public WebSocket sendPong(byte[] payload) {
        throw new UnsupportedOperationException();
    }

    public WebSocket attachment(Object attachment) {
        this.attachment = attachment;
        return this;
    }

    public Object attachment() {
        return this.attachment;
    }
}

