/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.nettosphere.BridgeRuntime;
import org.atmosphere.nettosphere.Config;
import org.atmosphere.nettosphere.NettyChannelInitializer;
import org.atmosphere.nettosphere.RuntimeEngine;
import org.atmosphere.nettosphere.extra.FlashPolicyServerChannelInitializer;
import org.atmosphere.nettosphere.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Nettosphere {
    public static final String FLASH_SUPPORT = Nettosphere.class.getName() + ".enableFlash";
    private static final Logger logger = LoggerFactory.getLogger(Nettosphere.class);
    private static final ChannelGroup ALL_CHANNELS = new DefaultChannelGroup("atmosphere", ImmediateEventExecutor.INSTANCE);
    private final ChannelInitializer channelInitializer;
    private final ServerBootstrap bootstrap;
    private final SocketAddress localSocket;
    private final BridgeRuntime runtime;
    private final AtomicBoolean started = new AtomicBoolean();
    private final ServerBootstrap bootstrapFlashPolicy;
    private final SocketAddress localPolicySocket;
    private final RuntimeEngine runtimeEngine;
    private MultithreadEventLoopGroup parentGroup;
    private MultithreadEventLoopGroup childGroup;

    private Nettosphere(Config config) {
        this.runtime = new BridgeRuntime(config);
        this.channelInitializer = new NettyChannelInitializer(this.runtime);
        this.localSocket = new InetSocketAddress(config.host(), config.port());
        this.bootstrap = this.buildBootstrap(config);
        if (config.initParams().containsKey(FLASH_SUPPORT)) {
            this.bootstrapFlashPolicy = this.buildBootstrapFlashPolicy(config);
            this.localPolicySocket = new InetSocketAddress(843);
        } else {
            this.configureBootstrap(this.bootstrap, config);
            this.bootstrapFlashPolicy = null;
            this.localPolicySocket = null;
        }
        this.runtimeEngine = new RuntimeEngine(this.runtime);
    }

    private void configureBootstrap(ServerBootstrap bootstrap, Config config) {
        bootstrap.childOption(ChannelOption.TCP_NODELAY, config.socketNoTcpDelay());
        bootstrap.childOption(ChannelOption.SO_KEEPALIVE, config.socketKeepAlive());
    }

    public AtmosphereFramework framework() {
        return this.runtime.framework();
    }

    public void start() {
        Channel serverChannel = this.bootstrap.bind(this.localSocket).channel();
        ALL_CHANNELS.add(serverChannel);
        this.started.set(true);
        if (this.bootstrapFlashPolicy != null) {
            try {
                this.bootstrapFlashPolicy.bind(this.localPolicySocket);
                logger.info("NettoSphere Flash Support Started on port {}.", (Object)this.localPolicySocket);
            }
            catch (Exception ex) {
                logger.error("", ex);
            }
        }
        logger.info("NettoSphere {} Started.", (Object)Version.getRawVersion());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Nettosphere.this.stop();
            }
        });
    }

    public void stop() {
        if (this.started.getAndSet(false)) {
            this.runtime.destroy();
            ChannelGroupFuture future = ALL_CHANNELS.close();
            future.awaitUninterruptibly();
            ALL_CHANNELS.clear();
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    private ServerBootstrap buildBootstrap(Config config) {
        ServerBootstrap bootstrap = new ServerBootstrap();
        this.parentGroup = config.epoll() ? new EpollEventLoopGroup() : new NioEventLoopGroup();
        this.childGroup = config.epoll() ? new EpollEventLoopGroup() : new NioEventLoopGroup();
        ((ServerBootstrap)bootstrap.channel(NioServerSocketChannel.class)).group(this.parentGroup, this.childGroup);
        bootstrap.childHandler(this.channelInitializer);
        return bootstrap;
    }

    private ServerBootstrap buildBootstrapFlashPolicy(Config config) {
        ServerBootstrap bootstrap = new ServerBootstrap();
        this.parentGroup = config.epoll() ? new EpollEventLoopGroup() : new NioEventLoopGroup();
        this.childGroup = config.epoll() ? new EpollEventLoopGroup() : new NioEventLoopGroup();
        ((ServerBootstrap)bootstrap.channel(NioServerSocketChannel.class)).group(this.parentGroup, this.childGroup);
        bootstrap.childHandler(new FlashPolicyServerChannelInitializer());
        return bootstrap;
    }

    public RuntimeEngine runtimeEngine() {
        return this.runtimeEngine;
    }

    public static void main(String[] args) throws Exception {
        Config.Builder b = new Config.Builder();
        b.resource(args[0]).port(8080).host("127.0.0.1");
        Nettosphere s = new Nettosphere(b.build());
        s.start();
        String a = "";
        logger.info("NettoSphere Server started");
        logger.info("Type quit to stop the server");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while (!a.equals("quit")) {
            a = br.readLine();
        }
        System.exit(-1);
    }

    public static final class Builder {
        private Config config = new Config.Builder().build();

        public Builder config(Config config) {
            this.config = config;
            return this;
        }

        public Nettosphere build() {
            return new Nettosphere(this.config);
        }
    }
}

