/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere.extra;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.util.CharsetUtil;

public class FlashPolicyServerHandler
extends SimpleChannelInboundHandler<Object> {
    private static final String NEWLINE = "\r\n";

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object e) throws Exception {
        ChannelFuture f = ctx.channel().write(this.getPolicyFileContents());
        f.addListener(ChannelFutureListener.CLOSE);
    }

    private ByteBuf getPolicyFileContents() throws Exception {
        return Unpooled.copiedBuffer("<?xml version=\"1.0\"?>\r\n<!DOCTYPE cross-domain-policy SYSTEM \"/xml/dtds/cross-domain-policy.dtd\">\r\n\r\n<!-- Policy file for xmlsocket://socks.example.com -->\r\n<cross-domain-policy> \r\n\r\n   <!-- This is a master socket policy file -->\r\n   <!-- No other socket policies on the host will be permitted -->\r\n   <site-control permitted-cross-domain-policies=\"master-only\"/>\r\n\r\n   <!-- Instead of setting to-ports=\"*\", administrator's can use ranges and commas -->\r\n   <allow-access-from domain=\"*\" to-ports=\"8080\" />\r\n\r\n</cross-domain-policy>\r\n", CharsetUtil.US_ASCII);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable t) throws Exception {
        if (t.getCause() instanceof ReadTimeoutException) {
            System.out.println("Connection timed out.");
            ctx.channel().close();
        } else {
            t.getCause().printStackTrace();
            ctx.channel().close();
        }
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.channelRead(ctx, msg);
    }
}

