/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.atmosphere.container.NettyCometSupport;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereMappingException;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereRequestImpl;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.AtmosphereResponseImpl;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.nettosphere.ChannelWriter;
import org.atmosphere.nettosphere.ChunkedWriter;
import org.atmosphere.nettosphere.Config;
import org.atmosphere.nettosphere.Context;
import org.atmosphere.nettosphere.HttpStaticFileServerHandler;
import org.atmosphere.nettosphere.NettyWebSocket;
import org.atmosphere.nettosphere.StreamWriter;
import org.atmosphere.util.FakeHttpSession;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketEventListener;
import org.atmosphere.websocket.WebSocketHandler;
import org.atmosphere.websocket.WebSocketPingPongListener;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class BridgeRuntime
extends HttpStaticFileServerHandler {
    public static boolean NETTY_41_PLUS;
    private static final String KEEP_ALIVE;
    private static final Logger logger;
    private final AtmosphereFramework framework;
    private final Config config;
    private final ScheduledExecutorService suspendTimer;
    private final ConcurrentHashMap<String, HttpSession> sessions = new ConcurrentHashMap();
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final WebSocketProcessor webSocketProcessor;
    private final ChannelGroup httpChannels = new DefaultChannelGroup("http", (EventExecutor)ImmediateEventExecutor.INSTANCE);
    private final ChannelGroup websocketChannels = new DefaultChannelGroup("ws", (EventExecutor)ImmediateEventExecutor.INSTANCE);
    private final AsynchronousProcessor asynchronousProcessor;
    private final int maxWebSocketFrameSize;
    private final AtmosphereRequest proxiedRequest;
    private final AtmosphereResponse proxiedResponse;
    private final AtmosphereResource proxiedResource;
    private int webSocketTimeout = -1;
    private final byte[] EMPTY = new byte[0];

    public BridgeRuntime(Config config) {
        super(config.path());
        this.config = config;
        this.framework = new AtmosphereFramework();
        if (config.broadcaster() != null) {
            this.framework.setDefaultBroadcasterClassName(config.broadcaster().getName());
        }
        this.framework.setAtmosphereDotXmlPath(config.configFile());
        try {
            if (config.broadcasterFactory() != null) {
                this.framework.setBroadcasterFactory(config.broadcasterFactory());
            }
        }
        catch (Throwable t) {
            logger.trace("", t);
        }
        if (config.broadcasterCache() != null) {
            try {
                this.framework.setBroadcasterCacheClassName(config.broadcasterCache().getName());
            }
            catch (Throwable t) {
                logger.trace("", t);
            }
        }
        Map<String, AtmosphereHandler> handlersMap = config.handlersMap();
        for (Map.Entry<String, AtmosphereHandler> entry : handlersMap.entrySet()) {
            this.framework.addAtmosphereHandler(entry.getKey(), entry.getValue());
        }
        final Map<String, WebSocketHandler> webSocketHandlerMap = config.webSocketHandlersMap();
        if (handlersMap.size() == 0 && !webSocketHandlerMap.isEmpty()) {
            this.framework.addAtmosphereHandler("/*", AtmosphereFramework.REFLECTOR_ATMOSPHEREHANDLER);
        }
        this.framework.getAtmosphereConfig().startupHook(new AtmosphereConfig.StartupHook(){

            @Override
            public void started(AtmosphereFramework framework) {
                for (Map.Entry e : webSocketHandlerMap.entrySet()) {
                    framework.addWebSocketHandler((String)e.getKey(), (WebSocketHandler)e.getValue());
                }
            }
        });
        if (config.webSocketProtocol() != null) {
            this.framework.setWebSocketProtocolClassName(config.webSocketProtocol().getName());
        }
        for (AtmosphereInterceptor i : config.interceptors()) {
            this.framework.interceptor(i);
        }
        if (!config.scanPackages().isEmpty()) {
            for (Class<?> s : config.scanPackages()) {
                this.framework.addAnnotationPackage(s);
            }
        }
        final Context context = new Context.Builder().attributes(config.servletContextAttributes()).contextPath(config.mappingPath()).basePath(config.path()).build();
        ServletContext ctx = (ServletContext)Proxy.newProxyInstance(BridgeRuntime.class.getClassLoader(), new Class[]{ServletContext.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    Method stub = Context.class.getMethod(method.getName(), method.getParameterTypes());
                    if (stub != null) {
                        return stub.invoke((Object)context, args);
                    }
                    logger.trace("Method {} not supported", (Object)method.getName());
                    return null;
                }
                catch (NoSuchMethodException ex) {
                    logger.trace("Method {} not supported", (Object)method.getName());
                    return null;
                }
            }
        });
        try {
            this.framework.externalizeDestroy(true).init(new NettyServletConfig(config.initParams(), ctx));
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        int max = this.framework.getAtmosphereConfig().getInitParameter("org.atmosphere.websocket.maxIdleTime", -1);
        if (max != -1) {
            this.webSocketTimeout = max;
        }
        this.framework.setAsyncSupport(new NettyCometSupport(this.framework.getAtmosphereConfig()){

            @Override
            public Action suspended(AtmosphereRequest request, AtmosphereResponse response) throws IOException, ServletException {
                Action a = super.suspended(request, response);
                if (BridgeRuntime.this.framework.getAtmosphereConfig().isSupportSession()) {
                    AtmosphereResource r = request.resource();
                    HttpSession s = request.getSession(true);
                    if (s != null) {
                        BridgeRuntime.this.sessions.put(r.uuid(), request.getSession(true));
                    }
                }
                return a;
            }

            public String toString() {
                return "NettoSphereAsyncSupport";
            }
        });
        this.suspendTimer = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors());
        this.webSocketProcessor = WebSocketProcessorFactory.getDefault().getWebSocketProcessor(this.framework);
        for (String s : config.excludedInterceptors()) {
            this.framework.excludeInterceptor(s);
        }
        this.asynchronousProcessor = (AsynchronousProcessor)AsynchronousProcessor.class.cast(this.framework.getAsyncSupport());
        this.maxWebSocketFrameSize = config.maxWebSocketFrameSize();
        if (config.noInternalAlloc()) {
            this.proxiedRequest = new AtmosphereRequestImpl.Builder().build();
            this.proxiedResponse = new AtmosphereResponseImpl.Builder().build();
            this.proxiedResource = new AtmosphereResourceImpl();
        } else {
            this.proxiedRequest = null;
            this.proxiedResponse = null;
            this.proxiedResource = null;
        }
    }

    public AtmosphereFramework framework() {
        return this.framework;
    }

    public void channelRead(ChannelHandlerContext ctx, Object messageEvent) throws URISyntaxException, IOException {
        Object msg = messageEvent;
        if (this.isShutdown.get()) {
            ctx.channel().close().addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        if (msg instanceof HttpRequest) {
            HttpRequest r = (HttpRequest)HttpRequest.class.cast(msg);
            List c = r.headers().getAll("Connection");
            String u = r.headers().get("Upgrade");
            boolean webSocket = false;
            if (u != null && u.equalsIgnoreCase("websocket")) {
                webSocket = true;
            }
            for (String connection : c) {
                if (connection == null || !connection.toLowerCase().equalsIgnoreCase("upgrade")) continue;
                webSocket = true;
            }
            logger.trace("Handling request {}", (Object)r);
            if (webSocket) {
                this.handleWebSocketHandshake(ctx, messageEvent);
            } else {
                this.handleHttp(ctx, messageEvent);
            }
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, messageEvent);
        } else if (msg instanceof HttpChunkedInput) {
            this.handleHttp(ctx, messageEvent);
        }
    }

    private void handleWebSocketHandshake(final ChannelHandlerContext ctx, Object messageEvent) throws IOException, URISyntaxException {
        HttpRequest request = (HttpRequest)messageEvent;
        if (request.getMethod() != HttpMethod.GET) {
            this.sendHttpResponse(ctx, request, (HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
            return;
        }
        ctx.pipeline().addBefore(BridgeRuntime.class.getName(), "encoder", (ChannelHandler)new HttpResponseEncoder());
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketLocation(request), this.config.subProtocols(), false, this.maxWebSocketFrameSize);
        WebSocketServerHandshaker handshaker = wsFactory.newHandshaker(request);
        if (handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
        } else {
            final NettyWebSocket webSocket = new NettyWebSocket(ctx.channel(), this.framework.getAtmosphereConfig(), this.config.noInternalAlloc(), this.config.binaryWrite());
            final AtmosphereRequest atmosphereRequest = this.createAtmosphereRequest(ctx, request, this.EMPTY);
            if (!this.webSocketProcessor.handshake(atmosphereRequest)) {
                this.sendError(ctx, HttpResponseStatus.BAD_REQUEST, null);
                return;
            }
            this.webSocketProcessor.notifyListener(webSocket, new WebSocketEventListener.WebSocketEvent<String>("", WebSocketEventListener.WebSocketEvent.TYPE.HANDSHAKE, webSocket));
            handshaker.handshake(ctx.channel(), (FullHttpRequest)request).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        future.channel().close();
                    } else {
                        BridgeRuntime.this.websocketChannels.add((Object)ctx.channel());
                        ctx.channel().attr(HttpStaticFileServerHandler.ATTACHMENT).set((Object)webSocket);
                        if (BridgeRuntime.this.config.noInternalAlloc()) {
                            webSocket.resource(BridgeRuntime.this.proxiedResource);
                        }
                        AtmosphereResponse response = BridgeRuntime.this.config.noInternalAlloc() ? BridgeRuntime.this.proxiedResponse : AtmosphereResponseImpl.newInstance(BridgeRuntime.this.framework.getAtmosphereConfig(), atmosphereRequest, webSocket);
                        BridgeRuntime.this.webSocketProcessor.open(webSocket, atmosphereRequest, response);
                        if (BridgeRuntime.this.webSocketTimeout > 0) {
                            webSocket.closeFuture(BridgeRuntime.this.suspendTimer.scheduleAtFixedRate(new Runnable(){

                                @Override
                                public void run() {
                                    if (webSocket.lastWriteTimeStampInMilliseconds() != 0L && System.currentTimeMillis() - webSocket.lastWriteTimeStampInMilliseconds() > (long)BridgeRuntime.this.webSocketTimeout) {
                                        logger.debug("Timing out {}", (Object)webSocket);
                                        webSocket.close();
                                    }
                                }
                            }, BridgeRuntime.this.webSocketTimeout, BridgeRuntime.this.webSocketTimeout, TimeUnit.MILLISECONDS));
                        }
                    }
                }
            });
        }
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, Object messageEvent) throws URISyntaxException, IOException {
        WebSocketFrame frame = (WebSocketFrame)messageEvent;
        logger.trace("Received frame {}", (Object)frame.getClass().getName());
        WebSocket attachment = (WebSocket)WebSocket.class.cast(ctx.channel().attr(ATTACHMENT).get());
        ByteBuf binaryData = frame.content();
        byte[] body = null;
        if (binaryData.isReadable()) {
            body = new byte[binaryData.readableBytes()];
            binaryData.readBytes(body);
        }
        if (frame instanceof CloseWebSocketFrame) {
            ctx.channel().write((Object)frame).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else if (frame instanceof PingWebSocketFrame) {
            if (WebSocketPingPongListener.class.isAssignableFrom(this.webSocketProcessor.getClass())) {
                ((WebSocketPingPongListener)WebSocketPingPongListener.class.cast(this.webSocketProcessor)).onPing(attachment, body, 0, body.length);
            } else {
                ctx.channel().writeAndFlush((Object)new PongWebSocketFrame(binaryData));
            }
        } else if (frame instanceof BinaryWebSocketFrame || frame instanceof TextWebSocketFrame && this.config.textFrameAsBinary()) {
            this.webSocketProcessor.invokeWebSocketProtocol(attachment, body, 0, body.length);
        } else if (frame instanceof TextWebSocketFrame) {
            this.webSocketProcessor.invokeWebSocketProtocol(attachment, ((TextWebSocketFrame)frame).text());
        } else if (frame instanceof PongWebSocketFrame) {
            if (WebSocketPingPongListener.class.isAssignableFrom(this.webSocketProcessor.getClass())) {
                ((WebSocketPingPongListener)WebSocketPingPongListener.class.cast(this.webSocketProcessor)).onPong(attachment, body, 0, body.length);
            }
            if (this.config.enablePong()) {
                ctx.channel().writeAndFlush((Object)new PingWebSocketFrame(frame.content()));
            } else {
                logger.trace("Received Pong Frame on Channel {}", (Object)ctx.channel());
            }
        } else {
            logger.warn("{} frame types not supported", frame.getClass());
            ctx.channel().close();
        }
    }

    private AtmosphereRequest createAtmosphereRequest(final ChannelHandlerContext ctx, HttpRequest request, byte[] body) throws URISyntaxException, UnsupportedEncodingException, MalformedURLException {
        String[] uuid;
        String[] transport;
        String u;
        String base = this.getBaseUri(request);
        URI requestUri = new URI(base.substring(0, base.length() - 1) + request.getUri());
        String ct = HttpHeaders.getHeader((HttpMessage)request, (String)"Content-Type", (String)"text/plain");
        long cl = HttpHeaders.getContentLength((HttpMessage)request, (long)0L);
        String method = request.getMethod().name();
        String queryString = requestUri.getQuery();
        HashMap<String, String[]> qs = new HashMap<String, String[]>();
        if (queryString != null) {
            this.parseQueryString(qs, queryString);
        }
        if (ct.equalsIgnoreCase("application/x-www-form-urlencoded") && FullHttpRequest.class.isAssignableFrom(request.getClass())) {
            this.parseQueryString(qs, new String(body));
        }
        int last = (u = requestUri.toURL().toString()).indexOf("?") == -1 ? u.length() : u.indexOf("?");
        String url = u.substring(0, last);
        int l = url.contains(this.config.mappingPath()) ? requestUri.getAuthority().length() + requestUri.getScheme().length() + 3 + this.config.mappingPath().length() : requestUri.getAuthority().length() + requestUri.getScheme().length() + 3;
        HttpSession session = null;
        if (this.framework.getAtmosphereConfig().isSupportSession() && (transport = (String[])qs.get("X-Atmosphere-Transport")) != null && transport.length > 0 && (uuid = (String[])qs.get("X-Atmosphere-tracking-id")) != null && uuid.length > 0) {
            if (transport[0].equalsIgnoreCase("close")) {
                this.sessions.remove(uuid[0]);
            } else {
                session = this.sessions.get(uuid[0]);
                if (session == null) {
                    session = new FakeHttpSession("-1", null, System.currentTimeMillis(), -1);
                }
            }
        }
        HashMap attributes = new HashMap();
        AtmosphereRequestImpl.Builder requestBuilder = new AtmosphereRequestImpl.Builder();
        ((AtmosphereRequestImpl.Builder)((AtmosphereRequestImpl.Builder)((AtmosphereRequestImpl.Builder)((AtmosphereRequestImpl.Builder)requestBuilder.requestURI(url.substring(l)).requestURL(url).pathInfo(url.substring(l)).headers((Map)this.getHeaders(request))).method(method).contentType(ct).contentLength(cl).destroyable(false).attributes((Map)attributes)).servletPath(this.config.mappingPath()).session(session).cookies((Set)this.getCookies(request))).queryStrings(qs)).remoteInetSocketAddress(new Callable<InetSocketAddress>(){

            @Override
            public InetSocketAddress call() throws Exception {
                return (InetSocketAddress)ctx.channel().remoteAddress();
            }
        }).localInetSocketAddress(new Callable<InetSocketAddress>(){

            @Override
            public InetSocketAddress call() throws Exception {
                return (InetSocketAddress)ctx.channel().localAddress();
            }
        });
        if (body.length > 0) {
            requestBuilder.body(body);
        }
        return requestBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleHttp(ChannelHandlerContext ctx, Object messageEvent) throws URISyntaxException, IOException {
        String method;
        AtmosphereInterceptorWriter asyncWriter;
        boolean keptOpen;
        boolean resumeOnBroadcast;
        Action a;
        AtmosphereRequest request;
        AtmosphereResponse response;
        boolean skipClose;
        block47: {
            Action action;
            String transport;
            boolean forceSuspend;
            boolean writeHeader;
            block50: {
                boolean aggregateBodyInMemory;
                block49: {
                    byte[] body;
                    HttpRequest hrequest;
                    block46: {
                        ByteBuf b;
                        skipClose = false;
                        response = null;
                        request = null;
                        a = null;
                        resumeOnBroadcast = false;
                        keptOpen = false;
                        asyncWriter = null;
                        method = "GET";
                        writeHeader = false;
                        forceSuspend = false;
                        aggregateBodyInMemory = this.config.aggregateRequestBodyInMemory();
                        if (!(messageEvent instanceof HttpRequest)) break block49;
                        hrequest = (HttpRequest)messageEvent;
                        body = this.EMPTY;
                        if (FullHttpRequest.class.isAssignableFrom(messageEvent.getClass()) && (b = ((FullHttpRequest)FullHttpRequest.class.cast(messageEvent)).content()).isReadable()) {
                            body = new byte[b.readableBytes()];
                            b.readBytes(body);
                        }
                        if (!hrequest.getUri().contains("X-Atmosphere")) {
                            block45: {
                                try {
                                    hrequest.headers().add(STATIC_MAPPING, (Object)"true");
                                    super.channelRead(ctx, messageEvent);
                                    if (HttpHeaders.getHeader((HttpMessage)hrequest, (String)SERVICED) == null) break block45;
                                }
                                catch (Exception e) {
                                    logger.debug("Unexpected State", (Throwable)e);
                                    break block46;
                                }
                                finally {
                                    hrequest.headers().set(STATIC_MAPPING, (Object)"false");
                                }
                            }
                            hrequest.headers().set(STATIC_MAPPING, (Object)"false");
                        }
                    }
                    boolean ka = HttpHeaders.isKeepAlive((HttpMessage)hrequest);
                    asyncWriter = this.config.supportChunking() ? new ChunkedWriter(ctx.channel(), true, ka) : new StreamWriter(ctx.channel(), true, ka);
                    method = hrequest.getMethod().name();
                    request = this.createAtmosphereRequest(ctx, hrequest, body);
                    request.setAttribute(KEEP_ALIVE, new Boolean(ka));
                    AtmosphereRequestImpl.Body b = request.body();
                    if (!aggregateBodyInMemory && !hrequest.getMethod().equals((Object)HttpMethod.GET) && !b.isEmpty() && b.hasString() && b.asString().isEmpty() || b.hasBytes() && b.asBytes().length == 0) {
                        forceSuspend = true;
                    }
                    break block50;
                }
                request = ((State)State.class.cast((Object)ctx.attr((AttributeKey)BridgeRuntime.ATTACHMENT).get())).request;
                boolean isLast = ((HttpChunkedInput)HttpChunkedInput.class.cast(messageEvent)).isEndOfInput();
                Boolean ka = (Boolean)request.getAttribute(KEEP_ALIVE);
                asyncWriter = this.config.supportChunking() ? new ChunkedWriter(ctx.channel(), isLast, ka) : new StreamWriter(ctx.channel(), isLast, ka);
                method = request.getMethod();
                ByteBuf internalBuffer = ((HttpChunkedInput)HttpChunkedInput.class.cast(messageEvent)).readChunk(ctx).content();
                if (!aggregateBodyInMemory && internalBuffer.hasArray()) {
                    request.body(internalBuffer.array());
                } else {
                    logger.trace("Unable to read in memory the request's bytes. Using stream");
                    request.body((InputStream)new ByteBufInputStream(internalBuffer));
                }
                if (!isLast) {
                    forceSuspend = true;
                }
            }
            response = new AtmosphereResponseImpl.Builder().asyncIOWriter(asyncWriter).writeHeader(writeHeader).destroyable(false).header("Connection", "Keep-Alive").header("Server", "Nettosphere/3.0").request(request).build();
            if (this.config.supportChunking()) {
                response.setHeader("Transfer-Encoding", "chunked");
            }
            a = this.framework.doCometSupport(request, response);
            if (forceSuspend) {
                a.type(Action.TYPE.SUSPEND);
                keptOpen = true;
            }
            if ((transport = (String)request.getAttribute(FrameworkConfig.TRANSPORT_IN_USE)) == null) {
                transport = request.getHeader("X-Atmosphere-Transport");
            }
            if (a.type() == Action.TYPE.SUSPEND) {
                if (transport != null && (transport.equalsIgnoreCase("streaming") || transport.equalsIgnoreCase("sse"))) {
                    keptOpen = true;
                } else if (transport != null && (transport.equalsIgnoreCase("long-polling") || transport.equalsIgnoreCase("jsonp"))) {
                    resumeOnBroadcast = true;
                }
            }
            final State state = new State(request, (action = (Action)request.getAttribute(NettyCometSupport.SUSPEND)) == null ? Action.CONTINUE : action);
            ctx.attr(ATTACHMENT).set((Object)state);
            if (action != null && action.type() == Action.TYPE.SUSPEND) {
                if (action.timeout() != -1L) {
                    final AtomicReference<AtmosphereInterceptorWriter> w = new AtomicReference<AtmosphereInterceptorWriter>(asyncWriter);
                    final AtomicReference f = new AtomicReference();
                    f.set(this.suspendTimer.scheduleAtFixedRate(new Runnable(){

                        @Override
                        public void run() {
                            AtmosphereResourceImpl impl;
                            if (!((ChannelWriter)w.get()).isClosed() && System.currentTimeMillis() - ((ChannelWriter)w.get()).lastTick() > action.timeout() && (impl = state.resource()) != null) {
                                BridgeRuntime.this.asynchronousProcessor.endRequest(impl, false);
                                ((Future)f.get()).cancel(true);
                            }
                        }
                    }, action.timeout(), action.timeout(), TimeUnit.MILLISECONDS));
                }
                break block47;
            }
            if (action == null || action.type() != Action.TYPE.RESUME) break block47;
            resumeOnBroadcast = false;
        }
        try {
            if (asyncWriter == null) return;
            if (resumeOnBroadcast) return;
            if (keptOpen) return;
            if (!skipClose && response != null) {
                asyncWriter.close(response);
                return;
            }
            this.httpChannels.add((Object)ctx.channel());
            return;
        }
        finally {
            if (request != null && a != null && a.type() != Action.TYPE.SUSPEND) {
                request.destroy();
                response.destroy();
                this.framework.notify(Action.TYPE.DESTROYED, request, response);
            }
        }
        catch (AtmosphereMappingException ex) {
            block48: {
                if (!method.equalsIgnoreCase("GET")) break block48;
                logger.trace("Unable to map the request {}, trying static file", messageEvent);
                {
                    catch (Throwable throwable) {
                        try {
                            if (asyncWriter == null) throw throwable;
                            if (resumeOnBroadcast) throw throwable;
                            if (keptOpen) throw throwable;
                            if (!skipClose && response != null) {
                                asyncWriter.close(response);
                                throw throwable;
                            }
                            this.httpChannels.add((Object)ctx.channel());
                            throw throwable;
                        }
                        finally {
                            if (request != null && a != null && a.type() != Action.TYPE.SUSPEND) {
                                request.destroy();
                                response.destroy();
                                this.framework.notify(Action.TYPE.DESTROYED, request, response);
                            }
                        }
                    }
                }
            }
            try {
                if (asyncWriter == null) return;
                if (resumeOnBroadcast) return;
                if (keptOpen) return;
                if (!skipClose && response != null) {
                    asyncWriter.close(response);
                    return;
                }
                this.httpChannels.add((Object)ctx.channel());
                return;
            }
            finally {
                if (request != null && a != null && a.type() != Action.TYPE.SUSPEND) {
                    request.destroy();
                    response.destroy();
                    this.framework.notify(Action.TYPE.DESTROYED, request, response);
                }
            }
            catch (Throwable e) {
                logger.error("Unable to process request", e);
                throw new IOException(e);
            }
        }
    }

    @Override
    public void sendError(ChannelHandlerContext ctx, HttpResponseStatus status, FullHttpRequest e) {
        logger.trace("Error {} for {}", (Object)status, (Object)e);
        if (this.websocketChannels.contains((Object)ctx.channel())) {
            logger.debug("Error {} for {}", (Object)status, (Object)e);
            ctx.channel().close().addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else if (e != null) {
            if (HttpHeaders.getHeader((HttpMessage)e, (String)STATIC_MAPPING, (String)"false").equalsIgnoreCase("false")) {
                super.sendError(ctx, status, e);
            }
        } else {
            super.sendError(ctx, status, e);
        }
    }

    public void destroy() {
        this.isShutdown.set(true);
        if (this.framework != null) {
            this.framework.destroy();
        }
        this.httpChannels.close();
        this.websocketChannels.write((Object)new CloseWebSocketFrame());
        this.suspendTimer.shutdown();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        Object o = ctx.attr(ATTACHMENT).get();
        if (o == null) {
            return;
        }
        if (WebSocket.class.isAssignableFrom(o.getClass())) {
            NettyWebSocket webSocket = (NettyWebSocket)NettyWebSocket.class.cast(o);
            logger.trace("Closing {}", (Object)webSocket.uuid());
            try {
                if (webSocket.closeFuture() != null) {
                    webSocket.closeFuture().cancel(true);
                }
                this.webSocketProcessor.close(webSocket, 1005);
            }
            catch (Exception ex) {
                logger.error("{}", (Object)webSocket, (Object)ex);
            }
        } else if (State.class.isAssignableFrom(o.getClass())) {
            logger.trace("State {}", o);
            State s = (State)State.class.cast(o);
            if (s.action.type() == Action.TYPE.SUSPEND) {
                this.asynchronousProcessor.endRequest(s.resource(), true);
            }
        } else {
            logger.error("Invalid state {} and Channel {}", o, (Object)ctx.channel());
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        if (e.getCause() != null && (e.getCause().getClass().equals(ClosedChannelException.class) || e.getCause().getClass().equals(IOException.class))) {
            logger.trace("Exception", e.getCause());
        } else if (e.getCause() != null && e.getCause().getClass().equals(TooLongFrameException.class)) {
            logger.error("TooLongFrameException. The request will be closed, make sure you increase the Config.maxChunkContentLength() to a higher value.", e.getCause());
            super.exceptionCaught(ctx, e);
        } else {
            logger.debug("Exception", e.getCause());
            super.exceptionCaught(ctx, e);
        }
    }

    private Map<String, String> getHeaders(HttpRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String name : request.headers().names()) {
            headers.put(name, HttpHeaders.getHeader((HttpMessage)request, (String)name));
        }
        return headers;
    }

    private String getBaseUri(HttpRequest request) {
        return "http://" + HttpHeaders.getHeader((HttpMessage)request, (String)"Host", (String)"127.0.0.1") + "/";
    }

    private void parseQueryString(Map<String, String[]> qs, String queryString) {
        if (queryString != null) {
            String[] s;
            for (String a : s = queryString.split("&")) {
                String[] q = a.split("=");
                String[] z = new String[]{q.length > 1 ? q[1] : ""};
                qs.put(q[0], z);
            }
        }
    }

    private Set<javax.servlet.http.Cookie> getCookies(HttpRequest request) {
        HashSet<javax.servlet.http.Cookie> result = new HashSet<javax.servlet.http.Cookie>();
        String cookieHeader = request.headers().get("Cookie");
        if (cookieHeader != null) {
            Set cookies = ServerCookieDecoder.LAX.decode(cookieHeader);
            for (Cookie cookie : cookies) {
                javax.servlet.http.Cookie c = new javax.servlet.http.Cookie(cookie.name(), cookie.value());
                if (cookie.domain() != null) {
                    c.setDomain(cookie.domain());
                }
                c.setHttpOnly(cookie.isHttpOnly());
                c.setMaxAge((int)cookie.maxAge());
                if (cookie.path() != null) {
                    c.setPath(cookie.path());
                }
                c.setSecure(cookie.isSecure());
                result.add(c);
            }
        }
        return result;
    }

    Config config() {
        return this.config;
    }

    private void sendHttpResponse(ChannelHandlerContext ctx, HttpRequest req, HttpResponse res) {
        if (res.getStatus().code() != 200) {
            FullHttpResponse response = (FullHttpResponse)res;
            response.content().writeBytes(Unpooled.copiedBuffer((CharSequence)res.getStatus().toString(), (Charset)CharsetUtil.UTF_8));
            HttpHeaders.setContentLength((HttpMessage)res, (long)response.content().readableBytes());
        }
        ChannelFuture f = ctx.channel().write((Object)res);
        if (!HttpHeaders.isKeepAlive((HttpMessage)req) || res.getStatus().code() != 200) {
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private String getWebSocketLocation(HttpRequest req) {
        return "ws://" + req.headers().get("Host") + req.getUri();
    }

    public ChannelGroup httpChannels() {
        return this.httpChannels;
    }

    public ChannelGroup websocketChannels() {
        return this.websocketChannels;
    }

    static {
        try {
            Class.forName("io.netty.channel.ChannelId");
            NETTY_41_PLUS = true;
        }
        catch (ClassNotFoundException e) {
            NETTY_41_PLUS = false;
        }
        KEEP_ALIVE = BridgeRuntime.class.getName() + "_keep-alive";
        logger = LoggerFactory.getLogger(BridgeRuntime.class);
    }

    private static final class NettyServletConfig
    implements ServletConfig {
        private final Map<String, String> initParams;
        private final ServletContext ctx;

        public NettyServletConfig(Map<String, String> initParams, ServletContext ctx) {
            this.initParams = initParams;
            this.ctx = ctx;
        }

        public String getServletName() {
            return "Netty";
        }

        public ServletContext getServletContext() {
            return this.ctx;
        }

        public String getInitParameter(String name) {
            return this.initParams.get(name);
        }

        public Enumeration getInitParameterNames() {
            return Collections.enumeration(this.initParams.keySet());
        }
    }

    public static final class State {
        final AtmosphereRequest request;
        final Action action;

        public State(AtmosphereRequest request, Action action) {
            this.request = request;
            this.action = action;
        }

        public AtmosphereResourceImpl resource() {
            return (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(this.request.resource());
        }
    }
}

