/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import java.io.IOException;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.nettosphere.ChannelWriter;
import org.atmosphere.nettosphere.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamWriter
extends ChannelWriter {
    private static final Logger logger = LoggerFactory.getLogger(StreamWriter.class);
    private ByteBuf chainedBodyBuffer;

    public StreamWriter(Channel channel, boolean writeHeader, boolean keepAlive) {
        super(channel, writeHeader, keepAlive);
        this.setUpBuffers();
    }

    @Override
    public AsyncIOWriter asyncWrite(AtmosphereResponse response, byte[] data, int offset, int length) throws IOException {
        this.chainedBodyBuffer = Unpooled.wrappedBuffer(this.chainedBodyBuffer, Unpooled.wrappedBuffer(data, offset, length));
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    private void setUpBuffers() {
        if (this.chainedBodyBuffer == null) {
            this.chainedBodyBuffer = Unpooled.EMPTY_BUFFER;
        }
    }

    @Override
    public void close(AtmosphereResponse response) throws IOException {
        if (this.doneProcessing.getAndSet(true) || !this.channel.isOpen()) {
            throw Utils.ioExceptionForChannel(this.channel, response.uuid());
        }
        logger.trace("About to flush to {} for {}", (Object)this.channel, (Object)response.uuid());
        ByteBuf statusAndHeadersBuffer = this.writeHeader ? Unpooled.wrappedBuffer(this.constructStatusAndHeaders(response, this.chainedBodyBuffer.readableBytes()).getBytes("UTF-8")) : Unpooled.EMPTY_BUFFER;
        ByteBuf drain = Unpooled.wrappedBuffer(statusAndHeadersBuffer, this.chainedBodyBuffer);
        this.channel.writeAndFlush(drain).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                StreamWriter.this.chainedBodyBuffer = null;
                if (!StreamWriter.this.keepAlive) {
                    StreamWriter.this.channel.close().awaitUninterruptibly();
                }
            }
        });
    }
}

