/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOInterceptorAdapter;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereRequestImpl;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResourceHeartbeatEventListener;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.HeartbeatAtmosphereResourceEvent;
import org.atmosphere.interceptor.AllowInterceptor;
import org.atmosphere.util.ExecutorsFactory;
import org.atmosphere.util.IOUtils;
import org.atmosphere.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatInterceptor
extends AtmosphereInterceptorAdapter {
    public static final String INTERCEPTOR_ADDED = HeartbeatInterceptor.class.getName();
    public static final String HEARTBEAT_FUTURE = "heartbeat.future";
    private static final Logger logger = LoggerFactory.getLogger(HeartbeatInterceptor.class);
    private ScheduledExecutorService heartBeat;
    private byte[] paddingBytes = "X".getBytes();
    private boolean resumeOnHeartbeat;
    private int heartbeatFrequencyInSeconds = 60;
    private AtmosphereConfig config;
    private final AtomicBoolean destroyed = new AtomicBoolean(false);
    private boolean flushBuffer = true;
    private int clientHeartbeatFrequencyInSeconds;

    public HeartbeatInterceptor paddingText(byte[] paddingBytes) {
        this.paddingBytes = paddingBytes;
        return this;
    }

    public byte[] getPaddingBytes() {
        return this.paddingBytes;
    }

    public HeartbeatInterceptor heartbeatFrequencyInSeconds(int heartbeatFrequencyInSeconds) {
        this.heartbeatFrequencyInSeconds = heartbeatFrequencyInSeconds;
        return this;
    }

    public int heartbeatFrequencyInSeconds() {
        return this.heartbeatFrequencyInSeconds;
    }

    public int clientHeartbeatFrequencyInSeconds() {
        return this.clientHeartbeatFrequencyInSeconds;
    }

    public HeartbeatInterceptor clientHeartbeatFrequencyInSeconds(int clientHeartbeatFrequencyInSeconds) {
        this.clientHeartbeatFrequencyInSeconds = clientHeartbeatFrequencyInSeconds;
        return this;
    }

    public boolean resumeOnHeartbeat() {
        return this.resumeOnHeartbeat;
    }

    public HeartbeatInterceptor resumeOnHeartbeat(boolean resumeOnHeartbeat) {
        this.resumeOnHeartbeat = resumeOnHeartbeat;
        return this;
    }

    @Override
    public void configure(AtmosphereConfig config) {
        String s = config.getInitParameter("org.atmosphere.interceptor.HeartbeatInterceptor.heartbeatFrequencyInSeconds");
        if (s != null) {
            this.heartbeatFrequencyInSeconds = Integer.valueOf(s);
        }
        if ((s = config.getInitParameter("org.atmosphere.interceptor.HeartbeatInterceptor.paddingChar")) != null) {
            try {
                this.paddingBytes = s.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error("", e);
            }
        }
        if ((s = config.getInitParameter("org.atmosphere.interceptor.HeartbeatInterceptor.clientHeartbeatFrequencyInSeconds")) != null) {
            this.clientHeartbeatFrequencyInSeconds = Integer.valueOf(s);
        }
        if ((s = config.getInitParameter("org.atmosphere.interceptor.HeartbeatInterceptor.flushBuffer")) != null) {
            this.flushBuffer = Boolean.valueOf(s);
        }
        this.heartBeat = ExecutorsFactory.getScheduler(config);
        this.resumeOnHeartbeat = config.getInitParameter("org.atmosphere.interceptor.HeartbeatInterceptor.resumeOnHeartbeat", true);
        logger.info("HeartbeatInterceptor configured with padding value '{}', client frequency {} seconds and server frequency {} seconds", new String(this.paddingBytes), String.valueOf(this.heartbeatFrequencyInSeconds), String.valueOf(this.clientHeartbeatFrequencyInSeconds));
        this.config = config;
    }

    @Override
    public Action inspect(final AtmosphereResource r) {
        AtmosphereRequestImpl.Body body;
        AtmosphereResourceImpl impl = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r);
        final AtmosphereRequest request = impl.getRequest(false);
        final AtmosphereResponse response = impl.getResponse(false);
        if (this.clientHeartbeatFrequencyInSeconds > 0 && ((body = request.body()).isEmpty() || body.hasString() && body.asString().length() <= this.paddingBytes.length || body.hasBytes() && body.byteLength() == this.paddingBytes.length)) {
            byte[] bytes;
            try {
                bytes = IOUtils.forceReadEntirelyAsByte(r);
            }
            catch (IOException e) {
                logger.warn("", e);
                this.cancelF(request);
                return Action.CONTINUE;
            }
            if (Arrays.equals(this.paddingBytes, bytes)) {
                HeartbeatAtmosphereResourceEvent event = new HeartbeatAtmosphereResourceEvent((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r));
                if (AtmosphereResourceHeartbeatEventListener.class.isAssignableFrom(r.getAtmosphereHandler().getClass())) {
                    r.addEventListener(new AtmosphereResourceEventListenerAdapter.OnHeartbeat(){

                        @Override
                        public void onHeartbeat(AtmosphereResourceEvent event) {
                            ((AtmosphereResourceHeartbeatEventListener)AtmosphereResourceHeartbeatEventListener.class.cast(r.getAtmosphereHandler())).onHeartbeat(event);
                        }
                    });
                }
                r.notifyListeners(event);
                return Action.CANCELLED;
            }
            if (body.isEmpty()) {
                request.body(bytes);
            }
        }
        if (Utils.webSocketMessage(r)) {
            return Action.CONTINUE;
        }
        final int interval = this.extractHeartbeatInterval(impl);
        if (interval != 0) {
            boolean wasSuspended;
            if (!Utils.pollableTransport(r.transport()) && r.transport() != AtmosphereResource.TRANSPORT.UNDEFINED) {
                super.inspect(r);
                wasSuspended = r.isSuspended();
                if (wasSuspended) {
                    this.clock(interval, r, request, response);
                }
            } else {
                return Action.CONTINUE;
            }
            r.addEventListener(new Clock(){

                @Override
                public void onSuspend(AtmosphereResourceEvent event) {
                    if (!wasSuspended) {
                        HeartbeatInterceptor.this.clock(interval, r, request, response);
                    }
                }

                @Override
                public void onResume(AtmosphereResourceEvent event) {
                    HeartbeatInterceptor.this.cancelF(request);
                }

                @Override
                public void onDisconnect(AtmosphereResourceEvent event) {
                    HeartbeatInterceptor.this.cancelF(request);
                }

                @Override
                public void onClose(AtmosphereResourceEvent event) {
                    HeartbeatInterceptor.this.cancelF(request);
                }
            });
            AsyncIOWriter writer = response.getAsyncIOWriter();
            if (!Utils.resumableTransport(r.transport()) && AtmosphereInterceptorWriter.class.isAssignableFrom(writer.getClass()) && request.getAttribute(INTERCEPTOR_ADDED) == null) {
                ((AtmosphereInterceptorWriter)AtmosphereInterceptorWriter.class.cast(writer)).interceptor(new AsyncIOInterceptorAdapter(){

                    @Override
                    public byte[] transformPayload(AtmosphereResponse response, byte[] responseDraft, byte[] data) throws IOException {
                        HeartbeatInterceptor.this.cancelF(request);
                        return responseDraft;
                    }

                    @Override
                    public void postPayload(AtmosphereResponse response, byte[] data, int offset, int length) {
                        logger.trace("Scheduling heartbeat for {}", (Object)r.uuid());
                        HeartbeatInterceptor.this.clock(interval, r, request, response);
                    }
                });
                request.setAttribute(INTERCEPTOR_ADDED, Boolean.TRUE);
            }
        }
        return Action.CONTINUE;
    }

    protected int extractHeartbeatInterval(AtmosphereResourceImpl resource) {
        int interval = this.heartbeatFrequencyInSeconds;
        String s = resource.getRequest(false).getHeader("X-Heartbeat-Server");
        if (s != null) {
            try {
                interval = Integer.parseInt(s);
                if (interval != 0 && interval < this.heartbeatFrequencyInSeconds) {
                    interval = this.heartbeatFrequencyInSeconds;
                }
            }
            catch (NumberFormatException nfe) {
                logger.warn("{} header is not an integer", (Object)"X-Heartbeat-Server", (Object)nfe);
            }
        }
        return interval;
    }

    void cancelF(AtmosphereRequest request) {
        try {
            Future f = (Future)request.getAttribute(HEARTBEAT_FUTURE);
            if (f != null) {
                f.cancel(false);
            }
            request.removeAttribute(HEARTBEAT_FUTURE);
        }
        catch (Exception ex) {
            logger.trace("", ex);
        }
    }

    public HeartbeatInterceptor clock(int interval, final AtmosphereResource r, final AtmosphereRequest request, final AtmosphereResponse response) {
        try {
            request.setAttribute(HEARTBEAT_FUTURE, this.heartBeat.schedule(new Callable<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object call() throws Exception {
                    AtmosphereResource atmosphereResource = r;
                    synchronized (atmosphereResource) {
                        if (((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).isInScope() && r.isSuspended()) {
                            try {
                                logger.trace("Heartbeat for Resource {}", (Object)r);
                                response.write(HeartbeatInterceptor.this.paddingBytes, false);
                                if (Utils.resumableTransport(r.transport()) && HeartbeatInterceptor.this.resumeOnHeartbeat) {
                                    r.resume();
                                } else if (HeartbeatInterceptor.this.flushBuffer) {
                                    response.flushBuffer();
                                }
                            }
                            catch (Throwable t) {
                                logger.trace("{}", (Object)r.uuid(), (Object)t);
                                HeartbeatInterceptor.this.cancelF(request);
                            }
                        } else {
                            HeartbeatInterceptor.this.cancelF(request);
                        }
                    }
                    return null;
                }
            }, (long)interval, TimeUnit.SECONDS));
        }
        catch (Throwable t) {
            logger.warn("", t);
        }
        return this;
    }

    @Override
    public String toString() {
        return "Heartbeat Interceptor Support";
    }

    @Override
    public void destroy() {
        if (this.destroyed.getAndSet(true)) {
            return;
        }
        for (AtmosphereResource r : this.config.resourcesFactory().findAll()) {
            this.cancelF(r.getRequest());
        }
    }

    private static class Clock
    extends AtmosphereResourceEventListenerAdapter
    implements AllowInterceptor {
    }
}

